/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.tileentity;

import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import net.blay09.mods.waystones.api.IWaystone;
import net.blay09.mods.waystones.block.WaystoneBlock;
import net.blay09.mods.waystones.container.WaystoneSelectionContainer;
import net.blay09.mods.waystones.container.WaystoneSettingsContainer;
import net.blay09.mods.waystones.core.InvalidWaystone;
import net.blay09.mods.waystones.core.PlayerWaystoneManager;
import net.blay09.mods.waystones.core.WarpMode;
import net.blay09.mods.waystones.core.Waystone;
import net.blay09.mods.waystones.core.WaystoneManager;
import net.blay09.mods.waystones.core.WaystoneProxy;
import net.blay09.mods.waystones.tileentity.ModTileEntities;
import net.blay09.mods.waystones.worldgen.namegen.NameGenerator;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class WaystoneTileEntity
extends TileEntity {
    private IWaystone waystone = InvalidWaystone.INSTANCE;
    private boolean shouldNotInitialize;

    public WaystoneTileEntity() {
        super(ModTileEntities.waystone);
    }

    public CompoundNBT func_189515_b(CompoundNBT tagCompound) {
        super.func_189515_b(tagCompound);
        IWaystone waystone = this.getWaystone();
        if (waystone.isValid()) {
            tagCompound.func_218657_a("UUID", (INBT)NBTUtil.func_240626_a_((UUID)waystone.getWaystoneUid()));
        }
        return tagCompound;
    }

    public void func_230337_a_(BlockState state, CompoundNBT tagCompound) {
        super.func_230337_a_(state, tagCompound);
        if (tagCompound.func_150297_b("UUID", 11)) {
            this.waystone = new WaystoneProxy(NBTUtil.func_186860_b((INBT)Objects.requireNonNull(tagCompound.func_74781_a("UUID"))));
        }
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        super.onDataPacket(net, pkt);
        this.func_230337_a_(this.func_195044_w(), pkt.func_148857_g());
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 0, this.func_189517_E_());
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), (double)(this.field_174879_c.func_177958_n() + 1), (double)(this.field_174879_c.func_177956_o() + 2), (double)(this.field_174879_c.func_177952_p() + 1));
    }

    public IWaystone getWaystone() {
        BlockState state;
        if (!this.waystone.isValid() && this.field_145850_b != null && !this.field_145850_b.field_72995_K && !this.shouldNotInitialize && (state = this.func_195044_w()).func_177230_c() instanceof WaystoneBlock) {
            TileEntity tileEntity;
            DoubleBlockHalf half = (DoubleBlockHalf)state.func_177229_b(WaystoneBlock.HALF);
            if (half == DoubleBlockHalf.LOWER) {
                this.initializeWaystone((IWorld)Objects.requireNonNull(this.field_145850_b), null, true);
            } else if (half == DoubleBlockHalf.UPPER && (tileEntity = this.field_145850_b.func_175625_s(this.field_174879_c.func_177977_b())) instanceof WaystoneTileEntity) {
                this.initializeFromBase((WaystoneTileEntity)tileEntity);
            }
        }
        return this.waystone;
    }

    public void initializeWaystone(IWorld world, @Nullable LivingEntity player, boolean wasGenerated) {
        Waystone waystone = new Waystone(UUID.randomUUID(), (RegistryKey<World>)world.func_201672_e().func_234923_W_(), this.field_174879_c, wasGenerated, player != null ? player.func_110124_au() : null);
        String name = NameGenerator.get().getName(waystone, world.func_201674_k());
        waystone.setName(name);
        WaystoneManager.get().addWaystone(waystone);
        this.waystone = waystone;
    }

    public void initializeFromBase(WaystoneTileEntity tileEntity) {
        this.waystone = tileEntity.getWaystone();
    }

    public void uninitializeWaystone() {
        if (this.waystone.isValid()) {
            WaystoneManager.get().removeWaystone(this.waystone);
            PlayerWaystoneManager.removeKnownWaystone(this.waystone);
        }
        this.waystone = InvalidWaystone.INSTANCE;
        this.shouldNotInitialize = true;
        DoubleBlockHalf half = (DoubleBlockHalf)this.func_195044_w().func_177229_b(WaystoneBlock.HALF);
        BlockPos otherPos = half == DoubleBlockHalf.UPPER ? this.field_174879_c.func_177977_b() : this.field_174879_c.func_177984_a();
        TileEntity tileEntity = Objects.requireNonNull(this.field_145850_b).func_175625_s(otherPos);
        if (tileEntity instanceof WaystoneTileEntity) {
            WaystoneTileEntity waystoneTile = (WaystoneTileEntity)tileEntity;
            waystoneTile.waystone = InvalidWaystone.INSTANCE;
            waystoneTile.shouldNotInitialize = true;
        }
    }

    public INamedContainerProvider getWaystoneSelectionContainerProvider() {
        return new INamedContainerProvider(){

            public ITextComponent func_145748_c_() {
                return new TranslationTextComponent("container.waystones.waystone_selection");
            }

            public Container createMenu(int i, PlayerInventory playerInventory, PlayerEntity playerEntity) {
                return new WaystoneSelectionContainer(i, WarpMode.WAYSTONE_TO_WAYSTONE, WaystoneTileEntity.this.getWaystone());
            }
        };
    }

    public INamedContainerProvider getWaystoneSettingsContainerProvider() {
        return new INamedContainerProvider(){

            public ITextComponent func_145748_c_() {
                return new TranslationTextComponent("container.waystones.waystone_settings");
            }

            public Container createMenu(int i, PlayerInventory playerInventory, PlayerEntity playerEntity) {
                return new WaystoneSettingsContainer(i, WaystoneTileEntity.this.getWaystone());
            }
        };
    }
}

