/*
 * Decompiled with CFR 0.152.
 */
package com.matez.wildnature.client.gui.screen;

import com.matez.wildnature.init.WN;
import com.matez.wildnature.util.other.Utilities;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Objects;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.chat.NarratorChatListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.chunk.listener.TrackingChunkStatusListener;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class WNWorldLoadProgressScreen
extends Screen {
    private final TrackingChunkStatusListener progress;
    private long field_213041_b = -1L;
    public int color;
    public ArrayList<BlockPoint> blockPoints;
    public ArrayList<BlockPoint> coloredPoints;
    public ChunkStatus currentChunkStatus = null;
    private int points = 0;
    private String loadText = "Loading world";
    private boolean drawn = false;
    private boolean rendered = false;
    private boolean building = false;
    private boolean joining = false;
    private boolean closing = false;
    private Thread t;
    private static final Object2IntMap<ChunkStatus> COLORS = (Object2IntMap)Util.func_200696_a((Object)new Object2IntOpenHashMap(), p_213039_0_ -> {
        p_213039_0_.defaultReturnValue(0);
        p_213039_0_.put((Object)ChunkStatus.field_223226_a_, 0x545454);
        p_213039_0_.put((Object)ChunkStatus.field_222606_b, 0x999999);
        p_213039_0_.put((Object)ChunkStatus.field_222607_c, 6250897);
        p_213039_0_.put((Object)ChunkStatus.field_222608_d, 8434258);
        p_213039_0_.put((Object)ChunkStatus.field_222609_e, 0xD1D1D1);
        p_213039_0_.put((Object)ChunkStatus.field_222610_f, 7497737);
        p_213039_0_.put((Object)ChunkStatus.field_222611_g, 7169628);
        p_213039_0_.put((Object)ChunkStatus.field_222612_h, 3159410);
        p_213039_0_.put((Object)ChunkStatus.field_222613_i, 2213376);
        p_213039_0_.put((Object)ChunkStatus.field_222614_j, 0xCCCCCC);
        p_213039_0_.put((Object)ChunkStatus.field_222615_k, 15884384);
        p_213039_0_.put((Object)ChunkStatus.field_222616_l, 0xEEEEEE);
        p_213039_0_.put((Object)ChunkStatus.field_222617_m, 0xFFFFFF);
    });

    public WNWorldLoadProgressScreen(TrackingChunkStatusListener track) {
        super((ITextComponent)new StringTextComponent("WNWorldLoadProgressScreen"));
        this.progress = track;
        this.blockPoints = new ArrayList();
        this.coloredPoints = new ArrayList();
    }

    public boolean shouldCloseOnEsc() {
        return false;
    }

    public void removed() {
        NarratorChatListener.field_193643_a.func_216864_a(I18n.func_135052_a((String)"narrator.loading.done", (Object[])new Object[0]));
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        this.renderBackground();
        String lvt_4_1_ = MathHelper.func_76125_a((int)this.progress.func_219524_e(), (int)0, (int)100) + "%";
        long lvt_5_1_ = Util.func_211177_b();
        if (lvt_5_1_ - this.field_213041_b > 2000L) {
            this.field_213041_b = lvt_5_1_;
            NarratorChatListener.field_193643_a.func_216864_a(new TranslationTextComponent("narrator.loading", new Object[]{lvt_4_1_}).getString());
        }
        int centerWidth = this.width / 2;
        int centerHeight = this.height / 2;
        this.renderChunks(this.progress, centerWidth, centerHeight, this.width, this.height);
        WNWorldLoadProgressScreen.drawChunkIndicator(this.progress, centerWidth, centerHeight + 30, 2, 0);
        FontRenderer var10001 = this.font;
        this.drawCenteredString(var10001, lvt_4_1_, centerWidth, centerHeight - 4 + 30, 0xFFFFFF);
        this.drawLoading(centerWidth, centerHeight - 30);
    }

    public void drawLoading(int centerWidth, int centerHeight) {
        ++this.points;
        String sp = "";
        if (this.points >= 0 && this.points < 30) {
            sp = "";
        } else if (this.points >= 30 && this.points < 60) {
            sp = ".";
        } else if (this.points >= 60 && this.points < 90) {
            sp = "..";
        } else if (this.points >= 90 && this.points < 120) {
            sp = "...";
        } else {
            this.points = 0;
        }
        this.drawCenteredString(this.font, this.loadText + sp, centerWidth, centerHeight - 4, 0xFFFFFF);
    }

    public void resize(Minecraft p_resize_1_, int p_resize_2_, int p_resize_3_) {
        super.resize(p_resize_1_, p_resize_2_, p_resize_3_);
        this.coloredPoints.clear();
        this.drawn = false;
        this.building = false;
        this.joining = false;
    }

    public void onClose() {
        this.closing = true;
        if (this.t != null) {
            this.t.stop();
        }
    }

    public void renderChunks(TrackingChunkStatusListener progress, int centerX, int centerY, int maxX, int maxY) {
        if (WN.runningWorld != null && WN.runningWorld.func_201675_m() != null) {
            try {
                BlockPos center = WN.runningWorld.func_175694_M();
                int blockSize = 10;
                if (!this.drawn) {
                    this.loadText = "Rendering terrain";
                    this.points = 0;
                    this.drawBackground(centerX, centerY, maxX, maxY, blockSize, center.func_177958_n(), center.func_177952_p());
                    this.drawn = true;
                }
                if (this.currentChunkStatus == null || !this.currentChunkStatus.func_222596_d().equals(Objects.requireNonNull(progress.func_219525_a(WN.runningWorld.func_175726_f((BlockPos)center).func_76632_l().field_77276_a, WN.runningWorld.func_175726_f((BlockPos)center).func_76632_l().field_77275_b)).func_222596_d())) {
                    final WNWorldLoadProgressScreen self = this;
                    this.t = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                int i = 0;
                                for (BlockPoint blockPoint : self.blockPoints) {
                                    if (blockPoint.isColorProper()) continue;
                                    if (self.closing) break;
                                    try {
                                        if (WN.runningWorld.isAreaLoaded(new BlockPos(blockPoint.getPosX(), 63, blockPoint.getPosZ()), 1)) {
                                            blockPoint.setColorProper(true);
                                            self.coloredPoints.add(blockPoint.withColor(WNWorldLoadProgressScreen.this.getColor(blockPoint.getPosX(), blockPoint.getPosZ())));
                                        }
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                    ++i;
                                }
                                if (!WNWorldLoadProgressScreen.this.building) {
                                    WNWorldLoadProgressScreen.this.loadText = "Building terrain";
                                    WNWorldLoadProgressScreen.this.points = 0;
                                    WNWorldLoadProgressScreen.this.building = true;
                                }
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    });
                    this.t.start();
                    this.rendered = true;
                }
                if (MathHelper.func_76125_a((int)this.progress.func_219524_e(), (int)0, (int)100) == 100 && !this.joining) {
                    this.loadText = "Joining world";
                    this.points = 0;
                    this.joining = true;
                }
                ArrayList<BlockPoint> cp = new ArrayList<BlockPoint>(this.coloredPoints);
                Iterator<BlockPoint> iterator = this.blockPoints.iterator();
                while (iterator.hasNext()) {
                    BlockPoint blockPoint;
                    BlockPoint p = blockPoint = iterator.next();
                    for (BlockPoint coloredPoint : cp) {
                        if (blockPoint.getPosX() != coloredPoint.getPosX() || blockPoint.getPosZ() != coloredPoint.getPosZ()) continue;
                        if (coloredPoint.getColor() != 0 || !coloredPoint.isColorProper()) {
                            p.setColor(coloredPoint.getColor());
                            break;
                        }
                        p.setColor(Utilities.getColorValue(5588537));
                    }
                    if (!p.checkColor()) continue;
                    WNWorldLoadProgressScreen.fill((int)p.getStartX(), (int)p.getStartY(), (int)p.getEndX(), (int)p.getEndY(), (int)p.getColor());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void fillWithColor(int startX, int startY, int endX, int endY, int posX, int posZ) {
        this.getColorV(posX, posZ);
        int c = this.color == 0 ? Utilities.getColorValue(0x313131) : this.color;
        WNWorldLoadProgressScreen.fill((int)startX, (int)startY, (int)endX, (int)endY, (int)c);
    }

    public void fillWithColor(int startX, int startY, int endX, int endY, int color) {
        WNWorldLoadProgressScreen.fill((int)startX, (int)startY, (int)endX, (int)endY, (int)color);
    }

    public int getHeight(int x, int z, World world) {
        for (int i = world.func_217301_I(); i > 1; --i) {
            Block b = world.func_180495_p(new BlockPos(x, i, z)).func_177230_c();
            if (b == null || b == Blocks.field_150350_a || b == Blocks.field_201940_ji || b == Blocks.field_201941_jj) continue;
            return i;
        }
        return 1;
    }

    public void drawBackground(int centerWidth, int centerHeight, int maxWidth, int maxHeight, int size, int posX, int posZ) {
        this.blockPoints = new ArrayList();
        int x = centerWidth;
        int y = centerHeight;
        int pX = posX;
        int pZ = posZ;
        while (x > 0) {
            this.drawVertical(x -= size, y, maxWidth, maxHeight, size, --pX, pZ);
        }
        x = centerWidth;
        y = centerHeight;
        pX = posX;
        pZ = posZ;
        while (x < maxWidth + size) {
            this.drawVertical(x += size, y, maxWidth, maxHeight, size, ++pX, pZ);
        }
    }

    private void drawVertical(int centerWidth, int centerHeight, int maxWidth, int maxHeight, int size, int posX, int posZ) {
        BlockPoint b;
        int x = centerWidth;
        int y = centerHeight;
        int pX = posX;
        int pZ = posZ;
        while (y > 0) {
            b = new BlockPoint(x + size, (y -= size) + size, x - size, y - size, pX, --pZ);
            this.blockPoints.add(b);
        }
        x = centerWidth;
        y = centerHeight;
        pX = posX;
        pZ = posZ;
        while (y < maxHeight + size) {
            b = new BlockPoint(x + size, (y += size) + size, x - size, y - size, pX, ++pZ);
            this.blockPoints.add(b);
        }
    }

    public void getColorV(int posX, int posZ) {
        this.color = Utilities.getColorValue(WN.runningWorld.func_180495_p((BlockPos)new BlockPos((int)posX, (int)this.getHeight((int)posX, (int)posZ, (World)WN.runningWorld), (int)posZ)).func_177230_c().func_180659_g(null, null, null).field_76291_p);
    }

    public int getColor(int posX, int posZ) {
        BlockPos blockPos = new BlockPos(posX, this.getHeight(posX, posZ, WN.runningWorld), posZ);
        Block b = WN.runningWorld.func_180495_p(blockPos).func_177230_c();
        try {
            return Utilities.getColorValue(Integer.decode("0x" + Utilities.blendColors(Color.decode(b.func_180659_g(null, null, null).field_76291_p + ""), blockPos.func_177956_o() > WN.runningWorld.func_181545_F() ? Color.WHITE : Color.BLACK, (float)(blockPos.func_177956_o() / WN.runningWorld.func_217301_I()) / 4.0f + 0.8f)));
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public static void drawChunkIndicator(TrackingChunkStatusListener p_213038_0_, int p_213038_1_, int p_213038_2_, int p_213038_3_, int p_213038_4_) {
        int i = p_213038_3_ + p_213038_4_;
        int j = p_213038_0_.func_219522_c();
        int k = j * i - p_213038_4_;
        int l = p_213038_0_.func_219523_d();
        int i1 = l * i - p_213038_4_;
        int j1 = p_213038_1_ - i1 / 2;
        int k1 = p_213038_2_ - i1 / 2;
        int l1 = k / 2 + 1;
        int i2 = -16772609;
        if (p_213038_4_ != 0) {
            WNWorldLoadProgressScreen.fill((int)(p_213038_1_ - l1), (int)(p_213038_2_ - l1), (int)(p_213038_1_ - l1 + 1), (int)(p_213038_2_ + l1), (int)-16772609);
            WNWorldLoadProgressScreen.fill((int)(p_213038_1_ + l1 - 1), (int)(p_213038_2_ - l1), (int)(p_213038_1_ + l1), (int)(p_213038_2_ + l1), (int)-16772609);
            WNWorldLoadProgressScreen.fill((int)(p_213038_1_ - l1), (int)(p_213038_2_ - l1), (int)(p_213038_1_ + l1), (int)(p_213038_2_ - l1 + 1), (int)-16772609);
            WNWorldLoadProgressScreen.fill((int)(p_213038_1_ - l1), (int)(p_213038_2_ + l1 - 1), (int)(p_213038_1_ + l1), (int)(p_213038_2_ + l1), (int)-16772609);
        }
        for (int j2 = 0; j2 < l; ++j2) {
            for (int k2 = 0; k2 < l; ++k2) {
                ChunkStatus chunkstatus = p_213038_0_.func_219525_a(j2, k2);
                int l2 = j1 + j2 * i;
                int i3 = k1 + k2 * i;
                WNWorldLoadProgressScreen.fill((int)l2, (int)i3, (int)(l2 + p_213038_3_), (int)(i3 + p_213038_3_), (int)(COLORS.getInt((Object)chunkstatus) | 0xFF000000));
            }
        }
    }

    public static class BlockPoint {
        private int startX;
        private int startY;
        private int endX;
        private int endY;
        private int posX;
        private int posZ;
        private int color;
        private boolean colorProper = false;

        public BlockPoint(int startX, int startY, int endX, int endY, int posX, int posZ) {
            this.startX = startX;
            this.startY = startY;
            this.endX = endX;
            this.endY = endY;
            this.posX = posX;
            this.posZ = posZ;
        }

        public int getEndX() {
            return this.endX;
        }

        public int getEndY() {
            return this.endY;
        }

        public int getPosX() {
            return this.posX;
        }

        public int getPosZ() {
            return this.posZ;
        }

        public int getStartX() {
            return this.startX;
        }

        public int getStartY() {
            return this.startY;
        }

        public int getColor() {
            return this.color;
        }

        public void setColor(int color) {
            this.color = color;
        }

        public BlockPoint withColor(int color) {
            this.color = color;
            return this;
        }

        public boolean checkColor() {
            return this.color != 0;
        }

        public boolean isColorProper() {
            return this.colorProper;
        }

        public void setColorProper(boolean colorProper) {
            this.colorProper = colorProper;
        }
    }
}

