/*
 * Decompiled with CFR 0.152.
 */
package com.matez.wildnature.client.gui.screen.world;

import com.matez.wildnature.client.gui.screen.world.settings.WorldSettings;
import com.matez.wildnature.util.other.Utilities;
import net.minecraft.client.gui.chat.NarratorChatListener;
import net.minecraft.client.gui.screen.CreateWorldScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;

public class WNWorldSettingsScreen
extends Screen {
    public static int SETTINGS_SIZE = 300;
    public static int BUTTON_DISTANCE = 10;
    public static int BUTTON_SIZE = 20;
    public static int MARGIN = 20;
    private static String logMessage = "";
    private CreateWorldScreen parent;
    private CompoundNBT nbt;
    private WorldSettings worldSettings;
    private int centerWidth;
    private int centerHeight;
    private String header = TextFormatting.BOLD + "WildNature Terrain Generator";
    private String version = "Version 0.1 --- " + TextFormatting.RED + " WORK IN PROGRESS - press ESC to exit";
    private Button saveButton;
    private Button cancelButton;
    private Button savePresetButton;

    public WNWorldSettingsScreen(CreateWorldScreen parentScreen, CompoundNBT nbt) {
        super((ITextComponent)new StringTextComponent("WildNature Terrain Generator"));
        this.parent = parentScreen;
        this.nbt = nbt;
    }

    public void removed() {
        NarratorChatListener.field_193643_a.func_216864_a(I18n.func_135052_a((String)"narrator.loading.done", (Object[])new Object[0]));
    }

    public static void fill(int x1, int y1, int x2, int y2) {
        WNWorldSettingsScreen.fill((int)x1, (int)y1, (int)x2, (int)y2, (int)-1072689136);
    }

    public static void fillColor(int x1, int y1, int x2, int y2, int hex) {
        WNWorldSettingsScreen.fill((int)x1, (int)y1, (int)x2, (int)y2, (int)Utilities.getColorValue(hex));
    }

    public boolean shouldCloseOnEsc() {
        return true;
    }

    protected void init() {
        this.centerWidth = this.width / 2;
        this.centerHeight = this.height / 2;
        SETTINGS_SIZE = this.width / 3;
        if (SETTINGS_SIZE > 300) {
            SETTINGS_SIZE = 300;
        }
        int buttonSize = 100;
        this.savePresetButton = new Button(this.width - MARGIN - buttonSize, this.height - MARGIN * 2 + MARGIN, buttonSize, BUTTON_SIZE, "Save as preset", press -> {});
        this.addButton((Widget)this.savePresetButton);
        this.cancelButton = new Button(this.width - MARGIN - buttonSize - BUTTON_DISTANCE - BUTTON_DISTANCE - buttonSize, this.height - MARGIN * 2 + MARGIN, buttonSize, BUTTON_SIZE, "Cancel", press -> {});
        this.addButton((Widget)this.cancelButton);
        this.saveButton = new Button(this.width - MARGIN - buttonSize - BUTTON_DISTANCE - BUTTON_DISTANCE - buttonSize - BUTTON_DISTANCE - buttonSize, this.height - MARGIN * 2 + MARGIN, buttonSize, BUTTON_SIZE, "Save", press -> {});
        this.addButton((Widget)this.saveButton);
        this.worldSettings = new WorldSettings(this, MARGIN, MARGIN, SETTINGS_SIZE, this.height - MARGIN * 2);
        this.worldSettings.initSections();
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        this.renderUIScreen();
        this.renderInterface(mouseX, mouseY, partialTicks);
        super.render(mouseX, mouseY, partialTicks);
    }

    private void renderUIScreen() {
        this.renderBackground();
    }

    private void renderInterface(int mouseX, int mouseY, float partialTicks) {
        this.drawString(this.getMinecraft().field_71466_p, this.header + "   " + TextFormatting.GRAY + this.version, (int)((double)MARGIN * 1.5), MARGIN / 2, 0xFFFFFF);
        this.drawString(this.getMinecraft().field_71466_p, TextFormatting.GRAY + logMessage, (int)((double)MARGIN * 1.5), this.height - (int)((double)MARGIN / 1.5), 0xFFFFFF);
        this.worldSettings.render(mouseX, mouseY, partialTicks);
        WNWorldSettingsScreen.fill(SETTINGS_SIZE + MARGIN, MARGIN, SETTINGS_SIZE + MARGIN + MARGIN, this.height - MARGIN * 2 + MARGIN);
        WNWorldSettingsScreen.fill(SETTINGS_SIZE + MARGIN / 2 + MARGIN * 2, MARGIN, this.width - MARGIN, this.height - MARGIN * 2 + MARGIN);
    }

    public static void log(String logMessage) {
        WNWorldSettingsScreen.logMessage = logMessage;
    }
}

