/*
 * Decompiled with CFR 0.152.
 */
package com.matez.wildnature.client.gui.screen.world.settings;

import com.matez.wildnature.client.gui.screen.world.settings.components.ModeButtonComponent;
import com.matez.wildnature.client.gui.screen.world.settings.components.MultiButtonComponent;
import com.matez.wildnature.client.gui.screen.world.settings.components.OptionComponent;
import com.matez.wildnature.client.gui.screen.world.settings.components.SliderComponent;
import com.matez.wildnature.client.gui.screen.world.settings.components.TextComponent;
import com.matez.wildnature.client.gui.screen.world.settings.components.ToggleButtonComponent;
import com.matez.wildnature.client.gui.screen.world.settings.widgets.SettingTextWidget;
import com.matez.wildnature.util.config.world.WorldConfig;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;

public class SettingSection {
    public Minecraft minecraft;
    public int height = 15;
    private final String name;
    private final ArrayList<OptionComponent> components = new ArrayList();
    private final String codename;
    private final WorldConfig config;

    public SettingSection(Minecraft minecraft, WorldConfig config, String codename, String name) {
        this.codename = codename;
        this.config = config;
        this.name = name;
        this.minecraft = minecraft;
    }

    public String getName() {
        return this.name;
    }

    public ArrayList<OptionComponent> getComponents() {
        return this.components;
    }

    public TextComponent addTextComponent(String codename, String header, String description, String defaultText, SettingTextWidget.TextAction action) {
        this.config.textConfigDefaults(codename, defaultText);
        TextComponent component = new TextComponent(this.config, codename, this, header, description, this.config.getTextConfig(codename), action);
        this.components.add(component);
        return component;
    }

    public SettingSection addSlider(String codename, String header, String description, String prefix, int minVal, int maxVal, int defaultValue, SliderComponent.SlideAction action) {
        this.config.numberConfigDefaults(codename, defaultValue);
        SliderComponent component = new SliderComponent(this.config, codename, this, header, description, prefix, minVal, maxVal, this.config.getNumberConfig(codename), action);
        this.components.add(component);
        return this;
    }

    public SettingSection addToggleComponent(String codename, String header, String description, String toggleButtonText, String unToggleButtonText, boolean defaultValue, ToggleButtonComponent.ToggleAction action) {
        this.config.modeConfigDefaults(codename, defaultValue ? 0 : 1);
        ToggleButtonComponent component = new ToggleButtonComponent(this.config, codename, this, header, description, toggleButtonText, unToggleButtonText, this.config.getModeConfig(codename) == 0, action);
        this.components.add(component);
        return this;
    }

    public SettingSection addModeButton(String codename, String header, String description, ModeButtonComponent.ModeAction action, String ... options) {
        this.config.modeConfigDefaults(codename, 0);
        ModeButtonComponent component = new ModeButtonComponent(this.config, codename, this, header, description, this.config.getModeConfig(codename), action, options);
        this.components.add(component);
        return this;
    }

    public MultiButtonComponent addMultiComponent(String codename, String header, String description, boolean multipleSelection) {
        MultiButtonComponent component = new MultiButtonComponent(this.config, codename, this, header, description, multipleSelection);
        this.components.add(component);
        return component;
    }
}

