/*
 * Decompiled with CFR 0.152.
 */
package com.matez.wildnature.client.gui.screen.world.settings;

import com.matez.wildnature.client.gui.screen.world.WNWorldSettingsScreen;
import com.matez.wildnature.client.gui.screen.world.settings.SettingSection;
import com.matez.wildnature.client.gui.screen.world.settings.components.OptionComponent;
import com.matez.wildnature.client.gui.screen.world.settings.widgets.SettingWidget;
import com.matez.wildnature.init.WN;
import com.matez.wildnature.util.config.world.WorldConfig;
import java.util.ArrayList;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.client.gui.ScrollPanel;

public class WorldSettings {
    private final ArrayList<SettingSection> sections = new ArrayList();
    private final int screenX;
    private final int screenZ;
    private final int width;
    private final int height;
    private ScrollPanel scrollPanel;
    private final Screen screen;
    private final WorldConfig worldConfig;

    public WorldSettings(Screen screen, int screenX, int screenZ, int width, int height) {
        this.screenX = screenX;
        this.screenZ = screenZ;
        this.width = width;
        this.height = height;
        this.screen = screen;
        this.worldConfig = new WorldConfig();
    }

    public void initSections() {
        this.addSection("first", "Siemanko").addToggleComponent("", "Oto jest przyk\u0139\u201aad", "Fajne co nie,\nte\u0139\u013d mi si\u00c4\u2122 tak zdaje\ndobra koniec juz", "Tak", "Nie", true, bool -> WN.LOGGER.debug("CLICK " + bool)).addToggleComponent("", "Oto jest przyk\u0139\u201aad 2", "Nic tu nie ma", "OKEJ ZAR\u00c4\u201eBISCIE SUEPER", "spok", true, bool -> WN.LOGGER.debug("CLICK2 " + bool)).addToggleComponent("", "Oto jest przyk\u0139\u201aad 3", "Fajne co nie,\nte\u0139\u013d mi si\u00c4\u2122 tak zdaje\ndobra koniec juz\nxd\njanusz grzyb tanczy", "Nie wiem", "Chyba nie", true, bool -> WN.LOGGER.debug("CLICK3 " + bool)).addMultiComponent("", "Przyklad multi", "oto on", false).addButton("Pierwszy przycisk", true, bool -> WN.LOGGER.debug("BTN 1" + bool)).addButton("Drugi przycisk", false, bool -> WN.LOGGER.debug("BTN 2" + bool)).addButton("Trzeci przycisk", true, bool -> WN.LOGGER.debug("BTN 3" + bool)).addButton("Czwarty przycisk", true, bool -> WN.LOGGER.debug("BTN 4" + bool)).getSection().addModeButton("", "Przyk\u0139\u201aad mode", "tenteges", (index, text) -> WN.LOGGER.debug("MODE: " + index + " " + text), "Janusz", "Grzyb", "Ta\u0139\u201eczy").addTextComponent("", "Tekst", "text component", "Przykladowy tekst", text -> WN.LOGGER.debug("TEXT INPUT " + text)).getSection().addSlider("", "Slider", "That's a slider", "Prefix", -10, 10, 0, (slider, slide) -> WN.LOGGER.debug("SlIDE: " + slide));
        this.addSection("second", "SiemankoXDDDDD").addToggleComponent("", "Oto jest przyk\u0139\u201aad", "Fajne co nie,\nte\u0139\u013d mi si\u00c4\u2122 tak zdaje\ndobra koniec juz", "Tak", "Nie", true, bool -> WN.LOGGER.debug("CLICK " + bool)).addToggleComponent("", "Oto jest przyk\u0139\u201aad 2", "Nic tu nie ma", "OKEJ ZAR\u00c4\u201eBISCIE SUEPER", "spok", true, bool -> WN.LOGGER.debug("CLICK2 " + bool)).addToggleComponent("", "Oto jest przyk\u0139\u201aad 3", "Fajne co nie,\nte\u0139\u013d mi si\u00c4\u2122 tak zdaje\ndobra koniec juz\nxd\njanusz grzyb tanczy", "Nie wiem", "Chyba nie", true, bool -> WN.LOGGER.debug("CLICK3 " + bool));
        this.initComponents();
        this.initScrollPanel();
    }

    public void initComponents() {
        for (SettingSection section : this.sections) {
            for (OptionComponent component : section.getComponents()) {
                component.init();
                for (SettingWidget widget : component.getWidgets()) {
                    this.screen.children().add(widget);
                }
            }
        }
    }

    public void initScrollPanel() {
        this.scrollPanel = new ScrollPanel(this.screen.getMinecraft(), this.width, this.height, this.screenX, this.screenZ){
            private int contentHeight;
            {
                this.contentHeight = this.height;
            }

            protected int getContentHeight() {
                return Math.max(this.drawPanel(true, 0, 0, null, 0, 0), this.height);
            }

            protected void drawPanel(int entryRight, int relativeY, Tessellator tess, int mouseX, int mouseY) {
                this.drawPanel(false, entryRight, relativeY, tess, mouseX, mouseY);
            }

            protected int drawPanel(boolean fakeDraw, int entryRight, int relativeY, Tessellator tess, int mouseX, int mouseY) {
                int relativeX = WorldSettings.this.screenX;
                int actualY = 0;
                ((WorldSettings)WorldSettings.this).screen.getMinecraft().field_71466_p.getClass();
                int fontSize = 9;
                for (SettingSection section : WorldSettings.this.sections) {
                    int posSection = actualY;
                    if (!fakeDraw) {
                        WNWorldSettingsScreen.fillColor(relativeX + 5, relativeY + posSection, this.width - 5, relativeY + posSection + 1, 0xEEEEEE);
                    }
                    int posSectionName = posSection + 10;
                    if (!fakeDraw) {
                        WorldSettings.this.screen.drawString(((WorldSettings)WorldSettings.this).screen.getMinecraft().field_71466_p, TextFormatting.BOLD + section.getName(), relativeX + 30, relativeY + posSectionName, 0xFFFFFF);
                    }
                    int posComponentStart = posSectionName + 15;
                    int componentActualY = 0;
                    for (OptionComponent component : section.getComponents()) {
                        int posComponent = posComponentStart + componentActualY;
                        if (!fakeDraw) {
                            WNWorldSettingsScreen.fillColor(relativeX + 5, relativeY + posComponent + fontSize / 2 - 1, relativeX + 15, relativeY + posComponent + 1 + fontSize / 2 - 1, 0x707070);
                            WorldSettings.this.screen.drawString(((WorldSettings)WorldSettings.this).screen.getMinecraft().field_71466_p, component.header, relativeX + 20, relativeY + posComponent, 0xFFFFFF);
                        }
                        int posDescriptionStart = posComponent + 10;
                        int descriptionMax = 0;
                        for (String descriptionLine : component.getDescriptionLines()) {
                            int posDescription = posDescriptionStart + descriptionMax;
                            if (!fakeDraw) {
                                WorldSettings.this.screen.drawString(((WorldSettings)WorldSettings.this).screen.getMinecraft().field_71466_p, TextFormatting.GRAY + descriptionLine, relativeX + 15, relativeY + posDescription, 0xFFFFFF);
                            }
                            descriptionMax += 10;
                        }
                        if (!fakeDraw) {
                            WNWorldSettingsScreen.fillColor(relativeX + 4, relativeY + posDescriptionStart - 3, relativeX + 5, relativeY + posDescriptionStart + descriptionMax, 0x707070);
                        }
                        int widgetStart = posDescriptionStart + descriptionMax + 10;
                        int widgetMax = 0;
                        int maxWidgetY = -1;
                        int maxWidgetYHeight = -1;
                        for (SettingWidget widget : component.getWidgets()) {
                            if (!fakeDraw) {
                                widget.setPosition(relativeX, relativeY + widgetStart);
                                widget.render(mouseX, mouseY, 0.0f);
                            }
                            if (maxWidgetY >= widget.baseY) continue;
                            maxWidgetY = widget.baseY;
                            maxWidgetYHeight = widget.getHeight();
                        }
                        componentActualY += descriptionMax + 10 + (widgetMax += maxWidgetY + maxWidgetYHeight + 5) + 20;
                    }
                    if (!fakeDraw) {
                        // empty if block
                    }
                    actualY += 15 + componentActualY + 15;
                }
                this.contentHeight = actualY;
                return this.contentHeight;
            }

            public boolean mouseScrolled(double mouseX, double mouseY, double scroll) {
                return super.mouseScrolled(mouseX, mouseY, scroll);
            }
        };
        this.screen.children().add(this.scrollPanel);
    }

    public SettingSection addSection(String codename, String name) {
        SettingSection settingSection = new SettingSection(this.screen.getMinecraft(), this.worldConfig, codename, name);
        this.sections.add(settingSection);
        return settingSection;
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        this.scrollPanel.render(mouseX, mouseY, partialTicks);
    }
}

