/*
 * Decompiled with CFR 0.152.
 */
package com.matez.wildnature.client.gui.screen.world.settings.components;

import com.matez.wildnature.client.gui.screen.world.WNWorldSettingsScreen;
import com.matez.wildnature.client.gui.screen.world.settings.SettingSection;
import com.matez.wildnature.client.gui.screen.world.settings.components.OptionComponent;
import com.matez.wildnature.client.gui.screen.world.settings.widgets.SettingButton;
import com.matez.wildnature.client.gui.screen.world.settings.widgets.SettingWidget;
import com.matez.wildnature.util.config.world.WorldConfig;
import java.util.ArrayList;

public class ModeButtonComponent
extends OptionComponent {
    public final ArrayList<ModeButton> buttons = new ArrayList();
    public SettingButton button;
    public int selectedIndex = 0;

    public ModeButtonComponent(WorldConfig config, String codename, SettingSection section, String header, String description, int defaultValue, ModeAction action, String ... options) {
        super(config, codename, section, header, description);
        for (int i = 0; i < options.length; ++i) {
            this.buttons.add(new ModeButton(options[i], i));
        }
        this.selectedIndex = defaultValue;
        this.button = new SettingButton(10, 0, WNWorldSettingsScreen.SETTINGS_SIZE - WNWorldSettingsScreen.MARGIN - WNWorldSettingsScreen.BUTTON_DISTANCE, WNWorldSettingsScreen.BUTTON_SIZE, this.buttons.get(0).getText(), press -> {
            this.selectedIndex = this.selectedIndex >= this.buttons.size() - 1 ? 0 : ++this.selectedIndex;
            press.setMessage(this.buttons.get(this.selectedIndex).getText());
            config.modeConfig(codename, this.selectedIndex);
            action.action(this.selectedIndex, this.buttons.get(this.selectedIndex).getText());
        });
        this.button.setMessage(this.buttons.get(defaultValue).getText());
    }

    @Override
    public SettingWidget[] getWidgets() {
        return new SettingWidget[]{this.button};
    }

    public static class ModeButton {
        public String text;
        public int id;

        public ModeButton(String text, int id) {
            this.text = text;
            this.id = id;
        }

        public int getId() {
            return this.id;
        }

        public String getText() {
            return this.text;
        }
    }

    public static interface ModeAction {
        public void action(int var1, String var2);
    }
}

