/*
 * Decompiled with CFR 0.152.
 */
package com.matez.wildnature.client.gui.screen.world.settings.components;

import com.matez.wildnature.client.gui.screen.world.WNWorldSettingsScreen;
import com.matez.wildnature.client.gui.screen.world.settings.SettingSection;
import com.matez.wildnature.client.gui.screen.world.settings.components.OptionComponent;
import com.matez.wildnature.client.gui.screen.world.settings.components.ToggleButtonComponent;
import com.matez.wildnature.client.gui.screen.world.settings.widgets.SettingButton;
import com.matez.wildnature.client.gui.screen.world.settings.widgets.SettingWidget;
import com.matez.wildnature.util.config.world.WorldConfig;
import java.util.ArrayList;
import net.minecraft.util.text.TextFormatting;

public class MultiButtonComponent
extends OptionComponent {
    private ArrayList<MultiButton> buttons = new ArrayList();
    private boolean multipleSelection;

    public MultiButtonComponent(WorldConfig config, String codename, SettingSection section, String header, String description, boolean multipleSelection) {
        super(config, codename, section, header, description);
        this.multipleSelection = multipleSelection;
    }

    public MultiButtonComponent addButton(String text, boolean defaultValue, ToggleButtonComponent.ToggleAction action) {
        int buttonBaseY = this.buttons.size() * (WNWorldSettingsScreen.BUTTON_DISTANCE + WNWorldSettingsScreen.BUTTON_SIZE);
        int buttonSize = WNWorldSettingsScreen.SETTINGS_SIZE - WNWorldSettingsScreen.MARGIN - WNWorldSettingsScreen.BUTTON_DISTANCE;
        int localId = this.buttons.size();
        MultiButton button = new MultiButton(10, buttonBaseY, buttonSize, WNWorldSettingsScreen.BUTTON_SIZE, text, localId, defaultValue, id -> {
            if (!this.multipleSelection) {
                for (MultiButton btn : this.buttons) {
                    if (btn.id == id) {
                        btn.setSelected(true);
                        btn.setMessage(TextFormatting.GREEN + btn.defaultText);
                        if (btn.id != localId) continue;
                        action.action(true);
                        continue;
                    }
                    btn.setSelected(false);
                    btn.setMessage(TextFormatting.RED + btn.defaultText);
                    if (btn.id != localId) continue;
                    action.action(false);
                }
            } else {
                for (MultiButton btn : this.buttons) {
                    if (btn.id == id) {
                        if (btn.isSelected()) {
                            btn.setMessage(TextFormatting.RED + btn.defaultText);
                            btn.setSelected(false);
                            if (btn.id != localId) continue;
                            action.action(false);
                            continue;
                        }
                        btn.setMessage(TextFormatting.GREEN + btn.defaultText);
                        btn.setSelected(true);
                        if (btn.id != localId) continue;
                        action.action(true);
                        continue;
                    }
                    if (btn.isSelected()) continue;
                    btn.setMessage(TextFormatting.RED + btn.defaultText);
                    if (btn.id != localId) continue;
                    action.action(false);
                }
            }
            int[] btnArray = new int[this.buttons.size()];
            for (int i = 0; i < this.buttons.size(); ++i) {
                MultiButton btn = this.buttons.get(i);
                btnArray[i] = btn.isSelected() ? 0 : 1;
            }
            this.config.multiConfig(this.codename, btnArray);
        });
        if (button.isSelected) {
            button.setMessage(TextFormatting.GREEN + button.defaultText);
        } else {
            button.setMessage(TextFormatting.RED + button.defaultText);
        }
        this.buttons.add(button);
        return this;
    }

    public SettingSection build() {
        MultiButton btn;
        int i;
        int[] btnArray = new int[this.buttons.size()];
        for (i = 0; i < this.buttons.size(); ++i) {
            btn = this.buttons.get(i);
            btnArray[i] = btn.isSelected() ? 0 : 1;
        }
        this.config.multiConfigDefaults(this.codename, btnArray);
        btnArray = this.config.getMultiConfig(this.codename);
        for (i = 0; i < this.buttons.size(); ++i) {
            btn = this.buttons.get(i);
            btn.setSelected(btnArray[i] == 0);
            if (btn.isSelected) {
                btn.setMessage(TextFormatting.GREEN + btn.defaultText);
                continue;
            }
            btn.setMessage(TextFormatting.RED + btn.defaultText);
        }
        return this.getSection();
    }

    public MultiButton getButtonById(int id) {
        for (MultiButton btn : this.buttons) {
            if (btn.id != id) continue;
            return btn;
        }
        return null;
    }

    @Override
    public SettingWidget[] getWidgets() {
        return this.buttons.toArray(new MultiButton[0]);
    }

    public static class MultiButton
    extends SettingButton {
        public int id;
        public boolean defaultValue;
        public boolean isSelected;
        public String defaultText = "";
        public MultiAction action;

        public MultiButton(int baseX, int baseY, int width, int height, String text, int id, boolean defaultValue, MultiAction action) {
            super(baseX, baseY, width, height, text, press -> action.action(id));
            this.defaultText = text;
            this.id = id;
            this.defaultValue = defaultValue;
            this.isSelected = defaultValue;
            this.action = action;
            action.action(id);
        }

        public void setSelected(boolean selected) {
            this.isSelected = selected;
        }

        public boolean isSelected() {
            return this.isSelected;
        }
    }

    public static interface MultiAction {
        public void action(int var1);
    }
}

