/*
 * Decompiled with CFR 0.152.
 */
package com.matez.wildnature.client.gui.screen.world.settings.components;

import com.matez.wildnature.client.gui.screen.world.WNWorldSettingsScreen;
import com.matez.wildnature.client.gui.screen.world.settings.SettingSection;
import com.matez.wildnature.client.gui.screen.world.settings.components.OptionComponent;
import com.matez.wildnature.client.gui.screen.world.settings.utils.ComponentUtils;
import com.matez.wildnature.client.gui.screen.world.settings.widgets.SettingButton;
import com.matez.wildnature.client.gui.screen.world.settings.widgets.SettingWidget;
import com.matez.wildnature.init.WN;
import com.matez.wildnature.util.config.world.WorldConfig;

public class ToggleButtonComponent
extends OptionComponent {
    private SettingButton toggleButton = null;
    private SettingButton unToggleButton = null;

    public ToggleButtonComponent(WorldConfig config, String codename, SettingSection section, String header, String description, String toggleButtonText, String unToggleButtonText, boolean defaultValue, ToggleAction action) {
        super(config, codename, section, header, description);
        int buttonSize;
        int screenSize = WNWorldSettingsScreen.SETTINGS_SIZE;
        int n = buttonSize = toggleButtonText.length() > unToggleButtonText.length() ? ComponentUtils.calculateButtonSize(toggleButtonText) : ComponentUtils.calculateButtonSize(unToggleButtonText);
        if (buttonSize * 2 + 20 >= screenSize) {
            WN.LOGGER.debug("TWO");
            buttonSize = WNWorldSettingsScreen.SETTINGS_SIZE - WNWorldSettingsScreen.MARGIN - WNWorldSettingsScreen.BUTTON_DISTANCE;
            this.toggleButton = new SettingButton(10, 0, buttonSize, WNWorldSettingsScreen.BUTTON_SIZE, toggleButtonText, press -> {
                press.active = false;
                this.unToggleButton.active = true;
                action.action(true);
                this.save();
            });
            this.unToggleButton = new SettingButton(10, WNWorldSettingsScreen.BUTTON_DISTANCE + WNWorldSettingsScreen.BUTTON_SIZE, buttonSize, WNWorldSettingsScreen.BUTTON_SIZE, unToggleButtonText, press -> {
                press.active = false;
                this.toggleButton.active = true;
                action.action(false);
                this.save();
            });
        } else {
            WN.LOGGER.debug("ONE");
            buttonSize = (WNWorldSettingsScreen.SETTINGS_SIZE - WNWorldSettingsScreen.MARGIN) / 2 - WNWorldSettingsScreen.BUTTON_DISTANCE;
            this.toggleButton = new SettingButton(10, 0, buttonSize, WNWorldSettingsScreen.BUTTON_SIZE, toggleButtonText, press -> {
                press.active = false;
                this.unToggleButton.active = true;
                action.action(true);
                this.save();
            });
            this.unToggleButton = new SettingButton(buttonSize + 10 + WNWorldSettingsScreen.BUTTON_DISTANCE, 0, buttonSize, WNWorldSettingsScreen.BUTTON_SIZE, unToggleButtonText, press -> {
                press.active = false;
                this.toggleButton.active = true;
                action.action(false);
                this.save();
            });
        }
        if (defaultValue) {
            this.toggleButton.onPress();
        } else {
            this.unToggleButton.onPress();
        }
    }

    public void save() {
        this.config.modeConfig(this.codename, this.toggleButton.active ? 0 : 1);
    }

    @Override
    public SettingWidget[] getWidgets() {
        return new SettingWidget[]{this.toggleButton, this.unToggleButton};
    }

    public static interface ToggleAction {
        public void action(boolean var1);
    }
}

