/*
 * Decompiled with CFR 0.152.
 */
package com.matez.wildnature.client.gui.screen.world.settings.widgets;

import com.matez.wildnature.client.gui.screen.world.settings.widgets.ExtendedSettingButton;
import com.matez.wildnature.client.gui.screen.world.settings.widgets.SettingButton;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.gui.GuiUtils;

public class SettingSliderWidget
extends ExtendedSettingButton {
    public double sliderValue = 1.0;
    public String dispString = "";
    public boolean dragging = false;
    public boolean showDecimal = true;
    public double minValue = 0.0;
    public double maxValue = 5.0;
    public int precision = 1;
    @Nullable
    public ISlider parent = null;
    public String suffix = "";
    public boolean drawString = true;

    public SettingSliderWidget(int baseX, int baseY, int width, int height, String prefix, String suf, double minVal, double maxVal, double currentVal, boolean showDec, boolean drawStr, SettingButton.IPressable handler) {
        this(baseX, baseY, width, height, prefix, suf, minVal, maxVal, currentVal, showDec, drawStr, handler, null);
    }

    public SettingSliderWidget(int baseX, int baseY, int width, int height, String prefix, String suf, double minVal, double maxVal, double currentVal, boolean showDec, boolean drawStr, SettingButton.IPressable handler, @Nullable ISlider par) {
        super(baseX, baseY, width, height, prefix, handler);
        String val;
        this.minValue = minVal;
        this.maxValue = maxVal;
        this.sliderValue = (currentVal - this.minValue) / (this.maxValue - this.minValue);
        this.dispString = prefix;
        this.parent = par;
        this.suffix = suf;
        this.showDecimal = showDec;
        if (this.showDecimal) {
            val = Double.toString(this.sliderValue * (this.maxValue - this.minValue) + this.minValue);
            this.precision = Math.min(val.substring(val.indexOf(".") + 1).length(), 4);
        } else {
            val = Integer.toString((int)Math.round(this.sliderValue * (this.maxValue - this.minValue) + this.minValue));
            this.precision = 0;
        }
        this.setMessage(this.dispString + val + this.suffix);
        this.drawString = drawStr;
        if (!this.drawString) {
            this.setMessage("");
        }
    }

    public SettingSliderWidget(int baseX, int baseY, String displayStr, double minVal, double maxVal, double currentVal, SettingButton.IPressable handler, ISlider par) {
        this(baseX, baseY, 150, 20, displayStr, "", minVal, maxVal, currentVal, true, true, handler, par);
    }

    public SettingSliderWidget(int baseX, int baseY, int width, int height, String displayStr, double minVal, double maxVal, double currentVal, SettingButton.IPressable handler, ISlider par) {
        this(baseX, baseY, width, height, displayStr, "", minVal, maxVal, currentVal, true, true, handler, par);
    }

    public int getYImage(boolean par1) {
        return 0;
    }

    protected void renderBg(Minecraft par1Minecraft, int par2, int par3) {
        if (this.visible) {
            if (this.dragging) {
                this.sliderValue = (float)(par2 - (this.x + 4)) / (float)(this.width - 8);
                this.updateSlider();
            }
            GuiUtils.drawContinuousTexturedBox((ResourceLocation)WIDGETS_LOCATION, (int)(this.x + (int)(this.sliderValue * (double)(this.width - 8))), (int)this.y, (int)0, (int)66, (int)8, (int)this.height, (int)200, (int)20, (int)2, (int)3, (int)2, (int)2, (float)this.getBlitOffset());
        }
    }

    @Override
    public void onClick(double mouseX, double mouseY) {
        this.sliderValue = (mouseX - (double)(this.x + 4)) / (double)(this.width - 8);
        this.updateSlider();
        this.dragging = true;
    }

    public void updateSlider() {
        String val;
        if (this.sliderValue < 0.0) {
            this.sliderValue = 0.0;
        }
        if (this.sliderValue > 1.0) {
            this.sliderValue = 1.0;
        }
        if (this.showDecimal) {
            val = Double.toString(this.sliderValue * (this.maxValue - this.minValue) + this.minValue);
            if (val.substring(val.indexOf(".") + 1).length() > this.precision) {
                if ((val = val.substring(0, val.indexOf(".") + this.precision + 1)).endsWith(".")) {
                    val = val.substring(0, val.indexOf(".") + this.precision);
                }
            } else {
                while (val.substring(val.indexOf(".") + 1).length() < this.precision) {
                    val = val + "0";
                }
            }
        } else {
            val = Integer.toString((int)Math.round(this.sliderValue * (this.maxValue - this.minValue) + this.minValue));
        }
        if (this.drawString) {
            this.setMessage(this.dispString + val + this.suffix);
        }
        if (this.parent != null) {
            this.parent.onChangeSliderValue(this);
        }
    }

    public void onRelease(double mouseX, double mouseY) {
        this.dragging = false;
    }

    public int getValueInt() {
        return (int)Math.round(this.sliderValue * (this.maxValue - this.minValue) + this.minValue);
    }

    public double getValue() {
        return this.sliderValue * (this.maxValue - this.minValue) + this.minValue;
    }

    public void setValue(double d) {
        this.sliderValue = (d - this.minValue) / (this.maxValue - this.minValue);
    }

    public static interface ISlider {
        public void onChangeSliderValue(SettingSliderWidget var1);
    }
}

