/*
 * Decompiled with CFR 0.152.
 */
package com.matez.wildnature.client.music;

import com.matez.wildnature.client.music.WNMusic;
import com.matez.wildnature.util.other.Utilities;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.MusicTicker;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class WNMusicPlayer
extends MusicTicker {
    private Minecraft client;
    private static World world;
    private static PlayerEntity player;
    private WNMusic.MusicType currentMusicType;
    private Biome currentBiome;
    private Biome oldBiome;
    private DimensionType currentDimension;
    private DimensionType oldDimension;
    private WNMusic.DayTime currentDayTime = WNMusic.DayTime.NONE;
    private Biome.RainType currentRainType = Biome.RainType.NONE;
    private WNMusic.MusicPosition currentMusicPosition = WNMusic.MusicPosition.NONE;
    private int musicSeed = 0;
    private int timeUntilNextMusic;
    private Random random = new Random();
    private boolean playingWNMusic = false;

    public WNMusicPlayer(Minecraft client) {
        super(client);
        this.client = client;
        System.out.println("Registering WildNature Music Player");
    }

    public void func_73660_a() {
        if (this.updateVariables()) {
            MusicTicker.MusicType musicticker$musictype = this.client.func_147109_W();
            if (this.field_147678_c != null) {
                if (!musicticker$musictype.func_188768_a().func_187503_a().equals((Object)this.field_147678_c.func_147650_b()) && !this.playingWNMusic) {
                    this.client.func_147118_V().func_147683_b(this.field_147678_c);
                    this.timeUntilNextMusic = MathHelper.func_76136_a((Random)this.random, (int)0, (int)(musicticker$musictype.func_148634_b() / 2));
                }
                if (!this.client.func_147118_V().func_215294_c(this.field_147678_c)) {
                    this.field_147678_c = null;
                    this.timeUntilNextMusic = Math.min(MathHelper.func_76136_a((Random)this.random, (int)musicticker$musictype.func_148634_b(), (int)musicticker$musictype.func_148633_c()), this.timeUntilNextMusic);
                }
            }
            this.timeUntilNextMusic = Math.min(this.timeUntilNextMusic, musicticker$musictype.func_148633_c());
            if (this.field_147678_c == null && this.timeUntilNextMusic-- <= 0) {
                boolean bl = this.playingWNMusic = Utilities.rint(0, 1, this.random) == 0;
                if (this.playingWNMusic) {
                    WNMusic.MusicType typeToPlay = this.getValidSound();
                    if (typeToPlay != null) {
                        ArrayList<SoundEvent> soundEvents = typeToPlay.getSoundEvents();
                        SoundEvent soundEvent = null;
                        if (!soundEvents.isEmpty()) {
                            if (soundEvents.size() == 1) {
                                soundEvent = soundEvents.get(0);
                            } else {
                                Random random = new Random(this.musicSeed);
                                soundEvent = soundEvents.get(Utilities.rint(0, soundEvents.size() - 1, random));
                            }
                            this.stopAndPlay(typeToPlay, soundEvent, 0, 1.0);
                            this.playingWNMusic = true;
                        } else {
                            this.playingWNMusic = false;
                        }
                    } else {
                        this.playingWNMusic = false;
                    }
                }
                if (!this.playingWNMusic) {
                    this.func_181558_a(musicticker$musictype);
                }
            }
        }
    }

    @SubscribeEvent
    public static void playerTick(TickEvent.PlayerTickEvent event) {
        world = event.player.func_130014_f_();
        player = event.player;
        if (!(Minecraft.func_71410_x().field_147126_aw instanceof WNMusicPlayer)) {
            Minecraft.func_71410_x().field_147126_aw = new WNMusicPlayer(Minecraft.func_71410_x());
        }
    }

    private boolean updateVariables() {
        if (this.client.field_71439_g != null && world != null && player != null) {
            this.currentDayTime = world.func_72820_D() < 13800L || world.func_72820_D() >= 22500L ? WNMusic.DayTime.DAY : WNMusic.DayTime.NIGHT;
            this.currentDimension = world.func_201675_m().func_186058_p();
            this.currentBiome = world.func_226691_t_(player.func_180425_c());
            this.currentMusicPosition = player.func_180425_c().func_177956_o() > world.func_181545_F() - 5 ? WNMusic.MusicPosition.SURFACE : (BiomeDictionary.hasType((Biome)this.currentBiome, (BiomeDictionary.Type)BiomeDictionary.Type.OCEAN) ? WNMusic.MusicPosition.UNDERWATER : WNMusic.MusicPosition.UNDERGROUND);
            return true;
        }
        return false;
    }

    public WNMusic.MusicType getValidSound() {
        ArrayList<WNMusic.MusicType> validMusicTypes = new ArrayList<WNMusic.MusicType>();
        for (WNMusic.MusicType musicType : WNMusic.musicTypes) {
            if (musicType.getDimension() != this.currentDimension && musicType.getDimension() != null || musicType.getBiome() != this.currentBiome && musicType.getBiome() != null || musicType.getDayTime() != this.currentDayTime && musicType.getDayTime() != WNMusic.DayTime.NONE || musicType.getRainType() != this.currentRainType && musicType.getRainType() != Biome.RainType.NONE || musicType.getPosition() != this.currentMusicPosition && musicType.getPosition() != WNMusic.MusicPosition.NONE) continue;
            validMusicTypes.add(musicType);
        }
        if (validMusicTypes.isEmpty()) {
            return null;
        }
        if (validMusicTypes.size() == 1) {
            return (WNMusic.MusicType)validMusicTypes.get(0);
        }
        Random random = new Random(this.musicSeed);
        return (WNMusic.MusicType)validMusicTypes.get(Utilities.rint(0, validMusicTypes.size() - 1, random));
    }

    public void stopAndPlay(WNMusic.MusicType type, SoundEvent event, int repeatDelay, double volume) {
        if (this.field_147678_c != null) {
            this.func_209200_a();
        }
        if (event != null) {
            this.play(type, event, repeatDelay, volume);
        }
    }

    public void play(WNMusic.MusicType type, SoundEvent event, int repeatDelay, double volume) {
        SimpleSound sound = WNMusicPlayer.musicSound(event, (float)volume, repeatDelay);
        this.client.func_147118_V().func_147682_a((ISound)sound);
        this.field_147678_c = sound;
        this.currentMusicType = type;
    }

    public void func_209200_a() {
        ++this.musicSeed;
        this.client.func_147118_V().func_147683_b(this.field_147678_c);
        this.field_147678_c = null;
    }

    public static SimpleSound musicSound(SoundEvent soundIn, float volumeIn, int repeatDelay) {
        return new SimpleSound(soundIn.func_187503_a(), SoundCategory.MUSIC, volumeIn, 1.0f, false, repeatDelay, ISound.AttenuationType.NONE, 0.0f, 0.0f, 0.0f, true);
    }
}

