/*
 * Decompiled with CFR 0.152.
 */
package com.matez.wildnature.common.blocks;

import com.matez.wildnature.client.render.IRenderLayer;
import com.matez.wildnature.common.blocks.PodzolBase;
import com.matez.wildnature.init.WN;
import com.matez.wildnature.util.config.CommonConfig;
import com.matez.wildnature.util.lists.WNBlocks;
import com.matez.wildnature.util.other.Utilities;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.BushBlock;
import net.minecraft.block.FarmlandBlock;
import net.minecraft.block.SnowyDirtBlock;
import net.minecraft.block.SoundType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.IShearable;

public class BushBase
extends BushBlock
implements IShearable,
IRenderLayer {
    protected static final VoxelShape SHAPE = Block.func_208617_a((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)13.0, (double)14.0);
    private Item item;
    private String drop;
    private int min = 1;
    private int max = 1;
    private int exp = 0;

    public BushBase(Block.Properties properties, Item.Properties builder, ResourceLocation regName) {
        super(properties.func_200942_a().func_200947_a(SoundType.field_222471_r));
        this.setRegistryName(regName);
        this.item = (Item)new BlockItem((Block)this, builder).setRegistryName(regName);
        WNBlocks.PLANTS.add((Block)this);
        WNBlocks.BLOCKS.add((Block)this);
        WNBlocks.ITEMBLOCKS.add(this.item);
    }

    public BushBase(Block.Properties properties, Item.Properties builder, ResourceLocation regName, boolean newProperties) {
        super(properties);
        this.setRegistryName(regName);
        this.item = (Item)new BlockItem((Block)this, builder).setRegistryName(regName);
        WNBlocks.PLANTS.add((Block)this);
        WNBlocks.BLOCKS.add((Block)this);
        WNBlocks.ITEMBLOCKS.add(this.item);
    }

    public BushBase(Block.Properties properties, @Nullable Item.Properties builder, String drop, int min, int max, int exp, ResourceLocation regName) {
        super(properties.func_200942_a().func_200947_a(SoundType.field_222471_r));
        this.setRegistryName(regName);
        if (builder != null) {
            this.item = (Item)new BlockItem((Block)this, builder).setRegistryName(regName);
        }
        this.drop = drop;
        this.min = min;
        this.max = max;
        this.exp = exp;
        WNBlocks.PLANTS.add((Block)this);
        WNBlocks.BLOCKS.add((Block)this);
        if (builder != null) {
            WNBlocks.ITEMBLOCKS.add(this.item);
        }
    }

    public Item getItem() {
        return this.item;
    }

    public List<ItemStack> func_220076_a(BlockState state, LootContext.Builder builder) {
        if (this.drop != null) {
            ArrayList<ItemStack> list = new ArrayList<ItemStack>();
            list.add(new ItemStack((IItemProvider)WN.getItemByID(this.drop), Utilities.rint(this.min, this.max)));
            return list;
        }
        boolean silkTouch = false;
        List list = super.func_220076_a(state, builder);
        if (list.isEmpty() && !silkTouch && Utilities.rint(0, (Integer)CommonConfig.flowerDropChance.get()) == 0) {
            list.add(new ItemStack((IItemProvider)this.item, 1));
        }
        return list;
    }

    public void func_176208_a(World world, BlockPos pos, BlockState state, PlayerEntity entity) {
        if (entity.field_71071_by.func_70448_g().func_77973_b() == Items.field_151097_aZ && !entity.field_71075_bZ.field_75098_d) {
            BushBase.func_180635_a((World)world, (BlockPos)pos, (ItemStack)new ItemStack((IItemProvider)Item.func_150898_a((Block)state.func_177230_c())));
            world.func_184134_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), this.getSoundType(state, (IWorldReader)world, pos, (Entity)entity).func_185845_c(), SoundCategory.BLOCKS, this.getSoundType((BlockState)state, (IWorldReader)world, (BlockPos)pos, (Entity)entity).field_185861_n, this.getSoundType((BlockState)state, (IWorldReader)world, (BlockPos)pos, (Entity)entity).field_185860_m, false);
            super.func_176208_a(world, pos, state, entity);
        } else {
            super.func_176208_a(world, pos, state, entity);
        }
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPE;
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        BlockPos blockpos = pos.func_177977_b();
        if (state.func_177230_c() == this) {
            return worldIn.func_180495_p(blockpos).canSustainPlant((IBlockReader)worldIn, blockpos, Direction.UP, (IPlantable)this);
        }
        return this.func_200014_a_(worldIn.func_180495_p(blockpos), (IBlockReader)worldIn, blockpos);
    }

    public boolean func_200014_a_(BlockState state, IBlockReader worldIn, BlockPos pos) {
        Block block = state.func_177230_c();
        return block instanceof SnowyDirtBlock || block instanceof FarmlandBlock || block instanceof PodzolBase;
    }

    public Block.OffsetType func_176218_Q() {
        return Block.OffsetType.XZ;
    }

    @OnlyIn(value=Dist.CLIENT)
    public long func_209900_a(BlockState state, BlockPos pos) {
        return MathHelper.func_180187_c((int)pos.func_177958_n(), (int)pos.func_177956_o(), (int)pos.func_177952_p());
    }
}

