/*
 * Decompiled with CFR 0.152.
 */
package com.matez.wildnature.common.blocks;

import com.matez.wildnature.common.blocks.CustomPistonBlock;
import com.matez.wildnature.init.WN;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.DirectionalBlock;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.PistonType;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class CustomPistonHeadBlock
extends DirectionalBlock {
    public static final EnumProperty<PistonType> TYPE = BlockStateProperties.field_208144_as;
    public static final BooleanProperty SHORT = BlockStateProperties.field_208195_v;
    protected static final VoxelShape PISTON_EXTENSION_EAST_AABB = Block.func_208617_a((double)12.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape PISTON_EXTENSION_WEST_AABB = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)16.0);
    protected static final VoxelShape PISTON_EXTENSION_SOUTH_AABB = Block.func_208617_a((double)0.0, (double)0.0, (double)12.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape PISTON_EXTENSION_NORTH_AABB = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)4.0);
    protected static final VoxelShape PISTON_EXTENSION_UP_AABB = Block.func_208617_a((double)0.0, (double)12.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape PISTON_EXTENSION_DOWN_AABB = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0);
    protected static final VoxelShape UP_ARM_AABB = Block.func_208617_a((double)6.0, (double)-4.0, (double)6.0, (double)10.0, (double)12.0, (double)10.0);
    protected static final VoxelShape DOWN_ARM_AABB = Block.func_208617_a((double)6.0, (double)4.0, (double)6.0, (double)10.0, (double)20.0, (double)10.0);
    protected static final VoxelShape SOUTH_ARM_AABB = Block.func_208617_a((double)6.0, (double)6.0, (double)-4.0, (double)10.0, (double)10.0, (double)12.0);
    protected static final VoxelShape NORTH_ARM_AABB = Block.func_208617_a((double)6.0, (double)6.0, (double)4.0, (double)10.0, (double)10.0, (double)20.0);
    protected static final VoxelShape EAST_ARM_AABB = Block.func_208617_a((double)-4.0, (double)6.0, (double)6.0, (double)12.0, (double)10.0, (double)10.0);
    protected static final VoxelShape WEST_ARM_AABB = Block.func_208617_a((double)4.0, (double)6.0, (double)6.0, (double)20.0, (double)10.0, (double)10.0);
    protected static final VoxelShape SHORT_UP_ARM_AABB = Block.func_208617_a((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)12.0, (double)10.0);
    protected static final VoxelShape SHORT_DOWN_ARM_AABB = Block.func_208617_a((double)6.0, (double)4.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
    protected static final VoxelShape SHORT_SOUTH_ARM_AABB = Block.func_208617_a((double)6.0, (double)6.0, (double)0.0, (double)10.0, (double)10.0, (double)12.0);
    protected static final VoxelShape SHORT_NORTH_ARM_AABB = Block.func_208617_a((double)6.0, (double)6.0, (double)4.0, (double)10.0, (double)10.0, (double)16.0);
    protected static final VoxelShape SHORT_EAST_ARM_AABB = Block.func_208617_a((double)0.0, (double)6.0, (double)6.0, (double)12.0, (double)10.0, (double)10.0);
    protected static final VoxelShape SHORT_WEST_ARM_AABB = Block.func_208617_a((double)4.0, (double)6.0, (double)6.0, (double)16.0, (double)10.0, (double)10.0);
    private static Block piston;
    private static Block head;
    private static Block moving;
    private ResourceLocation loc;
    private ResourceLocation hea;
    private ResourceLocation movi;

    public CustomPistonHeadBlock(Block.Properties properties, ResourceLocation location, ResourceLocation head, ResourceLocation moving) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)field_176387_N, (Comparable)Direction.NORTH)).func_206870_a(TYPE, (Comparable)PistonType.DEFAULT)).func_206870_a((IProperty)SHORT, (Comparable)Boolean.valueOf(false)));
        this.setRegistryName(location);
        this.loc = location;
        this.hea = head;
        this.movi = moving;
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        head = WN.getBlockByID(this.loc + "");
        piston = WN.getBlockByID(this.hea + "");
        moving = WN.getBlockByID(this.movi + "");
        super.func_180633_a(worldIn, pos, state, placer, stack);
    }

    private VoxelShape getExtensionShapeFromState(BlockState state) {
        switch ((Direction)state.func_177229_b((IProperty)field_176387_N)) {
            default: {
                return PISTON_EXTENSION_DOWN_AABB;
            }
            case UP: {
                return PISTON_EXTENSION_UP_AABB;
            }
            case NORTH: {
                return PISTON_EXTENSION_NORTH_AABB;
            }
            case SOUTH: {
                return PISTON_EXTENSION_SOUTH_AABB;
            }
            case WEST: {
                return PISTON_EXTENSION_WEST_AABB;
            }
            case EAST: 
        }
        return PISTON_EXTENSION_EAST_AABB;
    }

    public boolean func_220074_n(BlockState state) {
        return true;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return VoxelShapes.func_197872_a((VoxelShape)this.getExtensionShapeFromState(state), (VoxelShape)this.getArmShapeFromState(state));
    }

    private VoxelShape getArmShapeFromState(BlockState state) {
        boolean flag = (Boolean)state.func_177229_b((IProperty)SHORT);
        switch ((Direction)state.func_177229_b((IProperty)field_176387_N)) {
            default: {
                return flag ? SHORT_DOWN_ARM_AABB : DOWN_ARM_AABB;
            }
            case UP: {
                return flag ? SHORT_UP_ARM_AABB : UP_ARM_AABB;
            }
            case NORTH: {
                return flag ? SHORT_NORTH_ARM_AABB : NORTH_ARM_AABB;
            }
            case SOUTH: {
                return flag ? SHORT_SOUTH_ARM_AABB : SOUTH_ARM_AABB;
            }
            case WEST: {
                return flag ? SHORT_WEST_ARM_AABB : WEST_ARM_AABB;
            }
            case EAST: 
        }
        return flag ? SHORT_EAST_ARM_AABB : EAST_ARM_AABB;
    }

    public void func_176208_a(World worldIn, BlockPos pos, BlockState state, PlayerEntity player) {
        BlockPos blockpos;
        Block block;
        if (!worldIn.field_72995_K && player.field_71075_bZ.field_75098_d && (block = worldIn.func_180495_p(blockpos = pos.func_177972_a(((Direction)state.func_177229_b((IProperty)field_176387_N)).func_176734_d())).func_177230_c()) == piston) {
            worldIn.func_217377_a(blockpos, false);
        }
        super.func_176208_a(worldIn, pos, state, player);
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.func_177230_c() != newState.func_177230_c()) {
            super.func_196243_a(state, worldIn, pos, newState, isMoving);
            Direction direction = ((Direction)state.func_177229_b((IProperty)field_176387_N)).func_176734_d();
            pos = pos.func_177972_a(direction);
            BlockState blockstate = worldIn.func_180495_p(pos);
            if (blockstate.func_177230_c() == piston && ((Boolean)blockstate.func_177229_b((IProperty)CustomPistonBlock.EXTENDED)).booleanValue()) {
                CustomPistonHeadBlock.func_220075_c((BlockState)blockstate, (World)worldIn, (BlockPos)pos);
                worldIn.func_217377_a(pos, false);
            }
        }
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        return facing.func_176734_d() == stateIn.func_177229_b((IProperty)field_176387_N) && !stateIn.func_196955_c((IWorldReader)worldIn, currentPos) ? Blocks.field_150350_a.func_176223_P() : super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        Block block = worldIn.func_180495_p(pos.func_177972_a(((Direction)state.func_177229_b((IProperty)field_176387_N)).func_176734_d())).func_177230_c();
        return block == piston || block == moving;
    }

    public void func_220069_a(BlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        if (state.func_196955_c((IWorldReader)worldIn, pos)) {
            BlockPos blockpos = pos.func_177972_a(((Direction)state.func_177229_b((IProperty)field_176387_N)).func_176734_d());
            worldIn.func_180495_p(blockpos).func_215697_a(worldIn, blockpos, blockIn, fromPos, false);
        }
    }

    public ItemStack func_185473_a(IBlockReader worldIn, BlockPos pos, BlockState state) {
        return new ItemStack((IItemProvider)piston);
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((IProperty)field_176387_N, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((IProperty)field_176387_N)));
    }

    public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((Direction)state.func_177229_b((IProperty)field_176387_N)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{field_176387_N, TYPE, SHORT});
    }

    public boolean func_196266_a(BlockState state, IBlockReader worldIn, BlockPos pos, PathType type) {
        return false;
    }
}

