/*
 * Decompiled with CFR 0.152.
 */
package com.matez.wildnature.common.blocks;

import com.matez.wildnature.common.blocks.CropBase;
import com.matez.wildnature.init.WN;
import com.matez.wildnature.util.config.CommonConfig;
import com.matez.wildnature.util.other.Utilities;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraftforge.common.IPlantable;

public class EggPlant
extends CropBase {
    public static final EnumProperty<DoubleBlockHalf> HALF = BlockStateProperties.field_208163_P;
    public static final IntegerProperty AGE = BlockStateProperties.field_208169_V;
    private static final VoxelShape[] SHAPE_BY_AGE = new VoxelShape[]{Block.func_208617_a((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)3.0, (double)14.0), Block.func_208617_a((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)14.0, (double)14.0), Block.func_208617_a((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0), Block.func_208617_a((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0), Block.func_208617_a((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0), Block.func_208617_a((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0)};
    private static final VoxelShape[] SHAPE_BY_AGE_UP = new VoxelShape[]{Block.func_208617_a((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)3.0, (double)14.0), Block.func_208617_a((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)8.0, (double)14.0), Block.func_208617_a((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0), Block.func_208617_a((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0)};

    public EggPlant(Block.Properties properties, ResourceLocation regName) {
        super(properties, null, regName);
        this.func_180632_j((BlockState)((BlockState)this.func_176223_P().func_206870_a(HALF, (Comparable)DoubleBlockHalf.LOWER)).func_206870_a((IProperty)AGE, (Comparable)Integer.valueOf(0)));
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader p_220053_2_, BlockPos p_220053_3_, ISelectionContext p_220053_4_) {
        if (state.func_177229_b(HALF) == DoubleBlockHalf.LOWER) {
            return SHAPE_BY_AGE[(Integer)state.func_177229_b((IProperty)this.func_185524_e())];
        }
        return SHAPE_BY_AGE_UP[(Integer)state.func_177229_b((IProperty)this.func_185524_e()) - 2];
    }

    public IntegerProperty func_185524_e() {
        return AGE;
    }

    @Override
    public IntegerProperty getAge() {
        return AGE;
    }

    protected int func_185529_b(World worldIn) {
        return MathHelper.func_76136_a((Random)worldIn.field_73012_v, (int)1, (int)2);
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        int age = (Integer)state.func_177229_b((IProperty)AGE);
        if (age != 0 && age != 1) {
            worldIn.func_180501_a(pos.func_177984_a(), (BlockState)this.func_176223_P().func_206870_a(HALF, (Comparable)DoubleBlockHalf.UPPER), 3);
        } else {
            worldIn.func_180501_a(pos, (BlockState)((BlockState)this.func_176223_P().func_206870_a((IProperty)AGE, (Comparable)Integer.valueOf(0))).func_206870_a(HALF, (Comparable)DoubleBlockHalf.LOWER), 3);
        }
    }

    public boolean func_196253_a(BlockState p_196253_1_, BlockItemUseContext p_196253_2_) {
        return false;
    }

    @Override
    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        if (state.func_177229_b(HALF) != DoubleBlockHalf.UPPER) {
            BlockPos blockpos = pos.func_177977_b();
            if (state.func_177230_c() == this) {
                return worldIn.func_180495_p(blockpos).canSustainPlant((IBlockReader)worldIn, blockpos, Direction.UP, (IPlantable)this);
            }
            return this.func_200014_a_(worldIn.func_180495_p(blockpos), (IBlockReader)worldIn, blockpos);
        }
        BlockState blockstate = worldIn.func_180495_p(pos.func_177977_b());
        if (state.func_177230_c() != this) {
            return super.func_196260_a(state, worldIn, pos);
        }
        return blockstate.func_177230_c() == this && blockstate.func_177229_b(HALF) == DoubleBlockHalf.LOWER;
    }

    public void placeAt(IWorld worldIn, BlockPos pos, int flags) {
        worldIn.func_180501_a(pos, (BlockState)this.func_176223_P().func_206870_a(HALF, (Comparable)DoubleBlockHalf.LOWER), flags);
        worldIn.func_180501_a(pos.func_177984_a(), (BlockState)this.func_176223_P().func_206870_a(HALF, (Comparable)DoubleBlockHalf.UPPER), flags);
    }

    public void func_180657_a(World worldIn, PlayerEntity player, BlockPos pos, BlockState state, @Nullable TileEntity te, ItemStack stack) {
        super.func_180657_a(worldIn, player, pos, Blocks.field_150350_a.func_176223_P(), te, stack);
    }

    @Override
    public void func_176208_a(World worldIn, BlockPos pos, BlockState state, PlayerEntity player) {
        DoubleBlockHalf doubleblockhalf = (DoubleBlockHalf)state.func_177229_b(HALF);
        BlockPos blockpos = doubleblockhalf == DoubleBlockHalf.LOWER ? pos.func_177984_a() : pos.func_177977_b();
        BlockState blockstate = worldIn.func_180495_p(blockpos);
        if (blockstate.func_177230_c() == this && blockstate.func_177229_b(HALF) != doubleblockhalf) {
            worldIn.func_180501_a(blockpos, Blocks.field_150350_a.func_176223_P(), 35);
            worldIn.func_217378_a(player, 2001, blockpos, Block.func_196246_j((BlockState)blockstate));
            if (!worldIn.field_72995_K && !player.func_184812_l_()) {
                EggPlant.func_220054_a((BlockState)state, (World)worldIn, (BlockPos)pos, (TileEntity)null, (Entity)player, (ItemStack)player.func_184614_ca());
                EggPlant.func_220054_a((BlockState)blockstate, (World)worldIn, (BlockPos)blockpos, (TileEntity)null, (Entity)player, (ItemStack)player.func_184614_ca());
            }
        }
        super.func_176208_a(worldIn, pos, state, player);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{HALF, AGE});
    }

    public void func_176487_g(World worldIn, BlockPos pos, BlockState state) {
        int age;
        int j;
        int i = this.func_185527_x(state) + this.func_185529_b(worldIn);
        if (i > (j = this.func_185526_g())) {
            i = j;
        }
        if ((age = ((Integer)state.func_177229_b((IProperty)AGE)).intValue()) != 0 && age != 1) {
            worldIn.func_180501_a(pos.func_177984_a(), (BlockState)((BlockState)this.func_176223_P().func_206870_a(HALF, (Comparable)DoubleBlockHalf.UPPER)).func_206870_a((IProperty)AGE, (Comparable)Integer.valueOf(i)), 3);
        }
        worldIn.func_180501_a(pos, (BlockState)((BlockState)this.func_176223_P().func_206870_a(HALF, (Comparable)DoubleBlockHalf.LOWER)).func_206870_a((IProperty)AGE, (Comparable)Integer.valueOf(i)), 3);
    }

    public List<ItemStack> func_220076_a(BlockState state, LootContext.Builder builder) {
        boolean silkTouch = false;
        List list = super.func_220076_a(state, builder);
        if (list.isEmpty() && !silkTouch && ((Integer)state.func_177229_b((IProperty)AGE)).intValue() == this.func_185526_g()) {
            list.add(new ItemStack((IItemProvider)WN.getItemByID("wildnature:eggplant"), 2));
        }
        return list;
    }

    public int func_185526_g() {
        return 5;
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (((Integer)state.func_177229_b((IProperty)AGE)).intValue() == this.func_185526_g()) {
            int min = Utilities.rint(1, 2);
            worldIn.func_175656_a(pos, (BlockState)worldIn.func_180495_p(pos).func_206870_a((IProperty)AGE, (Comparable)Integer.valueOf(this.func_185526_g() - min)));
            EggPlant.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)new ItemStack((IItemProvider)WN.getItemByID("wildnature:eggplant"), 1));
            worldIn.func_184133_a((PlayerEntity)null, pos, SoundEvents.field_219693_lB, SoundCategory.BLOCKS, 1.0f, 0.8f + worldIn.field_73012_v.nextFloat() * 0.4f);
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    @Override
    public boolean func_200014_a_(BlockState state, IBlockReader worldIn, BlockPos pos) {
        Block block = state.func_177230_c();
        if (!((Boolean)CommonConfig.vegeGrassSpawn.get()).booleanValue()) {
            return block == Blocks.field_150458_ak;
        }
        return block == Blocks.field_196658_i || block == Blocks.field_150346_d || block == Blocks.field_196660_k || block == Blocks.field_196661_l || block == Blocks.field_150458_ak;
    }
}

