/*
 * Decompiled with CFR 0.152.
 */
package com.matez.wildnature.common.blocks;

import com.matez.wildnature.client.render.IRenderLayer;
import com.matez.wildnature.init.WN;
import com.matez.wildnature.util.lists.WNBlocks;
import com.matez.wildnature.util.other.Utilities;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.BushBlock;
import net.minecraft.block.CropsBlock;
import net.minecraft.block.FarmlandBlock;
import net.minecraft.block.FenceGateBlock;
import net.minecraft.block.GlazedTerracottaBlock;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraftforge.common.FarmlandWaterManager;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.PlantType;
import net.minecraftforge.common.Tags;

public class FarmlandBase
extends FarmlandBlock
implements IRenderLayer {
    public Item field_220086_i;
    protected static final VoxelShape SHAPE = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)15.0, (double)16.0);
    private String dirt = Blocks.field_150346_d.getRegistryName().toString();

    public FarmlandBase(Block.Properties properties, Item.Properties builder, ResourceLocation regName, String dirtBlock) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)field_176531_a, (Comparable)Integer.valueOf(0)));
        this.setRegistryName(regName);
        this.field_220086_i = (Item)new BlockItem((Block)this, builder).setRegistryName(regName);
        this.dirt = dirtBlock;
        WNBlocks.BLOCKS.add((Block)this);
        WNBlocks.ITEMBLOCKS.add(this.field_220086_i);
    }

    public boolean func_149653_t(BlockState state) {
        return true;
    }

    public boolean canSustainPlant(BlockState state, IBlockReader world, BlockPos pos, Direction facing, IPlantable plantable) {
        BlockState plant = plantable.getPlant(world, pos.func_177972_a(facing));
        PlantType type = plantable.getPlantType(world, pos.func_177972_a(facing));
        try {
            if ((plant.func_177230_c() instanceof BushBlock || plant.func_177230_c() instanceof CropsBlock) && Utilities.isValidGroundFor(plant, (BlockState)Blocks.field_150458_ak.func_176223_P().func_206870_a((IProperty)FarmlandBlock.field_176531_a, state.func_177229_b((IProperty)field_176531_a)), world, pos)) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        switch (type) {
            case Desert: {
                return this.getBlock() == Blocks.field_150354_m || this.getBlock() == Blocks.field_150405_ch || this.getBlock() instanceof GlazedTerracottaBlock;
            }
            case Nether: {
                return this.getBlock() == Blocks.field_150425_aM;
            }
            case Crop: {
                return this.getBlock() instanceof FarmlandBase;
            }
            case Cave: {
                return Block.func_220056_d((BlockState)state, (IBlockReader)world, (BlockPos)pos, (Direction)Direction.UP);
            }
            case Plains: {
                return this.getBlock() == Blocks.field_196658_i || Tags.Blocks.DIRT.func_199685_a_((Object)this) || this.getBlock() instanceof FarmlandBase;
            }
            case Water: {
                return state.func_185904_a() == Material.field_151586_h;
            }
            case Beach: {
                boolean isBeach = this.getBlock() == Blocks.field_196658_i || Tags.Blocks.DIRT.func_199685_a_((Object)this) || this.getBlock() == Blocks.field_150354_m;
                boolean hasWater = world.func_180495_p(pos.func_177974_f()).func_185904_a() == Material.field_151586_h || world.func_180495_p(pos.func_177976_e()).func_185904_a() == Material.field_151586_h || world.func_180495_p(pos.func_177978_c()).func_185904_a() == Material.field_151586_h || world.func_180495_p(pos.func_177968_d()).func_185904_a() == Material.field_151586_h;
                return isBeach && hasWater;
            }
        }
        return super.canSustainPlant(state, world, pos, facing, plantable);
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (facing == Direction.UP && !stateIn.func_196955_c((IWorldReader)worldIn, currentPos)) {
            worldIn.func_205220_G_().func_205360_a(currentPos, (Object)this, 1);
        }
        return super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        BlockState blockstate = worldIn.func_180495_p(pos.func_177984_a());
        return !blockstate.func_185904_a().func_76220_a() || blockstate.func_177230_c() instanceof FenceGateBlock;
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return !this.func_176223_P().func_196955_c((IWorldReader)context.func_195991_k(), context.func_195995_a()) ? WN.getBlockByID(this.dirt).func_176223_P() : super.func_196258_a(context);
    }

    public boolean func_220074_n(BlockState state) {
        return true;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPE;
    }

    public void func_225534_a_(BlockState state, ServerWorld worldIn, BlockPos pos, Random random) {
        if (!state.func_196955_c((IWorldReader)worldIn, pos)) {
            FarmlandBase.turnToDirt(state, (World)worldIn, pos);
        } else {
            int i = (Integer)state.func_177229_b((IProperty)field_176531_a);
            if (!FarmlandBase.hasWater((IWorldReader)worldIn, pos) && !worldIn.func_175727_C(pos.func_177984_a())) {
                if (i > 0) {
                    worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((IProperty)field_176531_a, (Comparable)Integer.valueOf(i - 1)), 2);
                } else if (!this.hasCrops((IBlockReader)worldIn, pos)) {
                    FarmlandBase.turnToDirt(state, (World)worldIn, pos);
                }
            } else if (i < 7) {
                worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((IProperty)field_176531_a, (Comparable)Integer.valueOf(7)), 2);
            }
        }
    }

    public void func_180658_a(World worldIn, BlockPos pos, Entity entityIn, float fallDistance) {
        if (!worldIn.field_72995_K && ForgeHooks.onFarmlandTrample((World)worldIn, (BlockPos)pos, (BlockState)WN.getBlockByID(this.dirt).func_176223_P(), (float)fallDistance, (Entity)entityIn)) {
            FarmlandBase.turnToDirt(worldIn.func_180495_p(pos), worldIn, pos);
        }
        entityIn.func_225503_b_(fallDistance, 1.0f);
    }

    public String getDirt() {
        return this.dirt;
    }

    public static void turnToDirt(BlockState state, World worldIn, BlockPos pos) {
        if (state.func_177230_c() instanceof FarmlandBase) {
            worldIn.func_175656_a(pos, FarmlandBase.func_199601_a((BlockState)state, (BlockState)WN.getBlockByID(((FarmlandBase)state.func_177230_c()).getDirt()).func_176223_P(), (World)worldIn, (BlockPos)pos));
        }
    }

    private boolean hasCrops(IBlockReader worldIn, BlockPos pos) {
        BlockState state = worldIn.func_180495_p(pos.func_177984_a());
        return state.func_177230_c() instanceof IPlantable && this.canSustainPlant(state, worldIn, pos, Direction.UP, (IPlantable)state.func_177230_c());
    }

    private static boolean hasWater(IWorldReader worldIn, BlockPos pos) {
        for (BlockPos blockpos : BlockPos.func_218278_a((BlockPos)pos.func_177982_a(-4, 0, -4), (BlockPos)pos.func_177982_a(4, 1, 4))) {
            if (!worldIn.func_204610_c(blockpos).func_206884_a(FluidTags.field_206959_a)) continue;
            return true;
        }
        return FarmlandWaterManager.hasBlockWaterTicket((IWorldReader)worldIn, (BlockPos)pos);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{field_176531_a});
    }

    public boolean func_196266_a(BlockState state, IBlockReader worldIn, BlockPos pos, PathType type) {
        return false;
    }

    public List<ItemStack> func_220076_a(BlockState state, LootContext.Builder builder) {
        boolean silkTouch = false;
        List list = super.func_220076_a(state, builder);
        if (list.isEmpty() && !silkTouch) {
            list.add(new ItemStack((IItemProvider)WN.getBlockByID(this.dirt), 1));
        }
        return list;
    }
}

