/*
 * Decompiled with CFR 0.152.
 */
package com.matez.wildnature.common.blocks;

import com.matez.wildnature.common.blocks.BlockBase;
import com.matez.wildnature.common.blocks.FormationType;
import com.matez.wildnature.common.compatibility.WNLoot;
import com.matez.wildnature.init.WN;
import com.matez.wildnature.util.other.Utilities;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.fluid.Fluids;
import net.minecraft.fluid.IFluidState;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.storage.loot.LootContext;

public class FormationBase
extends BlockBase {
    public static final EnumProperty<FormationType> TYPE = EnumProperty.func_177709_a((String)"type", FormationType.class);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    public final int bigRarity;
    protected static final VoxelShape UP = Block.func_208617_a((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)8.0, (double)14.0);
    protected static final VoxelShape DOWN = Block.func_208617_a((double)2.0, (double)8.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    protected static final VoxelShape NORTH = Block.func_208617_a((double)2.0, (double)2.0, (double)8.0, (double)14.0, (double)14.0, (double)16.0);
    protected static final VoxelShape SOUTH = Block.func_208617_a((double)2.0, (double)2.0, (double)0.0, (double)14.0, (double)14.0, (double)8.0);
    protected static final VoxelShape EAST = Block.func_208617_a((double)8.0, (double)2.0, (double)2.0, (double)0.0, (double)14.0, (double)14.0);
    protected static final VoxelShape WEST = Block.func_208617_a((double)8.0, (double)2.0, (double)2.0, (double)16.0, (double)14.0, (double)14.0);
    private String dropSmall;
    private String dropBig;
    private int minSmall;
    private int maxSmall;
    private int minBig;
    private int maxBig;
    private int expSmall;
    private int expBig;

    public FormationBase(Block.Properties properties, Item.Properties builder, ResourceLocation regName, int bigRarity) {
        super(properties.func_226896_b_(), builder, regName);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a(TYPE, (Comparable)((Object)FormationType.SMALL))).func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        this.bigRarity = bigRarity;
    }

    public FormationBase(Block.Properties properties, ResourceLocation regName, int bigRarity) {
        super(properties.func_226896_b_(), regName);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a(TYPE, (Comparable)((Object)FormationType.SMALL))).func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        this.bigRarity = bigRarity;
    }

    public FormationBase(Block.Properties properties, Item.Properties builder, String dropSmall, String dropBig, int minSmall, int maxSmall, int minBig, int maxBig, int expSmall, int expBig, ResourceLocation regName, int bigRarity) {
        super(properties.func_226896_b_(), builder, dropSmall, minSmall, maxSmall, expSmall, regName);
        this.dropSmall = dropSmall;
        this.dropBig = dropBig;
        this.minSmall = minSmall;
        this.maxSmall = maxSmall;
        this.minBig = minBig;
        this.maxBig = maxBig;
        this.expSmall = expSmall;
        this.expBig = expBig;
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a(TYPE, (Comparable)((Object)FormationType.SMALL))).func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        this.bigRarity = bigRarity;
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return this.func_220053_a(state, worldIn, pos, context);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new IProperty[]{TYPE, WATERLOGGED});
    }

    public IFluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((IProperty)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.func_177229_b((IProperty)WATERLOGGED)).booleanValue()) {
            worldIn.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)worldIn));
        }
        return super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockPos blockpos = context.func_195995_a();
        IFluidState ifluidstate = context.func_195991_k().func_204610_c(blockpos);
        BlockState blockstate1 = (BlockState)this.func_176223_P().func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(ifluidstate.func_206886_c() == Fluids.field_204546_a));
        CompoundNBT nbt = context.func_195996_i().func_196082_o();
        if (context.func_195999_j() != null) {
            if (context.func_195999_j().func_184812_l_() && !nbt.func_74764_b("formationType")) {
                return this.getFormationVariant(blockstate1);
            }
            if (nbt.func_74764_b("formationType")) {
                return (BlockState)blockstate1.func_206870_a(TYPE, (Comparable)((Object)(nbt.func_74779_i("formationType").equals("big") ? FormationType.BIG : FormationType.SMALL)));
            }
        }
        return blockstate1;
    }

    public BlockState getFormationVariant(BlockState baseState) {
        return this.bigRarity == 0 ? (BlockState)baseState.func_206870_a(TYPE, (Comparable)((Object)FormationType.SMALL)) : (Utilities.rint(0, this.bigRarity) == 0 ? (BlockState)baseState.func_206870_a(TYPE, (Comparable)((Object)FormationType.BIG)) : (BlockState)baseState.func_206870_a(TYPE, (Comparable)((Object)FormationType.SMALL)));
    }

    @Override
    public List<ItemStack> func_220076_a(BlockState state, LootContext.Builder builder) {
        if (WNLoot.isBrokenByPickaxe(builder)) {
            if (this.drop != null) {
                ArrayList<ItemStack> list = new ArrayList<ItemStack>();
                if (WNLoot.isSilkTouch(builder)) {
                    ItemStack stack = new ItemStack((IItemProvider)Item.func_150898_a((Block)this), 1);
                    stack.func_196082_o().func_74778_a("formationType", ((FormationType)((Object)state.func_177229_b(TYPE))).func_176610_l());
                    list.add(stack);
                } else {
                    int min = 0;
                    int max = 0;
                    String drop = "";
                    if (state.func_177229_b(TYPE) == FormationType.SMALL) {
                        min = this.minSmall;
                        max = this.maxSmall;
                        drop = this.dropSmall;
                    } else {
                        min = this.minBig;
                        max = this.maxBig;
                        drop = this.dropBig;
                    }
                    list.add(new ItemStack((IItemProvider)WN.getItemByID(drop), Utilities.rint(min, max) + Utilities.rint(0, WNLoot.getFortune(builder))));
                }
                return list;
            }
            boolean silkTouch = false;
            List<ItemStack> list = super.func_220076_a(state, builder);
            if (list.isEmpty() && !silkTouch) {
                list.add(new ItemStack((IItemProvider)this.field_220086_i, 1));
            }
            return list;
        }
        return Collections.emptyList();
    }

    public int getExpDrop(BlockState state, IWorldReader world, BlockPos pos, int fortune, int silktouch) {
        int exp = 0;
        exp = state.func_177229_b(TYPE) == FormationType.SMALL ? this.expSmall : this.expBig;
        return exp;
    }
}

