/*
 * Decompiled with CFR 0.152.
 */
package com.matez.wildnature.common.blocks;

import com.matez.wildnature.client.render.IRenderLayer;
import com.matez.wildnature.client.sounds.SoundRegistry;
import com.matez.wildnature.common.blocks.BlockBase;
import com.matez.wildnature.common.blocks.SteamGeneratorBlock;
import com.matez.wildnature.common.registry.particles.ParticleRegistry;
import com.matez.wildnature.util.lists.WNItems;
import com.matez.wildnature.util.other.Utilities;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.fluid.Fluids;
import net.minecraft.fluid.IFluidState;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.TickPriority;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.loot.LootContext;

public class GeyserBlock
extends BlockBase
implements IRenderLayer,
IWaterLoggable {
    public static final IntegerProperty STEAM = IntegerProperty.func_177719_a((String)"steam", (int)0, (int)25);
    public static final BooleanProperty RUNNING = BooleanProperty.func_177716_a((String)"running");
    public static final IntegerProperty LOAD = IntegerProperty.func_177719_a((String)"load", (int)0, (int)5);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;

    public GeyserBlock(Block.Properties properties, Item.Properties builder, ResourceLocation regName) {
        super(properties.func_226896_b_(), builder, regName);
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return Stream.of(Block.func_208617_a((double)10.0, (double)2.0, (double)6.0, (double)13.0, (double)5.0, (double)10.0), Block.func_208617_a((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)2.0, (double)15.0), Block.func_208617_a((double)3.0, (double)2.0, (double)3.0, (double)13.0, (double)5.0, (double)6.0), Block.func_208617_a((double)3.0, (double)2.0, (double)10.0, (double)13.0, (double)5.0, (double)13.0), Block.func_208617_a((double)3.0, (double)2.0, (double)6.0, (double)6.0, (double)5.0, (double)10.0)).reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get();
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return this.func_220053_a(state, worldIn, pos, context);
    }

    public VoxelShape func_199600_g(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return this.func_220053_a(state, worldIn, pos, null);
    }

    public VoxelShape func_196247_c(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return this.func_220053_a(state, worldIn, pos, null);
    }

    public boolean func_149653_t(BlockState state) {
        return true;
    }

    public void func_225542_b_(BlockState state, ServerWorld worldIn, BlockPos pos, Random random) {
        if (!((Boolean)state.func_177229_b((IProperty)RUNNING)).booleanValue()) {
            int load;
            if ((Integer)state.func_177229_b((IProperty)LOAD) < 5 && Utilities.rint(0, 4) == 0) {
                worldIn.func_175656_a(pos, (BlockState)state.func_206870_a((IProperty)LOAD, (Comparable)Integer.valueOf((Integer)state.func_177229_b((IProperty)LOAD) + 1)));
            }
            if ((load = ((Integer)worldIn.func_180495_p(pos).func_177229_b((IProperty)LOAD)).intValue()) >= 2) {
                if (load == 2 && Utilities.rint(0, 99) == 0) {
                    this.boom((World)worldIn, pos, state);
                }
                if (load == 3 && Utilities.rint(0, 49) == 0) {
                    this.boom((World)worldIn, pos, state);
                }
                if (load == 4 && Utilities.rint(0, 19) == 0) {
                    this.boom((World)worldIn, pos, state);
                }
                if (load == 5 && Utilities.rint(0, 4) == 0) {
                    this.boom((World)worldIn, pos, state);
                }
            }
        }
    }

    private void boom(World worldIn, BlockPos pos, BlockState state) {
        worldIn.func_175656_a(pos, (BlockState)((BlockState)state.func_206870_a((IProperty)RUNNING, (Comparable)Boolean.valueOf(true))).func_206870_a((IProperty)STEAM, (Comparable)Integer.valueOf(25)));
        worldIn.func_205220_G_().func_205362_a(pos, (Object)this, 1, TickPriority.NORMAL);
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockPos blockpos = context.func_195995_a();
        IFluidState ifluidstate = context.func_195991_k().func_204610_c(blockpos);
        return (BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a((IProperty)RUNNING, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)LOAD, (Comparable)Integer.valueOf(0))).func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(ifluidstate.func_206886_c() == Fluids.field_204546_a));
    }

    public void func_225534_a_(BlockState state, ServerWorld worldIn, BlockPos pos, Random random) {
        if (!worldIn.func_201670_d() && ((Boolean)state.func_177229_b((IProperty)RUNNING)).booleanValue()) {
            this.steam(state, worldIn, pos, random);
        }
    }

    @Override
    public RenderType getRenderLayer() {
        return RenderType.func_228641_d_();
    }

    public void steam(BlockState state, ServerWorld worldIn, BlockPos pos, Random random) {
        if ((Integer)state.func_177229_b((IProperty)STEAM) > 0) {
            if ((Integer)state.func_177229_b((IProperty)STEAM) == 25) {
                worldIn.func_184148_a(null, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), SoundRegistry.STEAM_GENERATOR, SoundCategory.BLOCKS, 1.0f, 0.7f);
            }
            worldIn.func_175656_a(pos, (BlockState)((BlockState)worldIn.func_180495_p(pos).func_206870_a((IProperty)RUNNING, (Comparable)Boolean.valueOf(true))).func_206870_a((IProperty)STEAM, (Comparable)Integer.valueOf((Integer)state.func_177229_b((IProperty)STEAM) - 1)));
            this.steamParticle(pos, state, worldIn, random);
            worldIn.func_205220_G_().func_205362_a(pos, (Object)this, 2, TickPriority.NORMAL);
        } else {
            worldIn.func_175656_a(pos, (BlockState)((BlockState)worldIn.func_180495_p(pos).func_206870_a((IProperty)RUNNING, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)LOAD, (Comparable)Integer.valueOf(0)));
        }
    }

    public void steamParticle(BlockPos oldPos, BlockState state, ServerWorld world, Random random) {
        double X = oldPos.func_177958_n();
        double Y = (double)oldPos.func_177956_o() + 0.6;
        double Z = oldPos.func_177952_p();
        double res = 0.08;
        for (int i = 0; i < Utilities.rint(4 * (Integer)state.func_177229_b((IProperty)LOAD), 10 * (Integer)state.func_177229_b((IProperty)LOAD), random); ++i) {
            double speedX = Utilities.rdoub(-res, res);
            double speedY = Utilities.rdoub(0.3, 1.2);
            double speedZ = Utilities.rdoub(-res, res);
            SteamGeneratorBlock.spawnParticle(world, ParticleRegistry.STEAM, X + 0.5, Y + 0.5, Z + 0.5, 1, speedX, speedY, speedZ);
        }
    }

    public void func_180655_c(BlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        double x = (double)pos.func_177958_n() + 0.5;
        double y = (double)pos.func_177956_o() + 1.2;
        double z = (double)pos.func_177952_p() + 0.5;
        for (int i = 0; i < Utilities.rint(0, 2 * (Integer)stateIn.func_177229_b((IProperty)LOAD), rand); ++i) {
            worldIn.func_195594_a((IParticleData)ParticleRegistry.GEYSER, x, y, z, (double)((float)Utilities.rdoub(-0.05, 0.05)), (double)((float)Utilities.rdoub(0.07, 0.13)), (double)((float)Utilities.rdoub(-0.05, 0.05)));
            if ((Integer)stateIn.func_177229_b((IProperty)LOAD) < 4) continue;
            worldIn.func_195594_a((IParticleData)ParticleTypes.field_203217_T, x, y, z, (double)((float)Utilities.rdoub(-0.3, 0.3)), (double)((float)Utilities.rdoub(0.5, 2.5)), (double)((float)Utilities.rdoub(-0.3, 0.3)));
        }
        if ((Integer)stateIn.func_177229_b((IProperty)LOAD) != 0) {
            worldIn.func_184134_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), SoundEvents.field_187659_cY, SoundCategory.BLOCKS, 0.4f, (float)Utilities.rdoub(1.1, 1.5), false);
        }
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{STEAM, LOAD, RUNNING, WATERLOGGED});
    }

    @Override
    public List<ItemStack> func_220076_a(BlockState state, LootContext.Builder builder) {
        ArrayList<ItemStack> l = new ArrayList<ItemStack>();
        if ((Integer)state.func_177229_b((IProperty)LOAD) >= 4) {
            l.add(new ItemStack((IItemProvider)WNItems.GEYSER_ESSENCE));
        }
        if (((Boolean)state.func_177229_b((IProperty)RUNNING)).booleanValue()) {
            l.add(Utilities.rint(1, 2), new ItemStack((IItemProvider)WNItems.GEYSER_ESSENCE));
        }
        return l;
    }

    public IFluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((IProperty)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.func_177229_b((IProperty)WATERLOGGED)).booleanValue()) {
            worldIn.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)worldIn));
        }
        return super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }
}

