/*
 * Decompiled with CFR 0.152.
 */
package com.matez.wildnature.common.blocks;

import com.matez.wildnature.client.render.IRenderLayer;
import com.matez.wildnature.common.blocks.BlackLilacPlant;
import com.matez.wildnature.common.blocks.BlackberryPlant;
import com.matez.wildnature.common.blocks.CranberryPlant;
import com.matez.wildnature.common.blocks.CropBase;
import com.matez.wildnature.common.blocks.CurrantPlant;
import com.matez.wildnature.common.blocks.QuincePlant;
import com.matez.wildnature.common.blocks.WildBlueberryPlant;
import com.matez.wildnature.common.blocks.WildRosePlant;
import com.matez.wildnature.common.blocks.WildStrawberryPlant;
import com.matez.wildnature.common.compatibility.WNLoot;
import com.matez.wildnature.init.WN;
import com.matez.wildnature.util.lists.WNBlocks;
import com.matez.wildnature.util.other.Utilities;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.BushBlock;
import net.minecraft.block.CropsBlock;
import net.minecraft.block.FarmlandBlock;
import net.minecraft.block.GlazedTerracottaBlock;
import net.minecraft.block.GrassBlock;
import net.minecraft.block.IGrowable;
import net.minecraft.block.SnowBlock;
import net.minecraft.block.material.Material;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IProperty;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.DecoratedFeatureConfig;
import net.minecraft.world.gen.feature.FlowersFeature;
import net.minecraft.world.lighting.LightEngine;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.PlantType;
import net.minecraftforge.common.Tags;

public class GrassBase
extends GrassBlock
implements IRenderLayer {
    private Item item;
    private String dirt;

    public GrassBase(Block.Properties properties, Item.Properties builder, ResourceLocation regName, String dirt) {
        super(properties);
        this.dirt = dirt;
        this.setRegistryName(regName);
        this.item = (Item)new BlockItem((Block)this, builder).setRegistryName(regName);
        WNBlocks.BLOCKS.add((Block)this);
        WNBlocks.ITEMBLOCKS.add(this.item);
    }

    public boolean canSustainPlant(BlockState state, IBlockReader world, BlockPos pos, Direction facing, IPlantable plantable) {
        BlockState plant = plantable.getPlant(world, pos.func_177972_a(facing));
        PlantType type = plantable.getPlantType(world, pos.func_177972_a(facing));
        try {
            if (plant.func_177230_c() instanceof BushBlock && Utilities.isValidGroundFor(plant, Blocks.field_196658_i.func_176223_P(), world, pos)) {
                return true;
            }
            if (plant.func_177230_c() instanceof CropBase && Utilities.isValidGroundFor(plant, Blocks.field_196658_i.func_176223_P(), world, pos)) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if ((plant.func_177230_c() instanceof WildBlueberryPlant || plant.func_177230_c() instanceof WildRosePlant || plant.func_177230_c() instanceof WildStrawberryPlant || plant.func_177230_c() instanceof CurrantPlant || plant.func_177230_c() instanceof QuincePlant || plant.func_177230_c() instanceof BlackberryPlant || plant.func_177230_c() instanceof BlackLilacPlant || plant.func_177230_c() instanceof CranberryPlant) && plant.func_177230_c() == Blocks.field_150434_aF) {
            return this.getBlock() == Blocks.field_150434_aF || this.getBlock() == Blocks.field_150354_m || this.getBlock() == Blocks.field_196611_F;
        }
        if (plant.func_177230_c() == Blocks.field_196608_cF && this == Blocks.field_196608_cF) {
            return true;
        }
        if (plantable instanceof BushBlock && (!(plantable instanceof CropsBlock) || plantable instanceof QuincePlant || plantable instanceof WildStrawberryPlant || plantable instanceof CurrantPlant)) {
            return true;
        }
        switch (type) {
            case Desert: {
                return this.getBlock() == Blocks.field_150354_m || this.getBlock() == Blocks.field_150405_ch || this.getBlock() instanceof GlazedTerracottaBlock;
            }
            case Nether: {
                return this.getBlock() == Blocks.field_150425_aM;
            }
            case Crop: {
                return this.getBlock() == Blocks.field_150458_ak;
            }
            case Cave: {
                return Block.func_220056_d((BlockState)state, (IBlockReader)world, (BlockPos)pos, (Direction)Direction.UP);
            }
            case Plains: {
                return this.getBlock() == Blocks.field_196658_i || GrassBase.isDirt((Block)this) || this.getBlock() instanceof FarmlandBlock;
            }
            case Water: {
                return state.func_185904_a() == Material.field_151586_h;
            }
            case Beach: {
                boolean isBeach = this.getBlock() == Blocks.field_196658_i || GrassBase.isDirt((Block)this) || this.getBlock() == Blocks.field_150354_m;
                boolean hasWater = world.func_180495_p(pos.func_177974_f()).func_185904_a() == Material.field_151586_h || world.func_180495_p(pos.func_177976_e()).func_185904_a() == Material.field_151586_h || world.func_180495_p(pos.func_177978_c()).func_185904_a() == Material.field_151586_h || world.func_180495_p(pos.func_177968_d()).func_185904_a() == Material.field_151586_h;
                return isBeach && hasWater;
            }
        }
        return false;
    }

    public static boolean isDirt(Block blockIn) {
        return Tags.Blocks.DIRT.func_199685_a_((Object)blockIn);
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return !this.func_176223_P().func_196955_c((IWorldReader)context.func_195991_k(), context.func_195995_a()) ? Block.func_199601_a((BlockState)this.func_176223_P(), (BlockState)((Block)Registry.field_212618_g.func_82594_a(new ResourceLocation(this.dirt))).func_176223_P(), (World)context.func_195991_k(), (BlockPos)context.func_195995_a()) : super.func_196258_a(context);
    }

    public boolean func_176473_a(IBlockReader worldIn, BlockPos pos, BlockState state, boolean isClient) {
        return worldIn.func_180495_p(pos.func_177984_a()).func_196958_f();
    }

    public boolean func_180670_a(World worldIn, Random rand, BlockPos pos, BlockState state) {
        return true;
    }

    public void func_225535_a_(ServerWorld worldIn, Random rand, BlockPos pos, BlockState state) {
        BlockPos blockpos = pos.func_177984_a();
        int chance = Utilities.rint(0, 15);
        BlockState blockstate = Blocks.field_150349_c.func_176223_P();
        blockstate = chance <= 7 ? WN.getBlockByID("minecraft:grass").func_176223_P() : (chance > 7 && chance < 12 ? WN.getBlockByID("wildnature:medium_grass").func_176223_P() : WN.getBlockByID("wildnature:small_grass").func_176223_P());
        block0: for (int i = 0; i < 128; ++i) {
            BlockPos blockpos1 = blockpos;
            int j = 0;
            while (true) {
                if (j >= i / 16) {
                    BlockState blockstate1;
                    BlockState blockstate2 = worldIn.func_180495_p(blockpos1);
                    if (blockstate2.func_177230_c() == blockstate.func_177230_c() && rand.nextInt(10) == 0 && blockstate.func_177230_c() instanceof IGrowable) {
                        ((IGrowable)blockstate.func_177230_c()).func_225535_a_(worldIn, rand, blockpos1, blockstate2);
                    }
                    if (worldIn.func_180495_p(pos.func_177984_a()).func_204520_s().func_206886_c() != Fluids.field_204546_a && worldIn.func_180495_p(pos.func_177984_a()).func_204520_s().func_206886_c() != Fluids.field_207212_b) continue block0;
                    if (rand.nextInt(8) == 0) {
                        List lvt_11_1_ = worldIn.func_226691_t_(blockpos1).func_201853_g();
                        if (lvt_11_1_.isEmpty()) continue;
                        ConfiguredFeature lvt_12_1_ = ((DecoratedFeatureConfig)((ConfiguredFeature)lvt_11_1_.get((int)0)).field_222738_b).field_214689_a;
                        blockstate1 = ((FlowersFeature)lvt_12_1_.field_222737_a).func_225562_b_(rand, blockpos1, lvt_12_1_.field_222738_b);
                    } else {
                        blockstate1 = blockstate;
                    }
                    if (!blockstate1.func_196955_c((IWorldReader)worldIn, blockpos1)) continue block0;
                    worldIn.func_180501_a(blockpos1, blockstate1, 3);
                    continue block0;
                }
                if (worldIn.func_180495_p((blockpos1 = blockpos1.func_177982_a(rand.nextInt(3) - 1, (rand.nextInt(3) - 1) * rand.nextInt(3) / 2, rand.nextInt(3) - 1)).func_177977_b()).func_177230_c() != this || worldIn.func_180495_p(blockpos1).func_224756_o((IBlockReader)worldIn, blockpos1)) continue block0;
                ++j;
            }
        }
    }

    public List<ItemStack> func_220076_a(BlockState state, LootContext.Builder builder) {
        boolean silkTouch = false;
        List list = super.func_220076_a(state, builder);
        if (list.isEmpty() && !silkTouch) {
            if (WNLoot.isSilkTouch(builder)) {
                list.add(new ItemStack((IItemProvider)Item.func_150898_a((Block)this), 1));
            } else if (this.dirt.equals("minecraft:stone")) {
                list.add(new ItemStack((IItemProvider)Item.func_150898_a((Block)WN.getBlockByID("minecraft:cobblestone")), 1));
            } else {
                list.add(new ItemStack((IItemProvider)Item.func_150898_a((Block)WN.getBlockByID(this.dirt)), 1));
            }
        }
        return list;
    }

    public boolean func_149653_t(BlockState state) {
        return true;
    }

    public void func_225534_a_(BlockState state, ServerWorld worldIn, BlockPos pos, Random random) {
        if (!worldIn.field_72995_K) {
            Block dirtBlock = WN.getBlockByID(this.dirt);
            if (!worldIn.isAreaLoaded(pos, 3)) {
                return;
            }
            if (!GrassBase.func_220257_b(state, (IWorldReader)worldIn, pos)) {
                worldIn.func_175656_a(pos, dirtBlock.func_176223_P());
            } else if (worldIn.func_201696_r(pos.func_177984_a()) >= 9) {
                BlockState blockstate = this.func_176223_P();
                for (int i = 0; i < 4; ++i) {
                    BlockPos blockpos = pos.func_177982_a(random.nextInt(3) - 1, random.nextInt(5) - 3, random.nextInt(3) - 1);
                    if (worldIn.func_180495_p(blockpos).func_177230_c() != dirtBlock || !GrassBase.func_220256_c(blockstate, (IWorldReader)worldIn, blockpos)) continue;
                    worldIn.func_175656_a(blockpos, (BlockState)blockstate.func_206870_a((IProperty)field_196382_a, (Comparable)Boolean.valueOf(worldIn.func_180495_p(blockpos.func_177984_a()).func_177230_c() == Blocks.field_150433_aE)));
                }
            }
        }
    }

    public static boolean func_220257_b(BlockState p_220257_0_, IWorldReader p_220257_1_, BlockPos p_220257_2_) {
        BlockPos blockpos = p_220257_2_.func_177984_a();
        BlockState blockstate = p_220257_1_.func_180495_p(blockpos);
        if (blockstate.func_177230_c() == Blocks.field_150433_aE && (Integer)blockstate.func_177229_b((IProperty)SnowBlock.field_176315_a) == 1) {
            return true;
        }
        int i = LightEngine.func_215613_a((IBlockReader)p_220257_1_, (BlockState)p_220257_0_, (BlockPos)p_220257_2_, (BlockState)blockstate, (BlockPos)blockpos, (Direction)Direction.UP, (int)blockstate.func_200016_a((IBlockReader)p_220257_1_, blockpos));
        return i < p_220257_1_.func_201572_C();
    }

    public static boolean func_220256_c(BlockState p_220256_0_, IWorldReader p_220256_1_, BlockPos p_220256_2_) {
        BlockPos blockpos = p_220256_2_.func_177984_a();
        return GrassBase.func_220257_b(p_220256_0_, p_220256_1_, p_220256_2_) && !p_220256_1_.func_204610_c(blockpos).func_206884_a(FluidTags.field_206959_a);
    }
}

