/*
 * Decompiled with CFR 0.152.
 */
package com.matez.wildnature.common.blocks;

import com.matez.wildnature.common.blocks.MushroomBase;
import com.matez.wildnature.common.blocks.SteamGeneratorBlock;
import com.matez.wildnature.common.registry.particles.ParticleRegistry;
import com.matez.wildnature.common.tileentity.GravityShroomTileEntity;
import com.matez.wildnature.util.other.Utilities;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.item.Item;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.server.ServerWorld;

public class GravityShroom
extends MushroomBase {
    public static final BooleanProperty GRAVITY = BooleanProperty.func_177716_a((String)"gravity");

    public GravityShroom(Block.Properties properties, Item.Properties builder, ResourceLocation regName) {
        super(properties, builder, regName);
        this.func_180632_j((BlockState)this.func_176223_P().func_206870_a((IProperty)GRAVITY, (Comparable)Boolean.valueOf(false)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{GRAVITY});
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new GravityShroomTileEntity();
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public int getLightValue(BlockState state, IBlockReader world, BlockPos pos) {
        return (Boolean)state.func_177229_b((IProperty)GRAVITY) != false ? 12 : 0;
    }

    public void steamParticle(BlockPos oldPos, BlockState state, ServerWorld world, Random random) {
        double X = oldPos.func_177958_n();
        double Y = (double)oldPos.func_177956_o() + 0.6;
        double Z = oldPos.func_177952_p();
        double res = 0.02;
        for (int i = 0; i < Utilities.rint(20, 50, random); ++i) {
            double speedX = Utilities.rdoub(-res, res);
            double speedY = Utilities.rdoub(0.03, 0.06);
            double speedZ = Utilities.rdoub(-res, res);
            SteamGeneratorBlock.spawnParticle(world, ParticleRegistry.FUZZBALL_EXPLOSION, X + 0.5, Y + 0.5, Z + 0.5, 1, speedX, speedY, speedZ);
        }
        world.func_184148_a(null, (double)oldPos.func_177958_n(), (double)oldPos.func_177956_o(), (double)oldPos.func_177952_p(), SoundEvents.field_187659_cY, SoundCategory.BLOCKS, 0.4f, (float)Utilities.rdoub(1.1, 1.5));
    }
}

