/*
 * Decompiled with CFR 0.152.
 */
package com.matez.wildnature.common.blocks;

import com.matez.wildnature.common.blocks.BlackLilacPlant;
import com.matez.wildnature.common.blocks.BlackberryPlant;
import com.matez.wildnature.common.blocks.BlockBase;
import com.matez.wildnature.common.blocks.CranberryPlant;
import com.matez.wildnature.common.blocks.CropBase;
import com.matez.wildnature.common.blocks.CurrantPlant;
import com.matez.wildnature.common.blocks.QuincePlant;
import com.matez.wildnature.common.blocks.WildBlueberryPlant;
import com.matez.wildnature.common.blocks.WildRosePlant;
import com.matez.wildnature.common.blocks.WildStrawberryPlant;
import com.matez.wildnature.init.WN;
import com.matez.wildnature.util.other.Utilities;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.BushBlock;
import net.minecraft.block.CropsBlock;
import net.minecraft.block.FarmlandBlock;
import net.minecraft.block.GlazedTerracottaBlock;
import net.minecraft.block.material.Material;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.PlantType;
import net.minecraftforge.common.Tags;

public class PodzolBase
extends BlockBase {
    public Item field_220086_i;
    private String dirt;

    public PodzolBase(Block.Properties properties, Item.Properties builder, ResourceLocation regName, String dirt) {
        super(properties, builder, regName);
    }

    @Override
    public Item getItem() {
        return this.field_220086_i;
    }

    @Override
    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.func_180633_a(worldIn, pos, state, placer, stack);
    }

    public boolean canSustainPlant(BlockState state, IBlockReader world, BlockPos pos, Direction facing, IPlantable plantable) {
        BlockState plant = plantable.getPlant(world, pos.func_177972_a(facing));
        PlantType type = plantable.getPlantType(world, pos.func_177972_a(facing));
        try {
            if (plant.func_177230_c() instanceof BushBlock && Utilities.isValidGroundFor(plant, Blocks.field_196658_i.func_176223_P(), world, pos)) {
                return true;
            }
            if (plant.func_177230_c() instanceof CropBase && Utilities.isValidGroundFor(plant, Blocks.field_196658_i.func_176223_P(), world, pos)) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if ((plant.func_177230_c() instanceof WildBlueberryPlant || plant.func_177230_c() instanceof WildRosePlant || plant.func_177230_c() instanceof WildStrawberryPlant || plant.func_177230_c() instanceof CurrantPlant || plant.func_177230_c() instanceof QuincePlant || plant.func_177230_c() instanceof BlackberryPlant || plant.func_177230_c() instanceof BlackLilacPlant || plant.func_177230_c() instanceof CranberryPlant) && plant.func_177230_c() == Blocks.field_150434_aF) {
            return this.getBlock() == Blocks.field_150434_aF || this.getBlock() == Blocks.field_150354_m || this.getBlock() == Blocks.field_196611_F;
        }
        if (plant.func_177230_c() == Blocks.field_196608_cF && this == Blocks.field_196608_cF) {
            return true;
        }
        if (plantable instanceof BushBlock && (!(plantable instanceof CropsBlock) || plantable instanceof QuincePlant || plantable instanceof WildStrawberryPlant || plantable instanceof CurrantPlant)) {
            return true;
        }
        switch (type) {
            case Desert: {
                return this.getBlock() == Blocks.field_150354_m || this.getBlock() == Blocks.field_150405_ch || this.getBlock() instanceof GlazedTerracottaBlock;
            }
            case Nether: {
                return this.getBlock() == Blocks.field_150425_aM;
            }
            case Crop: {
                return this.getBlock() == Blocks.field_150458_ak;
            }
            case Cave: {
                return Block.func_220056_d((BlockState)state, (IBlockReader)world, (BlockPos)pos, (Direction)Direction.UP);
            }
            case Plains: {
                return this.getBlock() == Blocks.field_196658_i || PodzolBase.isDirt(this) || this.getBlock() instanceof FarmlandBlock;
            }
            case Water: {
                return state.func_185904_a() == Material.field_151586_h;
            }
            case Beach: {
                boolean isBeach = this.getBlock() == Blocks.field_196658_i || PodzolBase.isDirt(this) || this.getBlock() == Blocks.field_150354_m;
                boolean hasWater = world.func_180495_p(pos.func_177974_f()).func_185904_a() == Material.field_151586_h || world.func_180495_p(pos.func_177976_e()).func_185904_a() == Material.field_151586_h || world.func_180495_p(pos.func_177978_c()).func_185904_a() == Material.field_151586_h || world.func_180495_p(pos.func_177968_d()).func_185904_a() == Material.field_151586_h;
                return isBeach && hasWater;
            }
        }
        return false;
    }

    public static boolean isDirt(Block blockIn) {
        return Tags.Blocks.DIRT.func_199685_a_((Object)blockIn);
    }

    @Override
    public List<ItemStack> func_220076_a(BlockState state, LootContext.Builder builder) {
        boolean silkTouch = false;
        List<ItemStack> list = super.func_220076_a(state, builder);
        if (list.isEmpty() && !silkTouch) {
            list.add(new ItemStack((IItemProvider)Item.func_150898_a((Block)WN.getBlockByID(this.dirt)), 1));
        }
        return list;
    }
}

