/*
 * Decompiled with CFR 0.152.
 */
package com.matez.wildnature.common.blocks;

import com.matez.wildnature.client.sounds.SoundRegistry;
import com.matez.wildnature.common.blocks.BlockBase;
import com.matez.wildnature.common.registry.particles.ParticleRegistry;
import com.matez.wildnature.network.packet.packets.WNParticlePacket;
import com.matez.wildnature.util.other.Utilities;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.dispenser.IPosition;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.particles.IParticleData;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.TickPriority;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class SteamGeneratorBlock
extends BlockBase {
    public static final BooleanProperty POWERED = BlockStateProperties.field_208194_u;
    public static final BooleanProperty RUNNING = BooleanProperty.func_177716_a((String)"running");
    public static final DirectionProperty FACING = BlockStateProperties.field_208155_H;
    public static final IntegerProperty STEAM = IntegerProperty.func_177719_a((String)"steam", (int)0, (int)25);

    public SteamGeneratorBlock(Block.Properties properties, Item.Properties builder, ResourceLocation regName) {
        super(properties, builder, regName);
    }

    public void func_220082_b(BlockState state, World worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        super.func_220082_b(state, worldIn, pos, oldState, isMoving);
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a((IProperty)FACING, (Comparable)context.func_196010_d().func_176734_d())).func_206870_a((IProperty)RUNNING, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)POWERED, (Comparable)Boolean.valueOf(context.func_195991_k().func_175640_z(context.func_195995_a())));
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((IProperty)FACING, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((IProperty)FACING)));
    }

    public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((Direction)state.func_177229_b((IProperty)FACING)));
    }

    public void func_220069_a(BlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        boolean flag;
        if (!worldIn.field_72995_K && (flag = ((Boolean)state.func_177229_b((IProperty)POWERED)).booleanValue()) != worldIn.func_175640_z(pos)) {
            if (flag) {
                worldIn.func_205220_G_().func_205360_a(pos, (Object)this, 4);
            } else {
                worldIn.func_180501_a(pos, (BlockState)((BlockState)((BlockState)state.func_177231_a((IProperty)POWERED)).func_206870_a((IProperty)STEAM, (Comparable)Integer.valueOf(25))).func_206870_a((IProperty)RUNNING, (Comparable)Boolean.valueOf(true)), 2);
                worldIn.func_205220_G_().func_205362_a(pos, (Object)this, 1, TickPriority.NORMAL);
            }
        }
    }

    public void func_225534_a_(BlockState state, ServerWorld worldIn, BlockPos pos, Random random) {
        if (!worldIn.field_72995_K) {
            if (((Boolean)state.func_177229_b((IProperty)POWERED)).booleanValue() && !worldIn.func_175640_z(pos)) {
                worldIn.func_180501_a(pos, (BlockState)((BlockState)((BlockState)worldIn.func_180495_p(pos).func_177231_a((IProperty)POWERED)).func_206870_a((IProperty)STEAM, (Comparable)Integer.valueOf(0))).func_206870_a((IProperty)RUNNING, (Comparable)Boolean.valueOf(false)), 2);
            }
            this.steam(state, worldIn, pos, random);
        }
    }

    public void func_180655_c(BlockState stateIn, World worldIn, BlockPos pos, Random rand) {
    }

    public void steam(BlockState state, ServerWorld worldIn, BlockPos pos, Random random) {
        if (((Boolean)state.func_177229_b((IProperty)POWERED)).booleanValue()) {
            if ((Integer)state.func_177229_b((IProperty)STEAM) > 0) {
                if ((Integer)state.func_177229_b((IProperty)STEAM) == 25) {
                    worldIn.func_184148_a(null, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), SoundRegistry.STEAM_GENERATOR, SoundCategory.BLOCKS, 1.0f, 1.0f);
                }
                worldIn.func_175656_a(pos, (BlockState)((BlockState)((BlockState)worldIn.func_180495_p(pos).func_206870_a((IProperty)RUNNING, (Comparable)Boolean.valueOf(true))).func_206870_a((IProperty)POWERED, (Comparable)Boolean.valueOf(true))).func_206870_a((IProperty)STEAM, (Comparable)Integer.valueOf((Integer)state.func_177229_b((IProperty)STEAM) - 1)));
                this.steamParticle(pos, state, worldIn, random);
                worldIn.func_205220_G_().func_205362_a(pos, (Object)this, 2, TickPriority.NORMAL);
            } else {
                worldIn.func_175656_a(pos, (BlockState)worldIn.func_180495_p(pos).func_206870_a((IProperty)RUNNING, (Comparable)Boolean.valueOf(false)));
            }
        }
    }

    public void steamParticle(BlockPos oldPos, BlockState state, ServerWorld world, Random random) {
        Direction direction = (Direction)state.func_177229_b((IProperty)FACING);
        double X = this.offset(oldPos, direction, 0.6).func_82615_a();
        double Y = this.offset(oldPos, direction, 0.6).func_82617_b();
        double Z = this.offset(oldPos, direction, 0.6).func_82616_c();
        double divider = 3.0;
        double res = 0.15;
        for (int i = 0; i < Utilities.rint(15, 40, random); ++i) {
            double speedX = -(((double)oldPos.func_177958_n() - X) / divider) + Utilities.rdoub(-res, res);
            double speedY = -(((double)oldPos.func_177956_o() - Y) / divider) + Utilities.rdoub(-res, res);
            double speedZ = -(((double)oldPos.func_177952_p() - Z) / divider) + Utilities.rdoub(-res, res);
            SteamGeneratorBlock.spawnParticle(world, ParticleRegistry.STEAM, X + 0.5, Y + 0.5, Z + 0.5, 1, speedX, speedY, speedZ);
        }
    }

    public Vec3d offset(BlockPos pos, Direction facing, double n) {
        return new Vec3d((double)pos.func_177958_n() + (double)facing.func_82601_c() * n, (double)pos.func_177956_o() + (double)facing.func_96559_d() * n, (double)pos.func_177952_p() + (double)facing.func_82599_e() * n);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{FACING, RUNNING, POWERED, STEAM});
    }

    public static <T extends IParticleData> int spawnParticle(ServerWorld world, T type, double posX, double posY, double posZ, int particleCount, double xSpeed, double ySpeed, double zSpeed) {
        WNParticlePacket packet = new WNParticlePacket(type, false, (float)posX, (float)posY, (float)posZ, (float)xSpeed, (float)ySpeed, (float)zSpeed, particleCount);
        int i = 0;
        for (int j = 0; j < world.func_217369_A().size(); ++j) {
            ServerPlayerEntity serverplayerentity = (ServerPlayerEntity)world.func_217369_A().get(j);
            if (!SteamGeneratorBlock.sendPacketWithinDistance(world, serverplayerentity, false, posX, posY, posZ, packet)) continue;
            ++i;
        }
        return i;
    }

    public static boolean sendPacketWithinDistance(ServerWorld world, ServerPlayerEntity player, boolean longDistance, double posX, double posY, double posZ, WNParticlePacket packet) {
        if (player.func_71121_q() != world) {
            return false;
        }
        BlockPos blockpos = player.func_180425_c();
        if (blockpos.func_218137_a((IPosition)new Vec3d(posX, posY, posZ), longDistance ? 512.0 : 32.0)) {
            WNParticlePacket.sendToClient(player, packet);
            return true;
        }
        return false;
    }
}

