/*
 * Decompiled with CFR 0.152.
 */
package com.matez.wildnature.common.blocks;

import com.matez.wildnature.common.blocks.properties.ModStateProperties;
import com.matez.wildnature.common.blocks.properties.VerticalConnected;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.fluid.Fluids;
import net.minecraft.fluid.IFluidState;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;

public abstract class VerticalConnectingFacingBlock
extends Block
implements IWaterLoggable {
    public static final DirectionProperty FACING = HorizontalBlock.field_185512_D;
    public static final EnumProperty<VerticalConnected> PART = ModStateProperties.VERTICAL_CONNECTED;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;

    public VerticalConnectingFacingBlock(Block.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)FACING, (Comparable)Direction.NORTH)).func_206870_a(PART, (Comparable)((Object)VerticalConnected.MIDDLE)));
    }

    public boolean isConnectingBlock(BlockState state) {
        return state.func_177230_c() == this;
    }

    public boolean isValidFacing(BlockState currentState, BlockState validState) {
        return this.isConnectingBlock(currentState) && this.isConnectingBlock(validState) && currentState.func_177229_b((IProperty)FACING) == validState.func_177229_b((IProperty)FACING);
    }

    public VerticalConnected getPartProperty(IBlockReader worldIn, BlockPos blockpos) {
        boolean bot;
        BlockState state = worldIn.func_180495_p(blockpos);
        BlockState stateUp = worldIn.func_180495_p(blockpos.func_177984_a());
        BlockState stateDown = worldIn.func_180495_p(blockpos.func_177977_b());
        boolean top = this.isConnectingBlock(stateDown) && this.isValidFacing(state, stateDown);
        boolean bl = bot = this.isConnectingBlock(stateUp) && this.isValidFacing(state, stateUp);
        if (this.isValidFacing(state, state)) {
            if (top && bot) {
                return VerticalConnected.MIDDLE;
            }
            if (top) {
                return VerticalConnected.TOP;
            }
            if (bot) {
                return VerticalConnected.BOTTOM;
            }
        }
        return VerticalConnected.SINGLE;
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockPos blockpos = context.func_195995_a();
        IFluidState fluidstate = context.func_195991_k().func_204610_c(blockpos);
        BlockState blockstate = (BlockState)((BlockState)this.func_176223_P().func_206870_a((IProperty)FACING, (Comparable)context.func_195992_f().func_176734_d())).func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.func_206886_c() == Fluids.field_204546_a));
        return (BlockState)blockstate.func_206870_a(PART, (Comparable)((Object)this.getPartProperty((IBlockReader)context.func_195991_k(), blockpos)));
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.func_177229_b((IProperty)WATERLOGGED)).booleanValue()) {
            worldIn.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)worldIn));
        }
        return facing.func_176740_k().func_200128_b() ? (BlockState)stateIn.func_206870_a(PART, (Comparable)((Object)this.getPartProperty((IBlockReader)worldIn, currentPos))) : super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public IFluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((IProperty)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{FACING, PART, WATERLOGGED});
    }
}

