/*
 * Decompiled with CFR 0.152.
 */
package com.matez.wildnature.common.commands;

import com.matez.wildnature.init.WN;
import com.matez.wildnature.util.config.CommonConfig;
import com.matez.wildnature.util.other.Utilities;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.command.CommandSource;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.server.ServerWorld;

public class BiomeArgument
implements ArgumentType<Biome> {
    private static int radius = -1;
    private static int quality = 10;
    private static int maxRadius = 10000;
    private static boolean speedSearch = false;
    public static final DynamicCommandExceptionType INVALID_BIOME_EXCEPTION = new DynamicCommandExceptionType(biome -> new StringTextComponent("").func_150257_a((ITextComponent)WN.WNPrefix).func_150257_a((ITextComponent)new StringTextComponent(TextFormatting.RED + "This biome is invalid.")));

    public static BiomeArgument createArgument() {
        return new BiomeArgument();
    }

    public Biome parse(StringReader reader) throws CommandSyntaxException {
        ResourceLocation location = ResourceLocation.func_195826_a((StringReader)reader);
        return (Biome)Registry.field_212624_m.func_218349_b(location).orElseThrow(() -> INVALID_BIOME_EXCEPTION.create((Object)location));
    }

    public static Biome getValue(CommandContext<CommandSource> context, String name) throws CommandSyntaxException {
        return (Biome)context.getArgument(name, Biome.class);
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder suggestionsBuilder) {
        return ISuggestionProvider.func_197014_a((Iterable)Registry.field_212624_m.func_148742_b(), (SuggestionsBuilder)suggestionsBuilder);
    }

    public static int findTeleportBiome(CommandSource cs, final ServerPlayerEntity player, final Biome ... biome) {
        StringTextComponent s2;
        final ArrayList<Biome> biomes = new ArrayList<Biome>(Arrays.asList(biome));
        if (biomes.size() == 1) {
            if (CommonConfig.blacklistedBiomes.contains(biome)) {
                StringTextComponent sx = new StringTextComponent(TextFormatting.RED + "This biome is blacklisted.");
                WN.sendChatMessage((PlayerEntity)player, new StringTextComponent("").func_150257_a((ITextComponent)WN.WNPrefix).func_150257_a((ITextComponent)sx));
                return 0;
            }
            s2 = new StringTextComponent(TextFormatting.AQUA + "Trying to find " + TextFormatting.GOLD + new TranslationTextComponent(biomes.get(0).func_210773_k(), new Object[0]).func_150254_d() + TextFormatting.AQUA + " biome...");
        } else {
            StringTextComponent sx;
            int blacklisted = 0;
            for (Biome biome1 : biomes) {
                if (!CommonConfig.blacklistedBiomes.contains(biome1)) continue;
                ++blacklisted;
            }
            if (blacklisted == biomes.size()) {
                sx = new StringTextComponent(TextFormatting.RED + "All choosen biomes are blacklisted.");
                WN.sendChatMessage((PlayerEntity)player, new StringTextComponent("").func_150257_a((ITextComponent)WN.WNPrefix).func_150257_a((ITextComponent)sx));
                return 0;
            }
            if (blacklisted == 1) {
                sx = new StringTextComponent(TextFormatting.RED + "One  of " + biomes.size() + " biomes is blacklisted. Searching still possible");
                WN.sendChatMessage((PlayerEntity)player, new StringTextComponent("").func_150257_a((ITextComponent)WN.WNPrefix).func_150257_a((ITextComponent)sx));
            } else if (blacklisted > 1) {
                sx = new StringTextComponent(TextFormatting.RED + "" + blacklisted + " of " + biomes.size() + " biomes are blacklisted. Searching still possible");
                WN.sendChatMessage((PlayerEntity)player, new StringTextComponent("").func_150257_a((ITextComponent)WN.WNPrefix).func_150257_a((ITextComponent)sx));
            }
            s2 = new StringTextComponent(TextFormatting.AQUA + "Trying to find one of " + TextFormatting.GOLD + biomes.size() + TextFormatting.AQUA + " biomes...");
        }
        WN.sendChatMessage((PlayerEntity)player, new StringTextComponent("").func_150257_a((ITextComponent)WN.WNPrefix).func_150257_a((ITextComponent)s2));
        StringTextComponent sx = new StringTextComponent(TextFormatting.AQUA + "This will take a moment.");
        WN.sendChatMessage((PlayerEntity)player, new StringTextComponent("").func_150257_a((ITextComponent)WN.WNPrefix).func_150257_a((ITextComponent)sx));
        final ServerWorld world = player.func_71121_q();
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                BiomePos biomePos = BiomeArgument.lookForBiome(world, player.func_180425_c().func_177958_n(), player.func_180425_c().func_177952_p(), (PlayerEntity)player, biome);
                if (biomePos != null && biomePos.biome != null && biomePos.pos != null) {
                    BlockPos closestBiomePos = biomePos.pos;
                    double x = closestBiomePos.func_177958_n();
                    double y = BiomeArgument.getTopBlock((IWorld)world, closestBiomePos.func_177958_n(), closestBiomePos.func_177952_p()).func_177956_o();
                    double z = closestBiomePos.func_177952_p();
                    if (!world.func_201675_m().func_76569_d()) {
                        y = BiomeArgument.getY((World)world, closestBiomePos).func_177956_o();
                    }
                    WN.LOGGER.info("Found " + biomePos.biome.getRegistryName() + " biome at " + x + " " + y + " " + z + ". This taken " + radius + " attempts.");
                    StringTextComponent s3 = new StringTextComponent(TextFormatting.AQUA + "Found " + TextFormatting.LIGHT_PURPLE + new TranslationTextComponent(biomePos.biome.func_210773_k(), new Object[0]).func_150254_d() + TextFormatting.AQUA + " biome at ");
                    StringTextComponent s4 = new StringTextComponent(TextFormatting.YELLOW + "" + x + " " + y + " " + z);
                    StringTextComponent s42 = new StringTextComponent(TextFormatting.AQUA + " - " + TextFormatting.GOLD + (int)Utilities.getDistance(new BlockPos(player.func_180425_c().func_177958_n(), player.func_180425_c().func_177956_o(), player.func_180425_c().func_177952_p()), new BlockPos(x, y, z)) + TextFormatting.AQUA + " blocks away.");
                    s4.func_150256_b().func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new StringTextComponent(TextFormatting.GOLD + "Click to copy to the command prompt")));
                    s4.func_150256_b().func_150241_a(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "" + x + " " + y + " " + z));
                    WN.sendChatMessage((PlayerEntity)player, new StringTextComponent("").func_150257_a((ITextComponent)WN.WNPrefix).func_150257_a((ITextComponent)s3).func_150257_a((ITextComponent)s4).func_150257_a((ITextComponent)s42));
                    StringTextComponent s5 = new StringTextComponent(TextFormatting.GREEN + "Click to teleport");
                    s5.func_150256_b().func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new StringTextComponent(TextFormatting.GOLD + "Click here")));
                    s5.func_150256_b().func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tp " + player.func_200200_C_().getString() + " " + x + " " + y + " " + z));
                    WN.sendChatMessage((PlayerEntity)player, new StringTextComponent("").func_150257_a((ITextComponent)WN.WNPrefix).func_150257_a((ITextComponent)s5));
                    player.func_146105_b((ITextComponent)new StringTextComponent(TextFormatting.GREEN + "Found biome " + TextFormatting.AQUA + (int)Utilities.getDistance(new BlockPos(player.func_180425_c().func_177958_n(), player.func_180425_c().func_177956_o(), player.func_180425_c().func_177952_p()), new BlockPos(x, y, z)) + TextFormatting.GREEN + " blocks away"), true);
                } else if (biomes.size() == 1) {
                    StringTextComponent s3 = new StringTextComponent(TextFormatting.RED + "Unable to find " + TextFormatting.LIGHT_PURPLE + ((Biome)biomes.get(0)).getRegistryName() + TextFormatting.RED + " biome.");
                    player.func_146105_b((ITextComponent)new StringTextComponent(TextFormatting.RED + "Unable to find biome"), true);
                    s3.func_150256_b().func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new StringTextComponent(TextFormatting.DARK_RED + "Operation Failed :/")));
                    WN.sendChatMessage((PlayerEntity)player, new StringTextComponent("").func_150257_a((ITextComponent)WN.WNPrefix).func_150257_a((ITextComponent)s3));
                } else {
                    StringTextComponent s3 = new StringTextComponent(TextFormatting.RED + "Unable to find any of " + TextFormatting.LIGHT_PURPLE + biomes.size() + TextFormatting.RED + " biomes.");
                    player.func_146105_b((ITextComponent)new StringTextComponent(TextFormatting.RED + "Unable to find biomes"), true);
                    s3.func_150256_b().func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new StringTextComponent(TextFormatting.DARK_RED + "Operation Failed :/")));
                    WN.sendChatMessage((PlayerEntity)player, new StringTextComponent("").func_150257_a((ITextComponent)WN.WNPrefix).func_150257_a((ITextComponent)s3));
                }
            }
        });
        t.start();
        return 1;
    }

    public static BlockPos getY(World world, BlockPos pos) {
        BlockPos blockpos2;
        IChunk chunk = world.func_217349_x(pos);
        BlockPos blockpos = blockpos2 = new BlockPos(pos.func_177958_n(), chunk.func_76625_h() + 16, pos.func_177952_p());
        while (blockpos.func_177956_o() >= 0) {
            BlockPos blockpos1 = blockpos.func_177977_b();
            BlockState state = chunk.func_180495_p(blockpos1);
            if (!state.func_185904_a().func_76230_c() && !world.func_175623_d(blockpos1.func_177977_b()) && state.func_185904_a() != Material.field_151584_j) {
                return blockpos1;
            }
            blockpos = blockpos1;
        }
        return blockpos2;
    }

    public static BlockPos getTopBlock(IWorld world, int x, int z) {
        IChunk chunk = world.func_217348_a(x >> 4, z >> 4, ChunkStatus.field_222617_m);
        return new BlockPos(x, chunk.func_201576_a(Heightmap.Type.MOTION_BLOCKING, x & 0xF, z & 0xF), z);
    }

    public static BiomePos lookForBiome(ServerWorld world, int startX, int startZ, PlayerEntity player, Biome ... biomeToFind) {
        ArrayList<Biome> biomes = new ArrayList<Biome>(Arrays.asList(biomeToFind));
        speedSearch = true;
        WN.LOGGER.info("Starting searching for " + biomes.size() + " biomes");
        BiomeProvider chunkManager = world.func_72863_F().func_201711_g().func_202090_b();
        int maxDistance = (Integer)CommonConfig.maxSearchRadius.get();
        for (int currDist = 0; currDist < maxDistance; currDist += quality) {
            ArrayList<BlockPos> pos = BiomeArgument.drawCircle(startX, startZ, currDist);
            player.func_146105_b((ITextComponent)new StringTextComponent(TextFormatting.YELLOW + "Searching in radius " + TextFormatting.GOLD + currDist + TextFormatting.YELLOW + "/" + TextFormatting.GOLD + maxDistance), true);
            int x = 0;
            for (BlockPos vec : pos) {
                ++x;
                for (Biome biome : biomes) {
                    if (Utilities.getBiomeOnPos(chunkManager, vec.func_177958_n(), vec.func_177952_p()) != biome) continue;
                    radius = currDist;
                    return new BiomePos(new BlockPos(vec.func_177958_n(), 0, vec.func_177952_p()), biome);
                }
            }
        }
        Biome b = biomes.get(Utilities.rint(0, biomes.size() - 1));
        WN.LOGGER.info("Finding biome on the world, ignoring distance | " + b);
        return BiomeArgument.lookForBiomeAsap(world, b, startX, startZ, player);
    }

    public static BiomePos lookForBiomeAsap(ServerWorld world, Biome biomeToFind, int startX, int startZ, PlayerEntity player) {
        player.func_146105_b((ITextComponent)new StringTextComponent(TextFormatting.YELLOW + "Unable to find the nearest biome. Searching ignoring distance..."), true);
        int sampleSpace = 16384;
        int maxDist = sampleSpace * 100;
        boolean m = false;
        BiomeProvider chunkManager = world.func_72863_F().func_201711_g().func_202090_b();
        double a = (double)sampleSpace / Math.sqrt(Math.PI);
        double b = 2.0 * Math.sqrt(Math.PI);
        double x = 0.0;
        double z = 0.0;
        double dist = 0.0;
        int n = 0;
        n = 0;
        while (dist < (double)maxDist) {
            double rootN = Math.sqrt(n);
            dist = a * rootN;
            x = (double)startX + dist * Math.sin(b * rootN);
            Biome biomeSample = Utilities.getBiomeOnPos(chunkManager, (int)x, (int)(z = (double)startZ + dist * Math.cos(b * rootN)));
            if (biomeSample == biomeToFind) {
                return new BiomePos(new BlockPos((int)x, 0, (int)z), biomeToFind);
            }
            if (n >= 250000) {
                return null;
            }
            ++n;
        }
        return null;
    }

    private static ArrayList<BlockPos> drawCircle(int x, int y, int r) {
        ArrayList<BlockPos> pos = new ArrayList<BlockPos>();
        double PI = Math.PI;
        for (double i = 0.0; i < 360.0; i += 1.0) {
            double angle = i;
            double x1 = (double)r * Math.cos(angle * PI / 180.0);
            double y1 = (double)r * Math.sin(angle * PI / 180.0);
            int ElX = (int)Math.round((double)x + x1);
            int ElY = (int)Math.round((double)y + y1);
            pos.add(new BlockPos(ElX, 0, ElY));
        }
        return pos;
    }

    public static class BiomePos {
        public BlockPos pos;
        public Biome biome;

        public BiomePos(BlockPos pos, Biome biome) {
            this.pos = pos;
            this.biome = biome;
        }
    }
}

