/*
 * Decompiled with CFR 0.152.
 */
package com.matez.wildnature.common.commands;

import com.matez.wildnature.init.WN;
import com.matez.wildnature.util.config.CommonConfig;
import com.matez.wildnature.world.generation.biome.registry.WNBiomes;
import com.matez.wildnature.world.generation.biome.setup.grid.BiomeGroup;
import com.matez.wildnature.world.generation.biome.setup.grid.SubBiome;
import com.matez.wildnature.world.generation.layer.grid.GridBiomeLayer;
import com.matez.wildnature.world.generation.provider.WNWorldType;
import com.matez.wildnature.world.generation.transformer.BiomeTransformer;
import com.matez.wildnature.world.generation.transformer.transformers.MainBiomeTransformer;
import java.io.File;
import java.util.ArrayList;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.loading.FMLPaths;

public class BiomeListCommand {
    private int maxPages;
    private PlayerEntity entity;
    private ArrayList<Biome> list = new ArrayList();

    public BiomeListCommand(PlayerEntity entity) {
        Registry.field_212624_m.forEach(biome -> this.list.add((Biome)biome));
        int i = this.list.size() / 10;
        int a = 0;
        while (a < this.list.size()) {
            a += 10;
            ++this.maxPages;
        }
        this.entity = entity;
    }

    public int showPage(int page) {
        if (this.maxPages < page) {
            WN.sendChatMessage(this.entity, new StringTextComponent("").func_150257_a((ITextComponent)WN.WNPrefix).func_150257_a((ITextComponent)new StringTextComponent(TextFormatting.RED + "Unknown page. Use values from " + TextFormatting.GOLD + "1" + TextFormatting.RED + " to " + TextFormatting.GOLD + this.maxPages + TextFormatting.RED + ".")));
            return 0;
        }
        StringTextComponent s = new StringTextComponent(TextFormatting.GREEN + "Biome List " + TextFormatting.GRAY + " - - - " + TextFormatting.LIGHT_PURPLE + " page " + TextFormatting.AQUA + page + TextFormatting.DARK_AQUA + "/" + TextFormatting.AQUA + this.maxPages);
        ITextComponent hovermsg = new StringTextComponent(TextFormatting.GRAY + "Showing " + TextFormatting.DARK_AQUA + this.list.size() + TextFormatting.GRAY + " biomes").func_150257_a((ITextComponent)new StringTextComponent(TextFormatting.GRAY + "\nIncluding " + TextFormatting.DARK_AQUA + WNBiomes.registerBiomes.size() + TextFormatting.GRAY + " WildNature biomes"));
        s.func_150256_b().func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, hovermsg));
        StringTextComponent s2 = new StringTextComponent(TextFormatting.GOLD + "" + TextFormatting.BOLD + " >>>");
        s2.func_150256_b().func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new StringTextComponent(TextFormatting.GREEN + "Click to show next page")));
        s2.func_150256_b().func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/wn biome list " + (page + 1) + ""));
        ITextComponent s3 = new StringTextComponent("").func_150257_a((ITextComponent)WN.WNPrefix).func_150257_a((ITextComponent)s);
        if (page < this.maxPages) {
            s3.func_150257_a((ITextComponent)s2);
        }
        WN.sendChatMessage(this.entity, s3);
        int startIndex = page * 10 - 10;
        for (int i = 0; i < 10; ++i) {
            try {
                this.showListLine(this.list.get(startIndex + i), startIndex + i + 1 + "");
                continue;
            }
            catch (Exception e) {
                this.showListLine(null, "-");
            }
        }
        return 1;
    }

    public void showListLine(Biome biome, String index) {
        if (biome == null) {
            WN.sendChatMessage(this.entity, new StringTextComponent(TextFormatting.DARK_GRAY + "[" + index + "]").func_150257_a((ITextComponent)new StringTextComponent(TextFormatting.AQUA + " ")));
        } else {
            boolean isWildNature = WNBiomes.registerBiomes.contains(biome);
            String wiki = isWildNature ? "https://wildnaturemod.com/" + biome.getRegistryName().func_110623_a().replace("_", "-") : "";
            String search = "/wn biome locate " + biome.getRegistryName();
            StringTextComponent wikicomponent = null;
            if (wiki.isEmpty()) {
                wikicomponent = new StringTextComponent(TextFormatting.LIGHT_PURPLE + "-");
                wikicomponent.func_150256_b().func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new StringTextComponent(TextFormatting.DARK_RED + "Wiki unavailable for this biome")));
            } else {
                wikicomponent = new StringTextComponent(TextFormatting.LIGHT_PURPLE + "W");
                wikicomponent.func_150256_b().func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new StringTextComponent(TextFormatting.DARK_PURPLE + "Click to see the wiki page for this biome")));
                wikicomponent.func_150256_b().func_150241_a(new ClickEvent(ClickEvent.Action.OPEN_URL, wiki));
            }
            StringTextComponent searchcomponent = new StringTextComponent(TextFormatting.GREEN + "T");
            searchcomponent.func_150256_b().func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new StringTextComponent(TextFormatting.DARK_GREEN + "Click to teleport")));
            searchcomponent.func_150256_b().func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, search));
            boolean active = !CommonConfig.blacklistedBiomes.contains(biome);
            TextFormatting t = TextFormatting.AQUA;
            if (!active) {
                t = TextFormatting.RED;
            }
            StringTextComponent infocomponent = new StringTextComponent(t + new TranslationTextComponent(biome.func_210773_k(), new Object[0]).func_150254_d());
            infocomponent.func_150256_b().func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new StringTextComponent(TextFormatting.GOLD + "--- INFORMATION ---").func_150257_a(BiomeListCommand.getBiomeInfo(biome))));
            infocomponent.func_150256_b().func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/wn biome info " + biome.getRegistryName()));
            WN.sendChatMessage(this.entity, new StringTextComponent(TextFormatting.DARK_GRAY + "[" + index + "] ").func_150257_a((ITextComponent)new StringTextComponent(TextFormatting.GOLD + "" + TextFormatting.BOLD + "|")).func_150257_a((ITextComponent)wikicomponent).func_150257_a((ITextComponent)new StringTextComponent(TextFormatting.GOLD + "" + TextFormatting.BOLD + ":")).func_150257_a((ITextComponent)searchcomponent).func_150257_a((ITextComponent)new StringTextComponent(TextFormatting.GOLD + "" + TextFormatting.BOLD + "|")).func_150257_a((ITextComponent)new StringTextComponent(TextFormatting.GRAY + " - ")).func_150257_a((ITextComponent)infocomponent));
        }
    }

    public static ArrayList<String> getFiles() {
        ArrayList<String> files = new ArrayList<String>();
        File folder = new File(FMLPaths.CONFIGDIR.get().resolve("wildnature/export").toString());
        for (File fileEntry : folder.listFiles()) {
            if (fileEntry.isDirectory()) continue;
            files.add(fileEntry.getName());
        }
        return files;
    }

    public static ITextComponent getBiomeInfo(Biome biome) {
        boolean active = !CommonConfig.blacklistedBiomes.contains(biome);
        BiomeTransformer.TempCategory category = BiomeTransformer.TempCategory.getFromTemperature(-0.1f, 1.0f, biome.func_185353_n());
        BiomeTransformer.WetCategory moisture = BiomeTransformer.WetCategory.getFromMoisture(0.0f, 1.0f, biome.func_76727_i());
        String climaticSpawns = "none";
        String groupSpawns = "none";
        String dictionaries = "none";
        if (WNWorldType.generator != null) {
            GridBiomeLayer layer = WNWorldType.generator.getGridProvider().getLayer();
            MainBiomeTransformer transformer = (MainBiomeTransformer)layer.getMainBiomeTransformer();
            ArrayList<BiomeGroup> usedAsBase = new ArrayList<BiomeGroup>();
            ArrayList<BiomeGroup> usedAsSub = new ArrayList<BiomeGroup>();
            for (MainBiomeTransformer.TerrainCategory terrainValue : MainBiomeTransformer.TerrainCategory.values()) {
                for (BiomeTransformer.TempCategory tempValue : BiomeTransformer.TempCategory.values()) {
                    for (BiomeTransformer.WetCategory wetCategory : BiomeTransformer.WetCategory.values()) {
                        ArrayList<BiomeGroup> usedGroups = new ArrayList<BiomeGroup>();
                        for (BiomeGroup climaticBiomeGroup : transformer.getClimaticBiomeGroups(terrainValue, tempValue, wetCategory)) {
                            if (climaticBiomeGroup.getBaseBiome() == biome) {
                                if (!usedGroups.contains(climaticBiomeGroup)) {
                                    climaticSpawns = climaticSpawns + TextFormatting.DARK_GRAY + "\n---> " + TextFormatting.DARK_AQUA + "Base: " + terrainValue.getName() + "/" + tempValue.getName() + "/" + wetCategory.getName();
                                }
                                usedAsBase.add(climaticBiomeGroup);
                                usedGroups.add(climaticBiomeGroup);
                            }
                            for (SubBiome subBiome : climaticBiomeGroup.getSubBiomes()) {
                                if (subBiome.getBiome() != biome) continue;
                                if (!usedGroups.contains(climaticBiomeGroup)) {
                                    climaticSpawns = climaticSpawns + TextFormatting.DARK_GRAY + "\n---> " + TextFormatting.DARK_AQUA + "Sub: " + terrainValue.getName() + "/" + tempValue.getName() + "/" + wetCategory.getName();
                                }
                                usedAsSub.add(climaticBiomeGroup);
                                usedGroups.add(climaticBiomeGroup);
                            }
                        }
                        usedGroups.clear();
                    }
                }
            }
            String base = "";
            if (usedAsBase.size() > 0) {
                base = "Base biome of:";
                ArrayList<Integer> usedIds = new ArrayList<Integer>();
                for (BiomeGroup group : usedAsBase) {
                    if (usedIds.contains(group.getId())) continue;
                    base = base + TextFormatting.DARK_GRAY + "\n---> " + TextFormatting.DARK_AQUA + "[" + group.getId() + "] " + group.getName();
                    usedIds.add(group.getId());
                }
                usedIds.clear();
            } else {
                base = "Never spawns as base biome";
            }
            String sub = "";
            if (usedAsSub.size() > 0) {
                sub = "SubBiome in:";
                ArrayList<Integer> usedIds = new ArrayList<Integer>();
                for (BiomeGroup group : usedAsSub) {
                    if (usedIds.contains(group.getId())) continue;
                    sub = sub + TextFormatting.DARK_GRAY + "\n---> " + TextFormatting.DARK_AQUA + "[" + group.getId() + "] " + group.getName() + ", base biome: " + group.getBaseBiome().getRegistryName();
                    usedIds.add(group.getId());
                }
                usedIds.clear();
            } else {
                sub = "Never spawns as sub biome";
            }
            groupSpawns = "\n" + base + "\n---\n" + sub;
            usedAsBase.clear();
            usedAsSub.clear();
        }
        if (!BiomeDictionary.getTypes((Biome)biome).isEmpty()) {
            dictionaries = "";
            for (BiomeDictionary.Type type : BiomeDictionary.getTypes((Biome)biome)) {
                dictionaries = dictionaries + " " + type.getName();
            }
        }
        ITextComponent infocomponent = new StringTextComponent("").func_150257_a((ITextComponent)new StringTextComponent(TextFormatting.GRAY + "\n-> " + TextFormatting.DARK_AQUA + "id: " + biome.getRegistryName())).func_150257_a((ITextComponent)new StringTextComponent(TextFormatting.GRAY + "\n-> " + TextFormatting.DARK_AQUA + "index: " + Registry.field_212624_m.func_148757_b((Object)biome))).func_150257_a((ITextComponent)new StringTextComponent(TextFormatting.GRAY + "\n-> " + TextFormatting.DARK_AQUA + "mod: " + new TranslationTextComponent(biome.getRegistryName().func_110624_b(), new Object[0]).func_150254_d())).func_150257_a((ITextComponent)new StringTextComponent(TextFormatting.GRAY + "\n-> " + TextFormatting.DARK_AQUA + "blacklisted: " + !active)).func_150257_a((ITextComponent)new StringTextComponent(TextFormatting.GRAY + "\n-> " + TextFormatting.DARK_AQUA + "category: " + biome.func_201856_r().func_222352_a())).func_150257_a((ITextComponent)new StringTextComponent(TextFormatting.GRAY + "\n-> " + TextFormatting.DARK_AQUA + "temp category: " + category.getName())).func_150257_a((ITextComponent)new StringTextComponent(TextFormatting.GRAY + "\n-> " + TextFormatting.DARK_AQUA + "wet category: " + moisture.getName())).func_150257_a((ITextComponent)new StringTextComponent(TextFormatting.GRAY + "\n-> " + TextFormatting.DARK_AQUA + "dictionaries: " + dictionaries)).func_150257_a((ITextComponent)new StringTextComponent(TextFormatting.GRAY + "\n-> " + TextFormatting.DARK_AQUA + "spawns in: " + climaticSpawns)).func_150257_a((ITextComponent)new StringTextComponent(TextFormatting.GRAY + "\n-> " + TextFormatting.DARK_AQUA + "groups: " + groupSpawns));
        return infocomponent;
    }
}

