/*
 * Decompiled with CFR 0.152.
 */
package com.matez.wildnature.common.commands;

import com.matez.wildnature.common.commands.TestCommand;
import com.matez.wildnature.init.WN;
import com.matez.wildnature.world.generation.biome.setup.WNGenSettings;
import com.matez.wildnature.world.generation.processors.TerrainProcessor;
import com.matez.wildnature.world.generation.processors.ThermalErosionProcessor;
import com.matez.wildnature.world.generation.processors.ThermalErosionTestProcessor;
import com.mojang.brigadier.context.CommandContext;
import java.util.Random;
import net.minecraft.block.Blocks;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IWorld;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.server.ServerWorld;

public class GenDevCommand {
    private TerrainProcessor erosion = new ThermalErosionProcessor();
    private TerrainProcessor erosionTest = new ThermalErosionTestProcessor();

    public int gen(PlayerEntity entity, CommandContext<CommandSource> context, String function) {
        if (TestCommand.checkPlayer(entity)) {
            try {
                ServerWorld world = ((CommandSource)context.getSource()).func_197023_e();
                BlockPos pos = entity.func_180425_c();
                BlockPos.Mutable mutable = new BlockPos.Mutable(pos);
                ChunkPos cp = world.func_175726_f(pos).func_76632_l();
                Chunk[] chunks = new Chunk[]{world.func_212866_a_(cp.field_77276_a, cp.field_77275_b), world.func_212866_a_(cp.field_77276_a + 1, cp.field_77275_b), world.func_212866_a_(cp.field_77276_a - 1, cp.field_77275_b), world.func_212866_a_(cp.field_77276_a, cp.field_77275_b + 1), world.func_212866_a_(cp.field_77276_a, cp.field_77275_b - 1), world.func_212866_a_(cp.field_77276_a + 1, cp.field_77275_b + 1), world.func_212866_a_(cp.field_77276_a + 1, cp.field_77275_b - 1), world.func_212866_a_(cp.field_77276_a - 1, cp.field_77275_b - 1), world.func_212866_a_(cp.field_77276_a - 1, cp.field_77275_b + 1)};
                long start = System.currentTimeMillis();
                boolean valid = true;
                for (Chunk chunk : chunks) {
                    int[] noise = this.getNoiseArray(chunk);
                    if (function.equals("test")) {
                        this.log(entity, "Test function " + chunk.func_76632_l().field_77276_a + ", " + chunk.func_76632_l().field_77275_b + " and " + chunk.func_76632_l().func_180334_c() + ", " + chunk.func_76632_l().func_180333_d());
                        this.testFunction(world, chunk, chunk.func_76632_l(), noise);
                        continue;
                    }
                    if (function.equals("erode")) {
                        this.erodeFunction(world, chunk, chunk.func_76632_l(), noise);
                        continue;
                    }
                    if (function.equals("erodetest")) {
                        this.erodeTestFunction(world, chunk, chunk.func_76632_l(), noise);
                        continue;
                    }
                    valid = false;
                }
                if (!valid) {
                    StringTextComponent s2 = new StringTextComponent(TextFormatting.GOLD + "Not found function called " + TextFormatting.GRAY + function);
                    WN.sendChatMessage(entity, new StringTextComponent("").func_150257_a((ITextComponent)WN.WNPrefix).func_150257_a((ITextComponent)s2));
                    return 0;
                }
                long end = System.currentTimeMillis();
                StringTextComponent s2 = new StringTextComponent(TextFormatting.GREEN + "Generation successful!");
                WN.sendChatMessage(entity, new StringTextComponent("").func_150257_a((ITextComponent)WN.WNPrefix).func_150257_a((ITextComponent)s2));
                this.log(entity, TextFormatting.LIGHT_PURPLE + "Operation took " + TextFormatting.GOLD + (end - start) + "ms" + TextFormatting.LIGHT_PURPLE + " per 9 chunks (per 1 - " + TextFormatting.GOLD + (double)(end - start) / (double)chunks.length + "ms" + TextFormatting.LIGHT_PURPLE + ").");
            }
            catch (Exception e) {
                StringTextComponent s2 = new StringTextComponent(TextFormatting.RED + "Generation failed. " + e.getLocalizedMessage());
                WN.sendChatMessage(entity, new StringTextComponent("").func_150257_a((ITextComponent)WN.WNPrefix).func_150257_a((ITextComponent)s2));
                e.printStackTrace();
            }
            return 1;
        }
        return 0;
    }

    private int[] getNoiseArray(Chunk chunk) {
        ChunkPos pos = chunk.func_76632_l();
        int[] vals = new int[256];
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                vals[x * 16 + z] = chunk.func_201576_a(Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, x, z);
            }
        }
        return vals;
    }

    private void testFunction(ServerWorld world, Chunk chunk, ChunkPos chunkPos, int[] noise) {
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                BlockPos pos = new BlockPos(chunkPos.func_180334_c() + x, noise[x * 16 + z] + 1, chunkPos.func_180333_d() + z);
                world.func_180501_a(pos, Blocks.field_150343_Z.func_176223_P(), 18);
            }
        }
    }

    private void erodeFunction(ServerWorld world, Chunk chunk, ChunkPos chunkPos, int[] noise) {
        this.erosion.init((ChunkGenerator<WNGenSettings>)world.func_72863_F().func_201711_g(), world.func_72905_C());
        this.erosion.process((IWorld)world, (IChunk)chunk, new Random(world.func_72905_C()), chunkPos.field_77276_a, chunkPos.field_77275_b, 0, 0, noise);
    }

    private void erodeTestFunction(ServerWorld world, Chunk chunk, ChunkPos chunkPos, int[] noise) {
        this.erosionTest.init((ChunkGenerator<WNGenSettings>)world.func_72863_F().func_201711_g(), world.func_72905_C());
        this.erosionTest.process((IWorld)world, (IChunk)chunk, new Random(world.func_72905_C()), chunkPos.field_77276_a, chunkPos.field_77275_b, 0, 0, noise);
    }

    private void log(PlayerEntity entity, String text) {
        StringTextComponent s = new StringTextComponent(TextFormatting.GRAY + text);
        WN.sendChatMessage(entity, new StringTextComponent("").func_150257_a((ITextComponent)WN.WNPrefix).func_150257_a((ITextComponent)s));
    }
}

