/*
 * Decompiled with CFR 0.152.
 */
package com.matez.wildnature.common.commands;

import com.matez.wildnature.init.WN;
import com.matez.wildnature.util.other.Pair;
import com.matez.wildnature.world.generation.structures.nature.SchemFeature;
import java.util.ArrayList;
import java.util.Comparator;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;

public class StructureListCommand {
    private int maxPages;
    private final PlayerEntity entity;
    private final ArrayList<Pair<String, SchemFeature>> schemFeatures = new ArrayList();

    public StructureListCommand(PlayerEntity entity) {
        int a = 0;
        while (a < SchemFeature.schemFeatures.size()) {
            a += 10;
            ++this.maxPages;
        }
        SchemFeature.schemFeatures.forEach((key, value) -> this.schemFeatures.add(new Pair<String, SchemFeature>((String)key, (SchemFeature)((Object)value))));
        this.schemFeatures.sort(new Comparator<Pair<String, SchemFeature>>(){

            @Override
            public int compare(Pair<String, SchemFeature> o1, Pair<String, SchemFeature> o2) {
                return o1.getKey().compareTo(o2.getKey());
            }
        });
        this.entity = entity;
    }

    public int showPage(int page) {
        if (this.maxPages < page) {
            WN.sendChatMessage(this.entity, new StringTextComponent("").func_150257_a((ITextComponent)WN.WNPrefix).func_150257_a((ITextComponent)new StringTextComponent(TextFormatting.RED + "Unknown page. Use values from " + TextFormatting.GOLD + "1" + TextFormatting.RED + " to " + TextFormatting.GOLD + this.maxPages + TextFormatting.RED + ".")));
            return 0;
        }
        StringTextComponent s = new StringTextComponent(TextFormatting.GREEN + "Structure List " + TextFormatting.GRAY + " - - - " + TextFormatting.LIGHT_PURPLE + " page " + TextFormatting.AQUA + page + TextFormatting.DARK_AQUA + "/" + TextFormatting.AQUA + this.maxPages);
        StringTextComponent hovermsg = new StringTextComponent(TextFormatting.GRAY + "Showing " + TextFormatting.DARK_AQUA + SchemFeature.schemFeatures.size() + TextFormatting.GRAY + " structures");
        s.func_150256_b().func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)hovermsg));
        StringTextComponent s2 = new StringTextComponent(TextFormatting.GOLD + "" + TextFormatting.BOLD + " >>>");
        s2.func_150256_b().func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new StringTextComponent(TextFormatting.GREEN + "Click to show next page")));
        s2.func_150256_b().func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/wn structure list " + (page + 1) + ""));
        ITextComponent s3 = new StringTextComponent("").func_150257_a((ITextComponent)WN.WNPrefix).func_150257_a((ITextComponent)s);
        if (page < this.maxPages) {
            s3.func_150257_a((ITextComponent)s2);
        }
        WN.sendChatMessage(this.entity, s3);
        int startIndex = page * 10 - 10;
        for (int i = 0; i < 10; ++i) {
            try {
                this.showListLine(SchemFeature.schemFeatures.values().toArray()[startIndex + i], startIndex + i + 1 + "");
                continue;
            }
            catch (Exception e) {
                this.showListLine(null, "-");
            }
        }
        return 1;
    }

    public void showListLine(Object obj, String index) {
        if (!(obj instanceof SchemFeature)) {
            WN.sendChatMessage(this.entity, new StringTextComponent(TextFormatting.DARK_GRAY + "[" + index + "]").func_150257_a((ITextComponent)new StringTextComponent(TextFormatting.AQUA + " ")));
        } else {
            SchemFeature f = (SchemFeature)((Object)obj);
            StringTextComponent infocomponent = new StringTextComponent(((Object)((Object)f)).getClass().getSimpleName().toLowerCase());
            WN.sendChatMessage(this.entity, new StringTextComponent(TextFormatting.DARK_GRAY + "[" + index + "] " + TextFormatting.AQUA).func_150257_a((ITextComponent)infocomponent));
        }
    }
}

