/*
 * Decompiled with CFR 0.152.
 */
package com.matez.wildnature.common.commands;

import com.matez.wildnature.init.WN;
import com.matez.wildnature.util.event.PlayerEventHandler;
import com.matez.wildnature.world.generation.biome.setup.BiomeVariants;
import com.matez.wildnature.world.generation.biome.setup.grid.BiomeGroup;
import com.matez.wildnature.world.generation.biome.setup.grid.IslandBiome;
import com.matez.wildnature.world.generation.chunk.generation.ChunkArraySampler;
import com.matez.wildnature.world.generation.chunk.generation.landscape.ChunkLandscape;
import com.matez.wildnature.world.generation.generators.functions.interpolation.BiomeBlender;
import com.matez.wildnature.world.generation.generators.functions.interpolation.LerpConfiguration;
import com.matez.wildnature.world.generation.grid.Cell;
import com.matez.wildnature.world.generation.layer.SmoothColumnBiomeMagnifier;
import com.matez.wildnature.world.generation.provider.WNGridBiomeProvider;
import com.matez.wildnature.world.generation.provider.WNWorldType;
import com.matez.wildnature.world.generation.transformer.BiomeTransformer;
import com.matez.wildnature.world.generation.transformer.transformers.IslandTransformer;
import com.matez.wildnature.world.generation.transformer.transformers.MainBiomeTransformer;
import com.matez.wildnature.world.generation.transformer.transformers.ShoreTransformer;
import com.mojang.brigadier.context.CommandContext;
import it.unimi.dsi.fastutil.objects.Object2DoubleMap;
import it.unimi.dsi.fastutil.objects.Object2DoubleOpenHashMap;
import java.util.function.Function;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeManager;
import net.minecraft.world.biome.ColumnFuzzedBiomeMagnifier;
import net.minecraft.world.chunk.IChunk;

public class TestCommand {
    private final BiomeTransformer mainBiomeTransformer = new MainBiomeTransformer();
    private final BiomeTransformer shoreTransformer = new ShoreTransformer();
    private final BiomeTransformer smallIslandTransformer = new IslandTransformer(IslandBiome.IslandType.SMALL);
    private final BiomeTransformer bigIslandTransformer = new IslandTransformer(IslandBiome.IslandType.BIG);

    public int test(PlayerEntity entity, CommandContext<CommandSource> context) {
        if (TestCommand.checkPlayer(entity)) {
            try {
                this.execute(entity);
                StringTextComponent s2 = new StringTextComponent(TextFormatting.GREEN + "Execution successful!");
                WN.sendChatMessage(entity, new StringTextComponent("").func_150257_a((ITextComponent)WN.WNPrefix).func_150257_a((ITextComponent)s2));
            }
            catch (Exception e) {
                StringTextComponent s2 = new StringTextComponent(TextFormatting.RED + "Execution failed. " + e.getLocalizedMessage());
                WN.sendChatMessage(entity, new StringTextComponent("").func_150257_a((ITextComponent)WN.WNPrefix).func_150257_a((ITextComponent)s2));
                System.out.println(e.getStackTrace());
            }
            return 1;
        }
        return 0;
    }

    private void execute(PlayerEntity entity) {
        World worldIn = entity.func_130014_f_();
        ChunkPos pos = worldIn.func_175726_f(entity.func_180425_c()).func_76632_l();
        if (WNWorldType.generator != null) {
            WNGridBiomeProvider provider = WNWorldType.generator.getGridProvider();
            int rx = entity.func_180425_c().func_177958_n();
            int ry = entity.func_180425_c().func_177956_o();
            int rz = entity.func_180425_c().func_177952_p();
            Cell cell = provider.getNoiseCell(rx / 4, rz / 4);
            Biome biome = provider.func_225526_b_(rx / 4, ry, rz / 4);
            Biome biome2 = provider.func_225526_b_(rx >> 2, ry, rz >> 2);
            Biome biome3 = ColumnFuzzedBiomeMagnifier.INSTANCE.func_225532_a_(worldIn.func_72905_C(), rx, 0, rz, (BiomeManager.IBiomeReader)worldIn);
            Biome biome4 = SmoothColumnBiomeMagnifier.SMOOTH.func_225532_a_(worldIn.func_72905_C(), rx, 0, rz, (BiomeManager.IBiomeReader)worldIn);
            ChunkLandscape landscape = ChunkLandscape.getOrCreate(rx, rz, worldIn.func_72905_C(), worldIn.func_181545_F(), biome, (IChunk)worldIn.func_212866_a_(pos.field_77276_a, pos.field_77275_b));
            int directionMove = 16;
            Cell northCell = provider.getNoiseCell(rx / 4 + directionMove, rz / 4).copy();
            Cell southCell = provider.getNoiseCell(rx / 4 - directionMove, rz / 4).copy();
            Cell eastCell = provider.getNoiseCell(rx / 4, rz / 4 + directionMove).copy();
            Cell westCell = provider.getNoiseCell(rx / 4, rz / 4 - directionMove).copy();
            BiomeGroup centerBG = this.mainBiomeTransformer.bgApply(cell);
            BiomeGroup northBiomeGroup = this.mainBiomeTransformer.bgApply(northCell);
            BiomeGroup southBiomeGroup = this.mainBiomeTransformer.bgApply(southCell);
            BiomeGroup eastBiomeGroup = this.mainBiomeTransformer.bgApply(eastCell);
            BiomeGroup westBiomeGroup = this.mainBiomeTransformer.bgApply(westCell);
            centerBG = this.smallIslandTransformer.bgApply(centerBG, cell);
            centerBG = this.bigIslandTransformer.bgApply(centerBG, cell);
            northBiomeGroup = this.smallIslandTransformer.bgApply(northBiomeGroup, northCell);
            northBiomeGroup = this.bigIslandTransformer.bgApply(northBiomeGroup, northCell);
            southBiomeGroup = this.smallIslandTransformer.bgApply(southBiomeGroup, southCell);
            southBiomeGroup = this.bigIslandTransformer.bgApply(southBiomeGroup, southCell);
            eastBiomeGroup = this.smallIslandTransformer.bgApply(eastBiomeGroup, eastCell);
            eastBiomeGroup = this.bigIslandTransformer.bgApply(eastBiomeGroup, eastCell);
            westBiomeGroup = this.smallIslandTransformer.bgApply(westBiomeGroup, westCell);
            westBiomeGroup = this.bigIslandTransformer.bgApply(westBiomeGroup, westCell);
            BiomeGroup shoreBiomeGroup = this.shoreTransformer.apply(centerBG, northBiomeGroup, southBiomeGroup, eastBiomeGroup, westBiomeGroup, cell);
            this.log(entity, "Biome identity: " + cell.biomeCellIdentity);
            this.log(entity, "NBiome identity: " + northCell.biomeCellIdentity);
            this.log(entity, "SBiome identity: " + southCell.biomeCellIdentity);
            this.log(entity, "EBiome identity: " + eastCell.biomeCellIdentity);
            this.log(entity, "WBiome identity: " + westCell.biomeCellIdentity);
            this.log(entity, "SubBiome identity: " + cell.subBiomeCellIdentity);
            this.log(entity, "SmallIsland identity: " + cell.smallIslandCellIdentity);
            this.log(entity, "BigIsland identity: " + cell.bigIslandCellIdentity);
            this.log(entity, "Temperature: " + cell.temparature);
            this.log(entity, "Moisture: " + cell.moisture);
            this.log(entity, "Cell Temperature: " + cell.cellTemparature);
            this.log(entity, "Cell Moisture: " + cell.cellMoisture);
            this.log(entity, "Continent Value: " + cell.continentValue);
            this.log(entity, "Cell Continent: " + cell.cellContinent);
            this.log(entity, "Category: " + (Object)((Object)BiomeTransformer.getCategoryFromContinent(cell.continentValue)));
            this.log(entity, "Current TempCategory: " + BiomeTransformer.TempCategory.getFromTemperature(-0.1f, 1.0f, biome.func_185353_n()).getName());
            this.log(entity, "Current WetCategory: " + BiomeTransformer.WetCategory.getFromMoisture(0.0f, 1.0f, biome.func_76727_i()).getName());
            this.log(entity, "Cell TempCategory: " + BiomeTransformer.TempCategory.getFromTemperature(-1.0f, 1.0f, cell.cellTemparature).getName());
            this.log(entity, "Cell WetCategory: " + BiomeTransformer.WetCategory.getFromMoisture(-1.0f, 1.0f, cell.cellMoisture).getName());
            this.log(entity, "Biome/4: " + biome.getRegistryName());
            this.log(entity, "Biome>>2: " + biome2.getRegistryName());
            this.log(entity, "BiomeCF: " + biome3.getRegistryName());
            this.log(entity, "BiomeSF: " + biome4.getRegistryName());
            this.log(entity, "CenterBG: " + centerBG.getId() + ": " + centerBG.getBaseBiome().getRegistryName().toString());
            this.log(entity, "NBG: " + northBiomeGroup.getId() + ": " + northBiomeGroup.getBaseBiome().getRegistryName().toString());
            this.log(entity, "SBG: " + southBiomeGroup.getId() + ": " + southBiomeGroup.getBaseBiome().getRegistryName().toString());
            this.log(entity, "EBG: " + eastBiomeGroup.getId() + ": " + eastBiomeGroup.getBaseBiome().getRegistryName().toString());
            this.log(entity, "WBG: " + westBiomeGroup.getId() + ": " + westBiomeGroup.getBaseBiome().getRegistryName().toString());
            this.log(entity, "SHORE: " + shoreBiomeGroup.getId() + ": " + shoreBiomeGroup.getBaseBiome().getRegistryName().toString());
            this.log(entity, "D: " + biome.func_185355_j() + " S: " + biome.func_185360_m() + "DS: " + (biome.func_185355_j() + biome.func_185360_m()));
            Object2DoubleOpenHashMap weightMap16 = new Object2DoubleOpenHashMap(4);
            Object2DoubleOpenHashMap weightMap4 = new Object2DoubleOpenHashMap(2);
            Object2DoubleOpenHashMap weightMap1 = new Object2DoubleOpenHashMap();
            ChunkArraySampler.CoordinateAccessor<Biome> biomeAccessor = (x, z) -> SmoothColumnBiomeMagnifier.SMOOTH.func_225532_a_(worldIn.func_72905_C(), pos.field_77276_a * 16 + x, 0, pos.field_77275_b * 16 + z, (BiomeManager.IBiomeReader)worldIn);
            Biome[] sampledBiomes16 = ChunkArraySampler.fillSampledArray(new Biome[100], biomeAccessor, 4);
            Biome[] sampledBiomes4 = ChunkArraySampler.fillSampledArray(new Biome[169], biomeAccessor, 2);
            Biome[] sampledBiomes1 = ChunkArraySampler.fillSampledArray(new Biome[576], biomeAccessor);
            for (int x2 = 0; x2 < 16; ++x2) {
                for (int z2 = 0; z2 < 16; ++z2) {
                    if (pos.field_77276_a * 16 + x2 != entity.func_180425_c().func_177958_n() || pos.field_77275_b * 16 + z2 != entity.func_180425_c().func_177952_p()) continue;
                    this.log(entity, "Position: " + entity.func_180425_c().func_177958_n() + ", " + entity.func_180425_c().func_177952_p());
                    ChunkArraySampler.fillSampledWeightMap(sampledBiomes16, weightMap16, 4, x2, z2);
                    ChunkArraySampler.fillSampledWeightMap(sampledBiomes4, weightMap4, 2, x2, z2);
                    ChunkArraySampler.fillSampledWeightMap(sampledBiomes1, weightMap1, x2, z2);
                    Function<Biome, BiomeVariants> variantAccessor = BiomeVariants::getVariantsFor;
                    ChunkArraySampler.reduceGroupedWeightMap(weightMap4, weightMap16, variantAccessor.andThen(BiomeVariants::getLargeGroup), BiomeVariants.LargeGroup.SIZE);
                    ChunkArraySampler.reduceGroupedWeightMap(weightMap1, weightMap4, variantAccessor.andThen(BiomeVariants::getSmallGroup), BiomeVariants.SmallGroup.SIZE);
                    double[] values = this.smoothLerp(entity, pos.field_77276_a * 16 + x2, pos.field_77275_b * 16 + z2, biome, (Object2DoubleMap<Biome>)weightMap1, variantAccessor);
                    this.log(entity, "Height: " + values[0]);
                    this.log(entity, "Sample noise: " + landscape.sampleNoise(rx, rz, values[0], values[1], true));
                }
            }
        }
    }

    public double[] smoothLerp(PlayerEntity entity, int x, int z, Biome biomeIn, Object2DoubleMap<Biome> weightMap1, Function<Biome, BiomeVariants> variantAccessor) {
        double totalHeight = 0.0;
        double totalScale = 0.0;
        double biomeInHeight = BiomeBlender.getDepth(LerpConfiguration.get(biomeIn).getDepth());
        for (Object2DoubleMap.Entry entry : weightMap1.object2DoubleEntrySet()) {
            Biome biome = (Biome)entry.getKey();
            double weight = entry.getDoubleValue();
            double height = weight * BiomeBlender.getDepth(biomeIn.func_185355_j());
            double scale = weight * BiomeBlender.getScale(biome.func_185360_m());
            totalHeight += height;
            totalScale += scale;
        }
        this.log(entity, "Biome Depth: " + biomeInHeight);
        return new double[]{totalHeight, totalScale};
    }

    private double sigmoid(double noise) {
        return 256.0 / (Math.exp(2.6666667461395264 - noise / 48.0) + 1.0);
    }

    private static double scaleBetween(double unscaledNum, double minAllowed, double maxAllowed, double min, double max) {
        return (maxAllowed - minAllowed) * (unscaledNum - min) / (max - min) + minAllowed;
    }

    public static boolean checkPlayer(PlayerEntity entity) {
        int x = 0;
        try {
            x = PlayerEventHandler.isPatron(entity).getType();
        }
        catch (NullPointerException e) {
            x = -1;
        }
        if (x == 1 || x == 2 || x == 3) {
            StringTextComponent s2 = new StringTextComponent(TextFormatting.AQUA + "Running the dev command... ");
            WN.sendChatMessage(entity, new StringTextComponent("").func_150257_a((ITextComponent)WN.WNPrefix).func_150257_a((ITextComponent)s2));
            return true;
        }
        StringTextComponent s2 = new StringTextComponent(TextFormatting.AQUA + "This is a developer command. It's useless for you :)");
        WN.sendChatMessage(entity, new StringTextComponent("").func_150257_a((ITextComponent)WN.WNPrefix).func_150257_a((ITextComponent)s2));
        return false;
    }

    private void log(PlayerEntity entity, String text) {
        StringTextComponent s = new StringTextComponent(TextFormatting.GRAY + text);
        WN.sendChatMessage(entity, new StringTextComponent("").func_150257_a((ITextComponent)WN.WNPrefix).func_150257_a((ITextComponent)s));
    }
}

