/*
 * Decompiled with CFR 0.152.
 */
package com.matez.wildnature.common.entity.AI;

import com.matez.wildnature.init.WN;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ItemParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeHooks;

public class BreakBlocksGoal
extends MoveToBlockGoal {
    private final ArrayList<Block> blocks;
    private final MobEntity entity;
    private int breakingTime;

    public BreakBlocksGoal(CreatureEntity creature, double speed, int yMax, Block ... blocks) {
        super(creature, speed, 24, yMax);
        this.blocks = new ArrayList<Block>(Arrays.asList(blocks));
        this.entity = creature;
    }

    public boolean func_75250_a() {
        if (!ForgeHooks.canEntityDestroy((World)this.entity.field_70170_p, (BlockPos)this.field_179494_b, (LivingEntity)this.entity)) {
            return false;
        }
        if (this.field_179496_a > 0) {
            --this.field_179496_a;
            return false;
        }
        if (this.func_220729_m()) {
            this.field_179496_a = 20;
            return true;
        }
        this.field_179496_a = this.func_203109_a(this.field_179495_c);
        return false;
    }

    private boolean func_220729_m() {
        return this.field_179494_b != null && this.func_179488_a((IWorldReader)this.field_179495_c.field_70170_p, this.field_179494_b) ? true : this.func_179489_g();
    }

    public void func_75251_c() {
        super.func_75251_c();
        this.entity.field_70143_R = 1.0f;
    }

    public void func_75249_e() {
        super.func_75249_e();
        this.breakingTime = 0;
    }

    public void playBreakingSound(IWorld p_203114_1_, BlockPos p_203114_2_) {
    }

    public void playBrokenSound(World p_203116_1_, BlockPos p_203116_2_) {
    }

    public void func_75246_d() {
        super.func_75246_d();
        World world = this.entity.field_70170_p;
        BlockPos blockpos = new BlockPos((Entity)this.entity);
        BlockPos blockpos1 = this.findTarget(blockpos, (IBlockReader)world);
        Random random = this.entity.func_70681_au();
        if (this.func_179487_f() && blockpos1 != null) {
            if (this.breakingTime > 0) {
                Vec3d vec3d = this.entity.func_213322_ci();
                this.entity.func_213293_j(vec3d.field_72450_a, 0.3, vec3d.field_72449_c);
                if (!world.field_72995_K) {
                    double d0 = 0.08;
                    ((ServerWorld)world).func_195598_a((IParticleData)new ItemParticleData(ParticleTypes.field_197591_B, new ItemStack((IItemProvider)Items.field_151110_aK)), (double)blockpos1.func_177958_n() + 0.5, (double)blockpos1.func_177956_o() + 0.7, (double)blockpos1.func_177952_p() + 0.5, 3, ((double)random.nextFloat() - 0.5) * 0.08, ((double)random.nextFloat() - 0.5) * 0.08, ((double)random.nextFloat() - 0.5) * 0.08, (double)0.15f);
                }
            }
            if (this.breakingTime % 2 == 0) {
                Vec3d vec3d1 = this.entity.func_213322_ci();
                this.entity.func_213293_j(vec3d1.field_72450_a, -0.3, vec3d1.field_72449_c);
                if (this.breakingTime % 6 == 0) {
                    this.playBreakingSound((IWorld)world, this.field_179494_b);
                }
            }
            if (this.breakingTime > 60) {
                WN.LOGGER.debug("Breaking block");
                world.func_175655_b(blockpos1, true);
                if (!world.field_72995_K) {
                    for (int i = 0; i < 20; ++i) {
                        double d3 = random.nextGaussian() * 0.02;
                        double d1 = random.nextGaussian() * 0.02;
                        double d2 = random.nextGaussian() * 0.02;
                        ((ServerWorld)world).func_195598_a((IParticleData)ParticleTypes.field_197598_I, (double)blockpos1.func_177958_n() + 0.5, (double)blockpos1.func_177956_o(), (double)blockpos1.func_177952_p() + 0.5, 1, d3, d1, d2, (double)0.15f);
                    }
                    this.playBrokenSound(world, blockpos1);
                }
            }
            ++this.breakingTime;
        }
    }

    @Nullable
    private BlockPos findTarget(BlockPos p_203115_1_, IBlockReader p_203115_2_) {
        BlockPos[] ablockpos;
        if (this.checkIfBlockEquals(p_203115_2_.func_180495_p(p_203115_1_).func_177230_c())) {
            return p_203115_1_;
        }
        for (BlockPos blockpos : ablockpos = new BlockPos[]{p_203115_1_.func_177977_b(), p_203115_1_.func_177976_e(), p_203115_1_.func_177974_f(), p_203115_1_.func_177978_c(), p_203115_1_.func_177968_d(), p_203115_1_.func_177977_b().func_177977_b()}) {
            if (!this.checkIfBlockEquals(p_203115_2_.func_180495_p(blockpos).func_177230_c())) continue;
            return blockpos;
        }
        return null;
    }

    protected boolean func_179488_a(IWorldReader worldIn, BlockPos pos) {
        IChunk ichunk = worldIn.func_217353_a(pos.func_177958_n() >> 4, pos.func_177952_p() >> 4, ChunkStatus.field_222617_m, false);
        if (ichunk == null) {
            return false;
        }
        return this.checkIfBlockEquals(ichunk.func_180495_p(pos).func_177230_c()) && ichunk.func_180495_p(pos.func_177984_a()).func_196958_f() && ichunk.func_180495_p(pos.func_177981_b(2)).func_196958_f();
    }

    public boolean checkIfBlockEquals(Block b) {
        for (Block block : this.blocks) {
            if (block != b) continue;
            return true;
        }
        return false;
    }
}

