/*
 * Decompiled with CFR 0.152.
 */
package com.matez.wildnature.common.entity.AI;

import com.matez.wildnature.common.entity.type.animal.IFamily;
import com.matez.wildnature.common.entity.type.animal.duck.AbstractDuckEntity;
import com.matez.wildnature.init.WN;
import com.matez.wildnature.util.other.Utilities;
import java.util.ArrayList;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;

public class CreateGroupGoal
extends Goal {
    public static ArrayList<AbstractDuckEntity> runningInstances = new ArrayList();
    private AbstractDuckEntity duck;
    private double maxGroupingDistance = 10.0;

    public CreateGroupGoal(AbstractDuckEntity duck) {
        this.duck = duck;
    }

    public boolean func_75250_a() {
        return this.duck.getGroup().size() <= 4;
    }

    public void func_75249_e() {
        boolean runningNearby = false;
        for (AbstractDuckEntity runningInstance : runningInstances) {
            double dist = Utilities.getDistance(runningInstance.func_180425_c(), this.duck.func_180425_c());
            if (!(dist < this.maxGroupingDistance)) continue;
            runningNearby = true;
            break;
        }
        if (!runningNearby) {
            double distance;
            AbstractDuckEntity nearestLeader;
            runningInstances.add(this.duck);
            ArrayList<AbstractDuckEntity> group = this.duck.getGroup();
            if (!group.contains(this.duck)) {
                group.add(this.duck);
            }
            if ((nearestLeader = this.getNearestLeader(this.duck.func_180425_c())) != null && nearestLeader.func_70089_S() && (distance = (double)Utilities.getDistance(nearestLeader.func_180425_c(), this.duck.func_180425_c())) <= this.maxGroupingDistance) {
                group = nearestLeader.getGroup();
            }
            WN.LOGGER.debug("Current group: " + group.size() + " : " + group);
            ArrayList entities = new ArrayList(this.duck.func_130014_f_().func_217357_a(AbstractDuckEntity.class, this.duck.func_174813_aQ().func_72314_b(8.0, 4.0, 8.0)));
            for (AbstractDuckEntity entity : entities) {
                double dist = Utilities.getDistance(entity.func_180425_c(), this.duck.func_180425_c());
                if (!(dist < this.maxGroupingDistance) || group.contains(entity) || !entity.getGroup().isEmpty() && entity.getGroup().size() != 1) continue;
                group.add(entity);
                WN.LOGGER.info("Added to group(" + group.size() + ") " + entity.func_180425_c());
            }
            boolean hasGroupLeader = false;
            AbstractDuckEntity leader = null;
            for (AbstractDuckEntity abstractDuckEntity : group) {
                if (!abstractDuckEntity.isGroupLeader()) continue;
                hasGroupLeader = true;
                leader = abstractDuckEntity;
                break;
            }
            if (!hasGroupLeader) {
                AbstractDuckEntity e = null;
                for (AbstractDuckEntity abstractDuckEntity : group) {
                    if (abstractDuckEntity.getGender() == IFamily.Gender.MALE) {
                        e = abstractDuckEntity;
                        continue;
                    }
                    if (group.indexOf(abstractDuckEntity) != group.size() - 1) continue;
                    e = abstractDuckEntity;
                }
                assert (e != null);
                int n = group.indexOf(e);
                WN.LOGGER.info("New group leader is on " + e.func_180425_c());
                e.setGroupLeader(true);
                group.set(n, e);
                leader = e;
            }
            leader.setGroup(group);
            for (AbstractDuckEntity abstractDuckEntity : group) {
                abstractDuckEntity.setLeader(leader);
            }
            leader.func_200203_b((ITextComponent)new StringTextComponent(TextFormatting.GREEN + "Leader " + leader.getGroup().size()));
            WN.LOGGER.debug("After group: " + group.size() + " : " + this.duck.getGroup());
            runningInstances.remove(this.duck);
        }
    }

    public AbstractDuckEntity getNearestLeader(BlockPos pos) {
        ArrayList entities = new ArrayList(this.duck.func_130014_f_().func_217357_a(AbstractDuckEntity.class, this.duck.func_174813_aQ().func_72314_b(8.0, 4.0, 8.0)));
        ArrayList<AbstractDuckEntity> leaders = new ArrayList<AbstractDuckEntity>();
        AbstractDuckEntity nearestLeader = null;
        double nearest = 0.0;
        for (AbstractDuckEntity entity : entities) {
            if (!entity.isGroupLeader()) continue;
            leaders.add(entity);
        }
        for (AbstractDuckEntity leader : leaders) {
            if (nearestLeader == null) {
                nearestLeader = leader;
                nearest = Utilities.blockDistance(pos, leader.func_180425_c());
                continue;
            }
            int dist = Utilities.blockDistance(pos, leader.func_180425_c());
            if (!((double)dist < nearest)) continue;
            nearestLeader = leader;
            nearest = dist;
        }
        entities.clear();
        leaders.clear();
        return nearestLeader;
    }

    public AbstractDuckEntity getLeader() {
        if (this.duck.isGroupLeader) {
            return this.duck;
        }
        for (AbstractDuckEntity abstractDuckEntity : this.duck.getGroup()) {
            if (!abstractDuckEntity.isGroupLeader()) continue;
            return abstractDuckEntity;
        }
        return null;
    }
}

