/*
 * Decompiled with CFR 0.152.
 */
package com.matez.wildnature.common.entity.AI;

import com.matez.wildnature.init.WN;
import com.matez.wildnature.util.other.Utilities;
import java.util.EnumSet;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class FlyingGoal
extends Goal {
    private AnimalEntity entity;
    private int followRange;
    private double speed;
    private int startFlyingChance;
    private int endFlyingChance;
    private int maxFlyDistance;
    private Random rand = new Random();
    private BlockPos startPos = null;
    private BlockPos startAirPos = null;
    private boolean lookSet = false;

    public FlyingGoal(AnimalEntity entity, int followRange, double speed, int startFlyingChance, int endFlyingChance, int maxFlyDistance) {
        this.entity = entity;
        this.followRange = followRange;
        this.speed = speed;
        this.startFlyingChance = startFlyingChance;
        this.endFlyingChance = endFlyingChance;
        this.maxFlyDistance = maxFlyDistance;
        this.func_220684_a(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.LOOK, Goal.Flag.MOVE));
    }

    public boolean func_75250_a() {
        BlockPos airPos;
        if (Utilities.rint(0, this.startFlyingChance) == 0 && (airPos = this.findTarget(this.entity.func_180425_c(), (IBlockReader)this.entity.func_130014_f_())) != null) {
            boolean isNavigating = this.entity.func_70661_as().func_75492_a((double)airPos.func_177958_n(), (double)airPos.func_177956_o(), (double)airPos.func_177952_p(), Utilities.rdoub(this.speed - this.speed / 5.0, this.speed + this.speed / 5.0));
            WN.LOGGER.debug("navi: " + isNavigating + "   " + airPos);
            this.startAirPos = airPos;
            this.startPos = new BlockPos((Vec3i)this.entity.func_180425_c());
            return isNavigating;
        }
        return false;
    }

    public boolean func_75253_b() {
        return Utilities.getDistance(this.startAirPos, this.entity.func_180425_c()) < (float)this.maxFlyDistance && this.isInAir();
    }

    public void func_75246_d() {
        WN.LOGGER.debug("tick " + Utilities.getDistance(this.entity.func_180425_c(), this.startAirPos) + " air: " + this.isInAir());
        if (Utilities.getDistance(this.entity.func_180425_c(), this.startAirPos) < 3.0f) {
            if (!this.lookSet) {
                double lvt_1_1_ = Math.PI * 2 * this.rand.nextDouble();
                double lookX = Math.cos(lvt_1_1_);
                double lookZ = Math.sin(lvt_1_1_);
                this.entity.func_70671_ap().func_220679_a((double)this.entity.func_180425_c().func_177958_n() + lookX, (double)this.entity.func_180425_c().func_177956_o() + (double)this.entity.func_70047_e(), (double)this.entity.func_180425_c().func_177952_p() + lookZ);
                this.lookSet = true;
            }
            if (this.isInAir()) {
                this.entity.func_191989_p((float)Utilities.rdoub(this.speed - this.speed / 5.0, this.speed + this.speed / 5.0));
                this.entity.func_70657_f((float)Utilities.rdoub(-0.3, 0.3));
                WN.LOGGER.debug("Flying");
            }
        } else {
            this.entity.func_70661_as().func_75492_a((double)this.startAirPos.func_177958_n(), (double)this.startAirPos.func_177956_o(), (double)this.startAirPos.func_177952_p(), Utilities.rdoub(this.speed - this.speed / 5.0, this.speed + this.speed / 5.0));
        }
    }

    public void func_75251_c() {
        WN.LOGGER.debug("reseting");
        this.lookSet = false;
        BlockPos landPos = this.land(this.entity.func_180425_c(), (IBlockReader)this.entity.func_130014_f_());
        if (landPos != null) {
            this.entity.func_70661_as().func_75492_a((double)landPos.func_177958_n(), (double)landPos.func_177956_o(), (double)landPos.func_177952_p(), Utilities.rdoub(this.speed - this.speed / 5.0, this.speed + this.speed / 5.0));
        }
    }

    public boolean isInAir() {
        World world = this.entity.func_130014_f_();
        BlockPos pos = this.entity.func_180425_c();
        try {
            if (!world.func_180495_p(pos.func_177972_a(Direction.NORTH)).func_196958_f()) {
                return false;
            }
            if (!world.func_180495_p(pos.func_177972_a(Direction.SOUTH)).func_196958_f()) {
                return false;
            }
            if (!world.func_180495_p(pos.func_177972_a(Direction.EAST)).func_196958_f()) {
                return false;
            }
            return world.func_180495_p(pos.func_177972_a(Direction.WEST)).func_196958_f();
        }
        catch (Exception e) {
            return false;
        }
    }

    @Nullable
    private BlockPos findTarget(BlockPos blockpos, IBlockReader world) {
        for (int j = 0; j < 128; ++j) {
            BlockPos b = blockpos.func_177982_a(this.rand.nextInt(this.followRange) - this.rand.nextInt(this.followRange), this.rand.nextInt(this.followRange) - this.rand.nextInt(this.followRange), this.rand.nextInt(this.followRange) - this.rand.nextInt(this.followRange));
            if (!world.func_180495_p(b).func_196958_f() || !(Utilities.getDistance(blockpos, b) < (float)(this.followRange - 1))) continue;
            return b;
        }
        return null;
    }

    @Nullable
    private BlockPos land(BlockPos blockpos, IBlockReader world) {
        for (int j = 0; j < 128; ++j) {
            BlockPos b = blockpos.func_177982_a(this.rand.nextInt(this.followRange) - this.rand.nextInt(this.followRange), this.rand.nextInt(this.followRange) - this.rand.nextInt(this.followRange), this.rand.nextInt(this.followRange) - this.rand.nextInt(this.followRange));
            if (!world.func_180495_p(b).func_196958_f() || !world.func_180495_p(b.func_177977_b()).func_200132_m()) continue;
            return b;
        }
        return null;
    }
}

