/*
 * Decompiled with CFR 0.152.
 */
package com.matez.wildnature.common.entity.render.layer.cape;

import com.matez.wildnature.util.event.capeBuffers.IImageBuffer;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.client.renderer.texture.SimpleTexture;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CapeTexture
extends SimpleTexture {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final AtomicInteger TEXTURE_CapeTexture_THREAD_ID = new AtomicInteger(0);
    private final String imageUrl;
    @Nullable
    private final IImageBuffer imageBuffer;
    @Nullable
    private NativeImage nativeImage;
    @Nullable
    private Thread imageThread;
    private boolean textureUploaded;

    public CapeTexture(String imageUrlIn, ResourceLocation textureResourceLocation, IImageBuffer imageBufferIn) {
        super(textureResourceLocation);
        this.imageUrl = imageUrlIn;
        this.imageBuffer = imageBufferIn;
    }

    private void checkTextureUploaded() {
        if (!this.textureUploaded && this.nativeImage != null) {
            if (this.field_110568_b != null) {
                this.func_147631_c();
            }
            TextureUtil.func_225680_a_((int)super.func_110552_b(), (int)this.nativeImage.func_195702_a(), (int)this.nativeImage.func_195714_b());
            this.nativeImage.func_195697_a(0, 0, 0, false);
            this.textureUploaded = true;
        }
    }

    public int func_110552_b() {
        this.checkTextureUploaded();
        return super.func_110552_b();
    }

    public void setNativeImage(NativeImage nativeImageIn) {
        this.nativeImage = nativeImageIn;
        if (this.imageBuffer != null) {
            this.imageBuffer.skinAvailable();
        }
    }

    public void func_195413_a(IResourceManager resourceManager) throws IOException {
        if (this.nativeImage == null && this.field_110568_b != null) {
            super.func_195413_a(resourceManager);
        }
        if (this.imageThread == null) {
            this.loadTextureFromServer();
        }
    }

    protected void loadTextureFromServer() {
        if (this.imageUrl != null) {
            this.imageThread = new Thread("CapeTexture #" + TEXTURE_CapeTexture_THREAD_ID.incrementAndGet()){

                @Override
                public void run() {
                    URLConnection httpurlconnection = null;
                    LOGGER.debug("Downloading texture from {}", (Object)CapeTexture.this.imageUrl);
                    try {
                        httpurlconnection = (HttpURLConnection)new URL(CapeTexture.this.imageUrl).openConnection(Minecraft.func_71410_x().func_110437_J());
                        httpurlconnection.setDoInput(true);
                        httpurlconnection.setDoOutput(false);
                        httpurlconnection.connect();
                        if (((HttpURLConnection)httpurlconnection).getResponseCode() / 100 == 2) {
                            NativeImage nativeImage = NativeImage.func_195713_a((InputStream)httpurlconnection.getInputStream());
                            nativeImage = CapeTexture.this.imageBuffer.parseUserSkin(nativeImage);
                            CapeTexture.this.setNativeImage(nativeImage);
                            LOGGER.debug("Image loaded in {}", (Object)nativeImage);
                            return;
                        }
                        return;
                    }
                    catch (Exception var6) {
                        LOGGER.error("Couldn't download texture", (Throwable)var6);
                    }
                    finally {
                        if (httpurlconnection != null) {
                            LOGGER.debug("Disconnected from {}", (Object)httpurlconnection.getURL().toString());
                            ((HttpURLConnection)httpurlconnection).disconnect();
                        }
                    }
                }
            };
            this.imageThread.setDaemon(true);
            this.imageThread.start();
        }
    }
}

