/*
 * Decompiled with CFR 0.152.
 */
package com.matez.wildnature.common.items.blowpipe;

import com.matez.wildnature.common.entity.type.misc.blowpipe.darts.RowanBlowdartEntity;
import com.matez.wildnature.common.items.blowpipe.BlowpipeAmmo;
import com.matez.wildnature.init.WN;
import com.matez.wildnature.util.other.Pair;
import com.matez.wildnature.util.other.Utilities;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.Stats;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;

public class BlowpipeItem
extends Item {
    public BlowpipeItem(Item.Properties properties) {
        super(properties);
        this.func_185043_a(new ResourceLocation("loaded"), (stack, world, entity) -> entity != null && entity.func_184587_cr() && entity.func_184607_cu() == stack ? 1.0f : 0.0f);
    }

    public boolean func_219970_i(ItemStack stack) {
        return stack.func_77973_b() instanceof BlowpipeItem;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        ItemStack itemstack = playerIn.func_184586_b(handIn);
        itemstack.func_196082_o().func_74772_a("lastShot", -1L);
        Pair<BlowpipeAmmo, ItemStack> ammoPair = this.getAmmo((LivingEntity)playerIn);
        if (ammoPair == null) {
            return ActionResult.func_226251_d_((Object)itemstack);
        }
        ItemStack ammo = ammoPair.getValue();
        if (ammo.func_190916_E() <= 0) {
            return ActionResult.func_226251_d_((Object)itemstack);
        }
        ItemStack oldItemStack = Utilities.loadItem(itemstack.func_196082_o());
        if (oldItemStack.func_190926_b() || oldItemStack.func_77973_b() != ammo.func_77973_b()) {
            playerIn.func_146105_b((ITextComponent)new StringTextComponent(TextFormatting.GRAY + "Loaded " + TextFormatting.RED + ammo.func_200301_q().func_150254_d()), true);
        }
        Utilities.saveItem(itemstack.func_196082_o(), ammo);
        playerIn.func_184598_c(handIn);
        return ActionResult.func_226249_b_((Object)itemstack);
    }

    public void shoot(ItemStack stack, World worldIn, LivingEntity entityLiving) {
        int count;
        Pair<BlowpipeAmmo, ItemStack> ammoPair = this.getAmmo(entityLiving);
        if (ammoPair == null) {
            return;
        }
        ItemStack ammo = ammoPair.getValue();
        if (ammo.func_190916_E() <= 0) {
            return;
        }
        BlowpipeAmmo blowpipeAmmo = ammoPair.getKey();
        if (blowpipeAmmo == null) {
            return;
        }
        if (entityLiving instanceof PlayerEntity && ((PlayerEntity)entityLiving).func_184811_cZ().func_185143_a((Item)this, 0.0f) > 0.0f) {
            return;
        }
        boolean shot = false;
        if (!ammo.func_190926_b() && (count = Math.min(ammo.func_190916_E(), Utilities.rint(blowpipeAmmo.getMinCount(), blowpipeAmmo.getMaxCount()))) > 0) {
            if (!(entityLiving.func_184607_cu().func_77973_b() instanceof BlowpipeItem)) {
                return;
            }
            int charge = 0;
            charge = stack.func_196082_o().func_74764_b("lastShot") && stack.func_196082_o().func_74763_f("lastShot") != -1L ? (int)((double)(System.currentTimeMillis() - stack.func_196082_o().func_74763_f("lastShot")) / 1000.0 * 20.0) : this.func_77626_a(stack) - entityLiving.func_184605_cv();
            if (entityLiving instanceof PlayerEntity && (charge = ForgeEventFactory.onArrowLoose((ItemStack)stack, (World)worldIn, (PlayerEntity)((PlayerEntity)entityLiving), (int)charge, (!ammo.func_190926_b() || ((PlayerEntity)entityLiving).field_71075_bZ.field_75098_d || EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185312_x, (ItemStack)stack) > 0 ? 1 : 0) != 0)) < 0) {
                return;
            }
            for (int i = 0; i < count; ++i) {
                float velocity = BlowpipeItem.getDartVelocity(charge);
                if ((double)velocity < 0.1) continue;
                if (!worldIn.field_72995_K) {
                    int k;
                    int j;
                    RowanBlowdartEntity blowdartEntity = null;
                    if (blowpipeAmmo.getDartType() != BlowpipeAmmo.DartType.ROWAN) {
                        return;
                    }
                    blowdartEntity = new RowanBlowdartEntity(entityLiving, worldIn);
                    blowdartEntity.setDamage(Utilities.rint(0, blowpipeAmmo.getMaxDamageChance()) == 0 ? Utilities.rdoub(blowpipeAmmo.getDamage(), blowpipeAmmo.getMaxDamage()) : (double)blowpipeAmmo.getDamage());
                    blowdartEntity.setKnockbackStrength(Utilities.rint(0, blowpipeAmmo.getMaxKnockbackChance()) == 0 ? Utilities.rint(blowpipeAmmo.getKnockback(), blowpipeAmmo.getMaxKnockback()) : blowpipeAmmo.getKnockback());
                    blowdartEntity.setItem(blowpipeAmmo.getAmmo());
                    WN.LOGGER.debug("Set item to " + blowdartEntity.getItem().getRegistryName());
                    blowdartEntity.shoot((Entity)entityLiving, entityLiving.field_70125_A, entityLiving.field_70177_z, 0.0f, velocity * 6.0f - 0.5f * (float)i, 0.25f * (float)(i + 1));
                    if (velocity >= 1.0f) {
                        blowdartEntity.setIsCritical(true);
                    }
                    if ((j = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185309_u, (ItemStack)stack)) > 0) {
                        blowdartEntity.setDamage(blowdartEntity.getDamage() + (double)blowpipeAmmo.getMaxDamageChance() == 0.0 ? Utilities.rdoub(blowpipeAmmo.getDamage(), (double)j * 0.25 + 0.25) : 0.0);
                    }
                    if ((k = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185310_v, (ItemStack)stack)) > 0) {
                        blowdartEntity.setKnockbackStrength(blowdartEntity.getKnockbackStrength() + k);
                    }
                    if (EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185311_w, (ItemStack)stack) > 0) {
                        blowdartEntity.func_70015_d(3);
                    }
                    stack.func_222118_a(1, entityLiving, p_220009_1_ -> p_220009_1_.func_213334_d(entityLiving.func_184600_cs()));
                    worldIn.func_217376_c((Entity)blowdartEntity);
                    shot = true;
                }
                worldIn.func_184148_a(null, entityLiving.func_226277_ct_(), entityLiving.func_226278_cu_(), entityLiving.func_226281_cx_(), SoundEvents.field_187737_v, SoundCategory.PLAYERS, 1.0f, 1.0f / (field_77697_d.nextFloat() * 0.4f + 1.2f) + velocity * 0.5f);
                if (!(entityLiving instanceof PlayerEntity)) continue;
                PlayerEntity playerIn = (PlayerEntity)entityLiving;
                playerIn.func_71029_a(Stats.field_75929_E.func_199076_b((Object)this));
                if (playerIn.field_71075_bZ.field_75098_d) continue;
                ammo.func_190918_g(1);
            }
            if (shot) {
                if (entityLiving instanceof PlayerEntity) {
                    ((PlayerEntity)entityLiving).func_184811_cZ().func_185145_a((Item)this, blowpipeAmmo.getCooldown());
                }
                stack.func_196082_o().func_74772_a("lastShot", System.currentTimeMillis());
            }
        }
    }

    public int func_77626_a(ItemStack stack) {
        return 72000;
    }

    public Pair<BlowpipeAmmo, ItemStack> getAmmo(LivingEntity entity) {
        if (entity instanceof PlayerEntity) {
            Map.Entry<String, BlowpipeAmmo> stringBlowpipeAmmoEntry2;
            PlayerEntity playerEntity = (PlayerEntity)entity;
            ItemStack mainHandStack = playerEntity.func_184614_ca();
            ItemStack offHandStack = playerEntity.func_184592_cb();
            for (Map.Entry<String, BlowpipeAmmo> stringBlowpipeAmmoEntry2 : BlowpipeAmmo.AMMO.entrySet()) {
                BlowpipeAmmo ammo = stringBlowpipeAmmoEntry2.getValue();
                if (mainHandStack.func_77973_b() == ammo.getAmmo() && ammo.getMinCount() <= mainHandStack.func_190916_E()) {
                    return new Pair<BlowpipeAmmo, ItemStack>(ammo, mainHandStack);
                }
                if (offHandStack.func_77973_b() != ammo.getAmmo() || ammo.getMinCount() > offHandStack.func_190916_E()) continue;
                return new Pair<BlowpipeAmmo, ItemStack>(ammo, offHandStack);
            }
            Iterator<Map.Entry<String, BlowpipeAmmo>> iterator = BlowpipeAmmo.AMMO.entrySet().iterator();
            while (iterator.hasNext()) {
                stringBlowpipeAmmoEntry2 = iterator.next();
                for (int i = 0; i < playerEntity.field_71071_by.func_70302_i_(); ++i) {
                    ItemStack stack = playerEntity.field_71071_by.func_70301_a(i);
                    if (stringBlowpipeAmmoEntry2.getValue().getAmmo() != stack.func_77973_b() || stringBlowpipeAmmoEntry2.getValue().getMinCount() > stack.func_190916_E()) continue;
                    return new Pair<BlowpipeAmmo, ItemStack>(stringBlowpipeAmmoEntry2.getValue(), stack);
                }
            }
            if (playerEntity.func_184812_l_() && (iterator = BlowpipeAmmo.AMMO.entrySet().iterator()).hasNext()) {
                stringBlowpipeAmmoEntry2 = iterator.next();
                return new Pair<BlowpipeAmmo, ItemStack>(stringBlowpipeAmmoEntry2.getValue(), new ItemStack((IItemProvider)stringBlowpipeAmmoEntry2.getValue().getAmmo(), 64));
            }
        } else {
            Iterator<Map.Entry<String, BlowpipeAmmo>> iterator = BlowpipeAmmo.AMMO.entrySet().iterator();
            if (iterator.hasNext()) {
                Map.Entry<String, BlowpipeAmmo> stringBlowpipeAmmoEntry = iterator.next();
                return new Pair<BlowpipeAmmo, ItemStack>(stringBlowpipeAmmoEntry.getValue(), new ItemStack((IItemProvider)stringBlowpipeAmmoEntry.getValue().getAmmo(), 64));
            }
        }
        return null;
    }

    public static float getDartVelocity(int charge) {
        float f = (float)charge / 20.0f;
        if ((f = (f * f + f * 2.0f) / 3.0f) > 1.0f) {
            f = 1.0f;
        }
        return f;
    }
}

