/*
 * Decompiled with CFR 0.152.
 */
package com.matez.wildnature.common.items.weapons;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.client.renderer.Quaternion;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ICrossbowUser;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.FireworkRocketEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.item.ArrowItem;
import net.minecraft.item.CrossbowItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.UseAction;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.stats.Stats;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class SilverCrossbowItem
extends CrossbowItem {
    private boolean isLoadingStart = false;
    private boolean isLoadingMiddle = false;

    public SilverCrossbowItem(Item.Properties propertiesIn) {
        super(propertiesIn);
        this.func_185043_a(new ResourceLocation("pull"), (p_220022_1_, p_220022_2_, p_220022_3_) -> {
            if (p_220022_3_ != null && p_220022_1_.func_77973_b() == this) {
                return SilverCrossbowItem.isCharged(p_220022_1_) ? 0.0f : (float)(p_220022_1_.func_77988_m() - p_220022_3_.func_184605_cv()) / (float)SilverCrossbowItem.getChargeTime(p_220022_1_);
            }
            return 0.0f;
        });
        this.func_185043_a(new ResourceLocation("pulling"), (p_220033_0_, p_220033_1_, p_220033_2_) -> p_220033_2_ != null && p_220033_2_.func_184587_cr() && p_220033_2_.func_184607_cu() == p_220033_0_ && !SilverCrossbowItem.isCharged(p_220033_0_) ? 1.0f : 0.0f);
        this.func_185043_a(new ResourceLocation("charged"), (p_220030_0_, p_220030_1_, p_220030_2_) -> p_220030_2_ != null && SilverCrossbowItem.isCharged(p_220030_0_) ? 1.0f : 0.0f);
        this.func_185043_a(new ResourceLocation("firework"), (p_220020_0_, p_220020_1_, p_220020_2_) -> p_220020_2_ != null && SilverCrossbowItem.isCharged(p_220020_0_) && SilverCrossbowItem.hasChargedProjectile(p_220020_0_, Items.field_196152_dE) ? 1.0f : 0.0f);
    }

    public boolean func_219970_i(ItemStack stack) {
        return stack.func_77973_b() instanceof CrossbowItem;
    }

    public Predicate<ItemStack> func_220006_d() {
        return field_220008_b;
    }

    public Predicate<ItemStack> func_220004_b() {
        return field_220007_a;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        ItemStack itemstack = playerIn.func_184586_b(handIn);
        if (SilverCrossbowItem.isCharged(itemstack)) {
            SilverCrossbowItem.fireProjectiles(worldIn, (LivingEntity)playerIn, handIn, itemstack, SilverCrossbowItem.func_220013_l(itemstack), 1.0f);
            SilverCrossbowItem.setCharged(itemstack, false);
            return ActionResult.func_226249_b_((Object)itemstack);
        }
        if (!playerIn.func_213356_f(itemstack).func_190926_b()) {
            if (!SilverCrossbowItem.isCharged(itemstack)) {
                this.isLoadingStart = false;
                this.isLoadingMiddle = false;
                playerIn.func_184598_c(handIn);
            }
            return ActionResult.func_226249_b_((Object)itemstack);
        }
        return ActionResult.func_226251_d_((Object)itemstack);
    }

    public void func_77615_a(ItemStack stack, World worldIn, LivingEntity entityLiving, int timeLeft) {
        int i = this.func_77626_a(stack) - timeLeft;
        float f = SilverCrossbowItem.getCharge(i, stack);
        if (f >= 1.0f && !SilverCrossbowItem.isCharged(stack) && SilverCrossbowItem.hasAmmo(entityLiving, stack)) {
            SilverCrossbowItem.setCharged(stack, true);
            SoundCategory soundcategory = entityLiving instanceof PlayerEntity ? SoundCategory.PLAYERS : SoundCategory.HOSTILE;
            worldIn.func_184148_a((PlayerEntity)null, entityLiving.func_226277_ct_(), entityLiving.func_226278_cu_(), entityLiving.func_226281_cx_(), SoundEvents.field_219610_bB, soundcategory, 1.0f, 1.0f / (field_77697_d.nextFloat() * 0.5f + 1.0f) + 0.2f);
        }
    }

    private static boolean hasAmmo(LivingEntity entityIn, ItemStack stack) {
        int i = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_222192_G, (ItemStack)stack);
        int j = i == 0 ? 1 : 3;
        boolean flag = entityIn instanceof PlayerEntity && ((PlayerEntity)entityIn).field_71075_bZ.field_75098_d;
        ItemStack itemstack = entityIn.func_213356_f(stack);
        ItemStack itemstack1 = itemstack.func_77946_l();
        for (int k = 0; k < j; ++k) {
            if (k > 0) {
                itemstack = itemstack1.func_77946_l();
            }
            if (itemstack.func_190926_b() && flag) {
                itemstack = new ItemStack((IItemProvider)Items.field_151032_g);
                itemstack1 = itemstack.func_77946_l();
            }
            if (SilverCrossbowItem.func_220023_a(entityIn, stack, itemstack, k > 0, flag)) continue;
            return false;
        }
        return true;
    }

    private static boolean func_220023_a(LivingEntity p_220023_0_, ItemStack p_220023_1_, ItemStack p_220023_2_, boolean p_220023_3_, boolean p_220023_4_) {
        ItemStack itemstack;
        boolean flag;
        if (p_220023_2_.func_190926_b()) {
            return false;
        }
        boolean bl = flag = p_220023_4_ && p_220023_2_.func_77973_b() instanceof ArrowItem;
        if (!(flag || p_220023_4_ || p_220023_3_)) {
            itemstack = p_220023_2_.func_77979_a(1);
            if (p_220023_2_.func_190926_b() && p_220023_0_ instanceof PlayerEntity) {
                ((PlayerEntity)p_220023_0_).field_71071_by.func_184437_d(p_220023_2_);
            }
        } else {
            itemstack = p_220023_2_.func_77946_l();
        }
        SilverCrossbowItem.addChargedProjectile(p_220023_1_, itemstack);
        return true;
    }

    public static boolean isCharged(ItemStack stack) {
        CompoundNBT compoundnbt = stack.func_77978_p();
        return compoundnbt != null && compoundnbt.func_74767_n("Charged");
    }

    public static void setCharged(ItemStack stack, boolean chargedIn) {
        CompoundNBT compoundnbt = stack.func_196082_o();
        compoundnbt.func_74757_a("Charged", chargedIn);
    }

    private static void addChargedProjectile(ItemStack crossbow, ItemStack projectile) {
        CompoundNBT compoundnbt = crossbow.func_196082_o();
        ListNBT listnbt = compoundnbt.func_150297_b("ChargedProjectiles", 9) ? compoundnbt.func_150295_c("ChargedProjectiles", 10) : new ListNBT();
        CompoundNBT compoundnbt1 = new CompoundNBT();
        projectile.func_77955_b(compoundnbt1);
        listnbt.add((Object)compoundnbt1);
        compoundnbt.func_218657_a("ChargedProjectiles", (INBT)listnbt);
    }

    private static List<ItemStack> getChargedProjectiles(ItemStack stack) {
        ListNBT listnbt;
        ArrayList list = Lists.newArrayList();
        CompoundNBT compoundnbt = stack.func_77978_p();
        if (compoundnbt != null && compoundnbt.func_150297_b("ChargedProjectiles", 9) && (listnbt = compoundnbt.func_150295_c("ChargedProjectiles", 10)) != null) {
            for (int i = 0; i < listnbt.size(); ++i) {
                CompoundNBT compoundnbt1 = listnbt.func_150305_b(i);
                list.add(ItemStack.func_199557_a((CompoundNBT)compoundnbt1));
            }
        }
        return list;
    }

    private static void clearProjectiles(ItemStack stack) {
        CompoundNBT compoundnbt = stack.func_77978_p();
        if (compoundnbt != null) {
            ListNBT listnbt = compoundnbt.func_150295_c("ChargedProjectiles", 9);
            listnbt.clear();
            compoundnbt.func_218657_a("ChargedProjectiles", (INBT)listnbt);
        }
    }

    private static boolean hasChargedProjectile(ItemStack stack, Item ammoItem) {
        return SilverCrossbowItem.getChargedProjectiles(stack).stream().anyMatch(p_220010_1_ -> p_220010_1_.func_77973_b() == ammoItem);
    }

    private static void fireProjectile(World worldIn, LivingEntity shooter, Hand handIn, ItemStack crossbow, ItemStack projectile, float soundPitch, boolean isCreativeMode, float velocity, float inaccuracy, float projectileAngle) {
        if (!worldIn.field_72995_K) {
            AbstractArrowEntity iprojectile;
            boolean flag;
            boolean bl = flag = projectile.func_77973_b() == Items.field_196152_dE;
            if (flag) {
                iprojectile = new FireworkRocketEntity(worldIn, projectile, shooter.func_226277_ct_(), shooter.func_226280_cw_() - (double)0.15f, shooter.func_226281_cx_(), true);
            } else {
                iprojectile = SilverCrossbowItem.createArrow(worldIn, shooter, crossbow, projectile);
                if (isCreativeMode || projectileAngle != 0.0f) {
                    iprojectile.field_70251_a = AbstractArrowEntity.PickupStatus.CREATIVE_ONLY;
                }
            }
            if (shooter instanceof ICrossbowUser) {
                ICrossbowUser icrossbowuser = (ICrossbowUser)shooter;
                icrossbowuser.func_213670_a(icrossbowuser.func_70638_az(), crossbow, (IProjectile)iprojectile, projectileAngle);
            } else {
                Vec3d vec3d1 = shooter.func_213286_i(1.0f);
                Quaternion quaternion = new Quaternion(new Vector3f(vec3d1), projectileAngle, true);
                Vec3d vec3d = shooter.func_70676_i(1.0f);
                Vector3f vector3f = new Vector3f(vec3d);
                vector3f.func_214905_a(quaternion);
                iprojectile.func_70186_c((double)vector3f.func_195899_a(), (double)vector3f.func_195900_b(), (double)vector3f.func_195902_c(), velocity, inaccuracy);
            }
            crossbow.func_222118_a(flag ? 3 : 1, shooter, p_220017_1_ -> p_220017_1_.func_213334_d(handIn));
            worldIn.func_217376_c((Entity)iprojectile);
            worldIn.func_184148_a((PlayerEntity)null, shooter.func_226277_ct_(), shooter.func_226278_cu_(), shooter.func_226281_cx_(), SoundEvents.field_219616_bH, SoundCategory.PLAYERS, 1.0f, soundPitch);
        }
    }

    private static AbstractArrowEntity createArrow(World worldIn, LivingEntity shooter, ItemStack crossbow, ItemStack ammo) {
        ArrowItem arrowitem = (ArrowItem)(ammo.func_77973_b() instanceof ArrowItem ? ammo.func_77973_b() : Items.field_151032_g);
        AbstractArrowEntity abstractarrowentity = arrowitem.func_200887_a(worldIn, ammo, shooter);
        if (shooter instanceof PlayerEntity) {
            abstractarrowentity.func_70243_d(true);
        }
        abstractarrowentity.func_70240_a(0);
        abstractarrowentity.func_70239_b(3.5);
        abstractarrowentity.func_213869_a(SoundEvents.field_219609_bA);
        abstractarrowentity.func_213865_o(true);
        int i = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_222194_I, (ItemStack)crossbow);
        if (++i > 0) {
            abstractarrowentity.func_213872_b((byte)i);
        }
        return abstractarrowentity;
    }

    public static void fireProjectiles(World worldIn, LivingEntity shooter, Hand handIn, ItemStack stack, float velocityIn, float inaccuracyIn) {
        List<ItemStack> list = SilverCrossbowItem.getChargedProjectiles(stack);
        float[] afloat = SilverCrossbowItem.getRandomSoundPitches(shooter.func_70681_au());
        for (int i = 0; i < list.size(); ++i) {
            boolean flag;
            ItemStack itemstack = list.get(i);
            boolean bl = flag = shooter instanceof PlayerEntity && ((PlayerEntity)shooter).field_71075_bZ.field_75098_d;
            if (itemstack.func_190926_b()) continue;
            if (i == 0) {
                SilverCrossbowItem.fireProjectile(worldIn, shooter, handIn, stack, itemstack, afloat[i], flag, velocityIn, inaccuracyIn, 0.0f);
                continue;
            }
            if (i == 1) {
                SilverCrossbowItem.fireProjectile(worldIn, shooter, handIn, stack, itemstack, afloat[i], flag, velocityIn, inaccuracyIn, -10.0f);
                continue;
            }
            if (i != 2) continue;
            SilverCrossbowItem.fireProjectile(worldIn, shooter, handIn, stack, itemstack, afloat[i], flag, velocityIn, inaccuracyIn, 10.0f);
        }
        SilverCrossbowItem.fireProjectilesAfter(worldIn, shooter, stack);
    }

    private static float[] getRandomSoundPitches(Random rand) {
        boolean flag = rand.nextBoolean();
        return new float[]{1.0f, SilverCrossbowItem.getRandomSoundPitch(flag), SilverCrossbowItem.getRandomSoundPitch(!flag)};
    }

    private static float getRandomSoundPitch(boolean flagIn) {
        float f = flagIn ? 0.63f : 0.43f;
        return 1.0f / (field_77697_d.nextFloat() * 0.5f + 1.8f) + f;
    }

    private static void fireProjectilesAfter(World worldIn, LivingEntity shooter, ItemStack stack) {
        if (shooter instanceof ServerPlayerEntity) {
            ServerPlayerEntity serverplayerentity = (ServerPlayerEntity)shooter;
            if (!worldIn.field_72995_K) {
                CriteriaTriggers.field_215099_F.func_215111_a(serverplayerentity, stack);
            }
            serverplayerentity.func_71029_a(Stats.field_75929_E.func_199076_b((Object)stack.func_77973_b()));
        }
        SilverCrossbowItem.clearProjectiles(stack);
    }

    public void func_219972_a(World worldIn, LivingEntity livingEntityIn, ItemStack stack, int count) {
        if (!worldIn.field_72995_K) {
            int i = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_222193_H, (ItemStack)stack);
            SoundEvent soundevent = this.getSoundEvent(i);
            SoundEvent soundevent1 = i == 0 ? SoundEvents.field_219611_bC : null;
            float f = (float)(stack.func_77988_m() - count) / (float)SilverCrossbowItem.getChargeTime(stack);
            if (f < 0.2f) {
                this.isLoadingStart = false;
                this.isLoadingMiddle = false;
            }
            if (f >= 0.2f && !this.isLoadingStart) {
                this.isLoadingStart = true;
                worldIn.func_184148_a((PlayerEntity)null, livingEntityIn.func_226277_ct_(), livingEntityIn.func_226278_cu_(), livingEntityIn.func_226281_cx_(), soundevent, SoundCategory.PLAYERS, 0.5f, 1.0f);
            }
            if (f >= 0.5f && soundevent1 != null && !this.isLoadingMiddle) {
                this.isLoadingMiddle = true;
                worldIn.func_184148_a((PlayerEntity)null, livingEntityIn.func_226277_ct_(), livingEntityIn.func_226278_cu_(), livingEntityIn.func_226281_cx_(), soundevent1, SoundCategory.PLAYERS, 0.5f, 1.0f);
            }
        }
    }

    public int func_77626_a(ItemStack stack) {
        return SilverCrossbowItem.getChargeTime(stack) + 3;
    }

    public static int getChargeTime(ItemStack stack) {
        int i = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_222193_H, (ItemStack)stack);
        return i == 0 ? 16 : 16 - 5 * i;
    }

    public UseAction func_77661_b(ItemStack stack) {
        return UseAction.CROSSBOW;
    }

    private SoundEvent getSoundEvent(int enchantmentLevel) {
        switch (enchantmentLevel) {
            case 1: {
                return SoundEvents.field_219613_bE;
            }
            case 2: {
                return SoundEvents.field_219614_bF;
            }
            case 3: {
                return SoundEvents.field_219615_bG;
            }
        }
        return SoundEvents.field_219612_bD;
    }

    private static float getCharge(int useTime, ItemStack stack) {
        float f = (float)useTime / (float)SilverCrossbowItem.getChargeTime(stack);
        if (f > 1.0f) {
            f = 1.0f;
        }
        return f;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        List<ItemStack> list = SilverCrossbowItem.getChargedProjectiles(stack);
        if (SilverCrossbowItem.isCharged(stack) && !list.isEmpty()) {
            ItemStack itemstack = list.get(0);
            tooltip.add(new TranslationTextComponent("item.minecraft.crossbow.projectile", new Object[0]).func_150258_a(" ").func_150257_a(itemstack.func_151000_E()));
            if (flagIn.func_194127_a() && itemstack.func_77973_b() == Items.field_196152_dE) {
                ArrayList list1 = Lists.newArrayList();
                Items.field_196152_dE.func_77624_a(itemstack, worldIn, (List)list1, flagIn);
                if (!list1.isEmpty()) {
                    for (int i = 0; i < list1.size(); ++i) {
                        list1.set(i, new StringTextComponent("  ").func_150257_a((ITextComponent)list1.get(i)).func_211708_a(TextFormatting.GRAY));
                    }
                    tooltip.addAll(list1);
                }
            }
        }
    }

    private static float func_220013_l(ItemStack p_220013_0_) {
        return p_220013_0_.func_77973_b() instanceof CrossbowItem && SilverCrossbowItem.hasChargedProjectile(p_220013_0_, Items.field_196152_dE) ? 1.9f : 4.5f;
    }
}

