/*
 * Decompiled with CFR 0.152.
 */
package com.matez.wildnature.common.tileentity.present;

import com.matez.wildnature.client.gui.initGuis;
import com.matez.wildnature.util.other.Utilities;
import java.util.ArrayList;
import java.util.Collections;
import net.minecraft.block.Block;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class PresentTileEntity
extends TileEntity {
    public static ArrayList<Block> SUPPORTED_BLOCKS = new ArrayList();
    private ItemStack gift;

    public PresentTileEntity() {
        super(initGuis.PRESENT_TILE_ENTITY);
    }

    public void setGift(ItemStack gift) {
        this.gift = gift;
        this.func_70296_d();
    }

    public ItemStack getGift() {
        return this.gift;
    }

    public void dropGift(World world, BlockPos pos) {
        if (this.hasGift()) {
            Block.func_180635_a((World)world, (BlockPos)pos, (ItemStack)this.gift);
            this.gift = ItemStack.field_190927_a;
            this.func_70296_d();
        }
    }

    public boolean putGiftToHand(PlayerEntity entity, Hand hand) {
        if (this.hasGift() && entity.func_184586_b(hand).func_190926_b()) {
            entity.func_184611_a(hand, this.gift);
            this.gift = ItemStack.field_190927_a;
            this.func_70296_d();
        }
        return false;
    }

    public boolean hasGift() {
        return this.gift != null && !this.gift.func_190926_b();
    }

    public void func_145839_a(CompoundNBT compound) {
        super.func_145839_a(compound);
        this.gift = Utilities.loadItems(compound).get(0);
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        if (this.gift != null) {
            Utilities.saveItems(compound, new ArrayList<ItemStack>(Collections.singletonList(this.gift)));
        } else {
            Utilities.saveItems(compound, new ArrayList<ItemStack>(Collections.singletonList(ItemStack.field_190927_a)));
        }
        return compound;
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT nbtTagCompound = new CompoundNBT();
        this.func_189515_b(nbtTagCompound);
        return nbtTagCompound;
    }

    public void handleUpdateTag(CompoundNBT tag) {
        this.func_145839_a(tag);
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        int tileEntityType = initGuis.tileEntityType + 1;
        return new SUpdateTileEntityPacket(this.field_174879_c, tileEntityType, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.handleUpdateTag(pkt.func_148857_g());
    }
}

