/*
 * Decompiled with CFR 0.152.
 */
package com.matez.wildnature.network.packet.packets;

import com.matez.wildnature.common.items.blowpipe.BlowpipeItem;
import com.matez.wildnature.network.packet.WNPackets;
import com.matez.wildnature.util.other.Utilities;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkEvent;

public class WNBlowpipeShootPacket {
    private UUID uuid;

    public static void sendToServer(UUID uuid) {
        WNPackets.INSTANCE.sendToServer((Object)new WNBlowpipeShootPacket(uuid));
    }

    public WNBlowpipeShootPacket(UUID uuid) {
        this.uuid = uuid;
    }

    public static WNBlowpipeShootPacket parse(PacketBuffer buf) {
        return new WNBlowpipeShootPacket(buf.func_179253_g());
    }

    public static void compose(WNBlowpipeShootPacket packet, PacketBuffer buf) {
        buf.func_179252_a(packet.uuid);
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public static class Handler {
        public static void handle(final WNBlowpipeShootPacket pkt, final Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(new Runnable(){

                @Override
                public void run() {
                    ServerPlayerEntity entity = ((NetworkEvent.Context)ctx.get()).getSender();
                    if (entity != null) {
                        MinecraftServer server = entity.func_184102_h();
                        PlayerEntity player = Utilities.getPlayerByUUID(pkt.uuid, server);
                        if (player != null && !player.func_184607_cu().func_190926_b() && player.func_184607_cu().func_77973_b() instanceof BlowpipeItem) {
                            ((BlowpipeItem)player.func_184607_cu().func_77973_b()).shoot(player.func_184607_cu(), (World)entity.func_71121_q(), (LivingEntity)player);
                        }
                    }
                }
            });
            ctx.get().setPacketHandled(true);
        }
    }
}

