/*
 * Decompiled with CFR 0.152.
 */
package com.matez.wildnature.network.packet.packets;

import com.matez.wildnature.init.WN;
import com.matez.wildnature.network.packet.WNPackets;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.registry.Registry;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.PacketDistributor;

public class WNParticlePacket {
    private float xCoord;
    private float yCoord;
    private float zCoord;
    private float xSpeed;
    private float ySpeed;
    private float zSpeed;
    private int particleCount;
    private boolean longDistance;
    private IParticleData particle;

    public static void sendToClient(ServerPlayerEntity entity, WNParticlePacket packet) {
        WNPackets.INSTANCE.send(PacketDistributor.PLAYER.with(() -> entity), (Object)packet);
    }

    public <T extends IParticleData> WNParticlePacket(T particleData, boolean longDistance, float xCoord, float yCoord, float zCoord, float xSpeed, float ySpeed, float zSpeed, int particleCount) {
        this.particle = particleData;
        this.longDistance = longDistance;
        this.xCoord = xCoord;
        this.yCoord = yCoord;
        this.zCoord = zCoord;
        this.xSpeed = xSpeed;
        this.ySpeed = ySpeed;
        this.zSpeed = zSpeed;
        this.particleCount = particleCount;
    }

    public static WNParticlePacket parse(PacketBuffer buf) {
        ParticleType particletype = (ParticleType)Registry.field_212632_u.func_148745_a(buf.readInt());
        if (particletype == null) {
            particletype = ParticleTypes.field_197610_c;
        }
        return new WNParticlePacket(WNParticlePacket.readParticle(buf, particletype), buf.readBoolean(), buf.readFloat(), buf.readFloat(), buf.readFloat(), buf.readFloat(), buf.readFloat(), buf.readFloat(), buf.readInt());
    }

    private static <T extends IParticleData> T readParticle(PacketBuffer p_199855_1_, ParticleType<T> p_199855_2_) {
        return (T)p_199855_2_.func_197571_g().func_197543_b(p_199855_2_, p_199855_1_);
    }

    public static void compose(WNParticlePacket packet, PacketBuffer buf) {
        buf.writeInt(Registry.field_212632_u.func_148757_b((Object)packet.particle.func_197554_b()));
        buf.writeBoolean(packet.longDistance);
        buf.writeFloat(packet.xCoord);
        buf.writeFloat(packet.yCoord);
        buf.writeFloat(packet.zCoord);
        buf.writeFloat(packet.xSpeed);
        buf.writeFloat(packet.ySpeed);
        buf.writeFloat(packet.zSpeed);
        buf.writeInt(packet.particleCount);
        packet.particle.func_197553_a(buf);
    }

    public static class Handler {
        public static void handle(final WNParticlePacket packet, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(new Runnable(){

                @Override
                public void run() {
                    ClientWorld world = Minecraft.func_71410_x().field_71441_e;
                    if (world == null) {
                        return;
                    }
                    if (packet.particleCount == 0) {
                        try {
                            world.func_195590_a(packet.particle, packet.longDistance, (double)packet.xCoord, (double)packet.yCoord, (double)packet.zCoord, (double)packet.xSpeed, (double)packet.ySpeed, (double)packet.zSpeed);
                        }
                        catch (Throwable var17) {
                            WN.LOGGER.warn("Could not spawn particle effect {}", (Object)packet.particle);
                        }
                    } else {
                        for (int i = 0; i < packet.particleCount; ++i) {
                            try {
                                world.func_195590_a(packet.particle, packet.longDistance, (double)packet.xCoord, (double)packet.yCoord, (double)packet.zCoord, (double)packet.xSpeed, (double)packet.ySpeed, (double)packet.zSpeed);
                                continue;
                            }
                            catch (Throwable var17) {
                                WN.LOGGER.warn("Could not spawn particle effect {}", (Object)packet.particle);
                            }
                        }
                    }
                }
            });
            ctx.get().setPacketHandled(true);
        }
    }
}

