/*
 * Decompiled with CFR 0.152.
 */
package com.matez.wildnature.network.proxy;

import com.matez.wildnature.client.gui.initGuis;
import com.matez.wildnature.client.gui.screen.BackpackBigScreen;
import com.matez.wildnature.client.gui.screen.BackpackMediumScreen;
import com.matez.wildnature.client.gui.screen.BackpackSmallScreen;
import com.matez.wildnature.client.gui.screen.DungeonCommanderScreen;
import com.matez.wildnature.client.gui.screen.PouchScreen;
import com.matez.wildnature.client.music.WNMusic;
import com.matez.wildnature.client.music.WNMusicPlayer;
import com.matez.wildnature.common.entity.render.layer.blowdarts.RowanBlowdartLayer;
import com.matez.wildnature.common.entity.render.layer.cape.WNCapeLayer;
import com.matez.wildnature.common.tileentity.DungeonCommanderTileEntity;
import com.matez.wildnature.init.WN;
import com.matez.wildnature.network.proxy.IProxy;
import com.matez.wildnature.network.proxy.ServerProxy;
import com.matez.wildnature.util.config.CommonConfig;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.client.gui.screen.MainMenuScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.toasts.IToast;
import net.minecraft.client.gui.toasts.SystemToast;
import net.minecraft.client.gui.toasts.ToastGui;
import net.minecraft.client.renderer.RenderSkyboxCube;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.PlayerRenderer;
import net.minecraft.client.renderer.entity.layers.CapeLayer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.PlayerModel;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerModelPart;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;

public class ClientProxy
implements IProxy {
    public static WNMusic music;

    @Override
    public void init() {
        if (((Boolean)CommonConfig.changePanorama.get()).booleanValue()) {
            MainMenuScreen.field_213098_a = new RenderSkyboxCube(new ResourceLocation("wildnature:textures/gui/title/background/panorama"));
        }
        ScreenManager.func_216911_a(initGuis.POUCH, PouchScreen::new);
        ScreenManager.func_216911_a(initGuis.BACKPACK_SMALL, BackpackSmallScreen::new);
        ScreenManager.func_216911_a(initGuis.BACKPACK_MEDIUM, BackpackMediumScreen::new);
        ScreenManager.func_216911_a(initGuis.BACKPACK_BIG, BackpackBigScreen::new);
        WN.usesFancyGraphics = Minecraft.func_71410_x().field_71474_y.field_74347_j;
        music = new WNMusic();
        if (((Boolean)CommonConfig.playWildNatureMusic.get()).booleanValue()) {
            MinecraftForge.EVENT_BUS.addListener(WNMusicPlayer::playerTick);
        }
    }

    public void openDungeonCommander(DungeonCommanderTileEntity entity) {
        Minecraft.func_71410_x().func_147108_a((Screen)new DungeonCommanderScreen(entity));
    }

    public void toast(ITextComponent componentTitle, ITextComponent componentDescription) {
        ToastGui toastgui = Minecraft.func_71410_x().func_193033_an();
        toastgui.func_192988_a((IToast)new SystemToast(SystemToast.Type.TUTORIAL_HINT, componentTitle, componentDescription));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void enqueueIMC(InterModEnqueueEvent event) {
        WN.LOGGER.info("Registering custom layer models...");
        Minecraft.func_71410_x().field_71474_y.func_178878_a(PlayerModelPart.CAPE, true);
        for (PlayerRenderer render : Minecraft.func_71410_x().func_175598_ae().getSkinMap().values()) {
            render.func_177094_a((LayerRenderer)new WNCapeLayer((IEntityRenderer<AbstractClientPlayerEntity, PlayerModel<AbstractClientPlayerEntity>>)render));
            render.func_177094_a((LayerRenderer)new CapeLayer((IEntityRenderer)render));
            render.func_177094_a(new RowanBlowdartLayer(render));
        }
    }

    @Override
    public World getClientWorld() {
        return Minecraft.func_71410_x().field_71441_e;
    }

    @Override
    public PlayerEntity getClientPlayer() {
        return Minecraft.func_71410_x().field_71439_g;
    }

    @Override
    public ClientProxy getClient() {
        return this;
    }

    @Override
    public ServerProxy getServer() {
        return null;
    }
}

