/*
 * Decompiled with CFR 0.152.
 */
package com.matez.wildnature.util.config.world;

import com.matez.wildnature.client.gui.screen.world.WNWorldSettingsScreen;
import com.matez.wildnature.init.WN;
import java.util.Arrays;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.text.TextFormatting;

public class WorldConfig {
    private CompoundNBT nbt = new CompoundNBT();

    public void textConfig(String codename, String text) {
        if (codename.isEmpty()) {
            WN.LOGGER.warn("Missing text config codename! Value: " + text);
        }
        WNWorldSettingsScreen.log(TextFormatting.GRAY + "" + TextFormatting.ITALIC + codename + TextFormatting.RESET + TextFormatting.GRAY + " option was set to " + TextFormatting.ITALIC + (text.length() > 20 ? text.substring(0, 17) + "..." : text));
        this.nbt.func_74778_a(codename, text);
    }

    public void textConfigDefaults(String codename, String defaultText) {
        if (!this.nbt.func_74764_b(codename)) {
            this.nbt.func_74778_a(codename, defaultText);
        }
    }

    public String getTextConfig(String codename) {
        if (this.nbt.func_74764_b(codename)) {
            return this.nbt.func_74779_i(codename);
        }
        WN.LOGGER.warn("Missing text config value! Codename: " + codename);
        return "";
    }

    public void numberConfig(String codename, double number) {
        if (codename.isEmpty()) {
            WN.LOGGER.warn("Missing number config codename! Value: " + number);
        }
        WNWorldSettingsScreen.log(TextFormatting.GRAY + "" + TextFormatting.ITALIC + codename + TextFormatting.RESET + TextFormatting.GRAY + " option was set to " + TextFormatting.ITALIC + number);
        this.nbt.func_74780_a(codename, number);
    }

    public void numberConfigDefaults(String codename, double defaultNumber) {
        if (!this.nbt.func_74764_b(codename)) {
            this.nbt.func_74780_a(codename, defaultNumber);
        }
    }

    public double getNumberConfig(String codename) {
        if (this.nbt.func_74764_b(codename)) {
            return this.nbt.func_74769_h(codename);
        }
        WN.LOGGER.warn("Missing double config value! Codename: " + codename);
        return 0.0;
    }

    public void modeConfig(String codename, int mode) {
        if (codename.isEmpty()) {
            WN.LOGGER.warn("Missing mode config codename! Value: " + mode);
        }
        WNWorldSettingsScreen.log(TextFormatting.GRAY + "" + TextFormatting.ITALIC + codename + TextFormatting.RESET + TextFormatting.GRAY + " option was set to option nr. " + TextFormatting.ITALIC + mode);
        this.nbt.func_74768_a(codename, mode);
    }

    public void modeConfigDefaults(String codename, int defaultMode) {
        if (!this.nbt.func_74764_b(codename)) {
            this.nbt.func_74768_a(codename, defaultMode);
        }
    }

    public int getModeConfig(String codename) {
        if (this.nbt.func_74764_b(codename)) {
            return this.nbt.func_74762_e(codename);
        }
        WN.LOGGER.warn("Missing int config value! Codename: " + codename);
        return 0;
    }

    public void multiConfig(String codename, int[] values) {
        if (codename.isEmpty()) {
            WN.LOGGER.warn("Missing multi config codename! Value: " + Arrays.toString(values));
        }
        WNWorldSettingsScreen.log(TextFormatting.GRAY + "" + TextFormatting.ITALIC + codename + TextFormatting.RESET + TextFormatting.GRAY + " option was set to values " + TextFormatting.ITALIC + Arrays.toString(values));
        this.nbt.func_74783_a(codename, values);
    }

    public void multiConfigDefaults(String codename, int[] defaultValues) {
        if (!this.nbt.func_74764_b(codename)) {
            this.nbt.func_74783_a(codename, defaultValues);
        }
    }

    public int[] getMultiConfig(String codename) {
        if (this.nbt.func_74764_b(codename)) {
            return this.nbt.func_74759_k(codename);
        }
        WN.LOGGER.warn("Missing int config value! Codename: " + codename);
        return new int[0];
    }
}

