/*
 * Decompiled with CFR 0.152.
 */
package com.matez.wildnature.util.event;

import com.matez.wildnature.common.entity.render.layer.cape.CapeTexture;
import com.matez.wildnature.init.WN;
import com.matez.wildnature.util.config.CommonConfig;
import com.matez.wildnature.util.event.PlayerEventHandler;
import com.matez.wildnature.util.event.capeBuffers.IImageBuffer;
import com.matez.wildnature.util.other.Patron;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.client.renderer.texture.Texture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ClientPlayerEventHandler {
    public static ArrayList<String> loadedCapes = new ArrayList();

    @SubscribeEvent
    public void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        final PlayerEntity player = event.getPlayer();
        final String uuid = event.getEntity().func_110124_au().toString().replace("-", "");
        WN.LOGGER.info("Loading capes for player: " + event.getPlayer().func_145748_c_().func_150254_d());
        new Thread(new Runnable(){

            @Override
            public void run() {
                if (((Boolean)CommonConfig.renderCapes.get()).booleanValue()) {
                    ClientPlayerEventHandler.download(uuid, player);
                }
            }
        }).start();
    }

    public static void download(final String uuid, PlayerEntity player) {
        if (loadedCapes.contains(uuid)) {
            WN.LOGGER.debug("Cape already loaded");
            return;
        }
        Patron p = PlayerEventHandler.isPatron(player);
        if (p != null && uuid != null && !uuid.isEmpty()) {
            String url = "https://wildnaturemod.com/data/capes/" + uuid;
            if (WN.is404(url)) {
                url = "https://wildnaturemod.com/data/capes/cape-basic";
            } else {
                WN.LOGGER.info("Found customized cape for " + player.func_145748_c_());
            }
            ResourceLocation rl = new ResourceLocation("wildnature", "capes/" + uuid);
            TextureManager textureManager = Minecraft.func_71410_x().func_110434_K();
            IImageBuffer iib = new IImageBuffer(){

                @Override
                public NativeImage parseUserSkin(NativeImage img) {
                    return ClientPlayerEventHandler.parseCape(img, uuid);
                }

                @Override
                public void skinAvailable() {
                }
            };
            CapeTexture textureCape = new CapeTexture(url, null, iib);
            textureManager.func_229263_a_(rl, (Texture)textureCape);
            loadedCapes.add(uuid);
        }
    }

    public static NativeImage parseCape(NativeImage img, String uuid) {
        int imageHeight;
        int imageWidth = 64;
        int srcWidth = img.func_195702_a();
        int x = img.func_195714_b();
        for (imageHeight = 32; imageWidth < srcWidth || imageHeight < x; imageWidth *= 2, imageHeight *= 2) {
        }
        NativeImage imgNew = new NativeImage(imageWidth, imageHeight, true);
        for (x = 0; x < img.func_195702_a(); ++x) {
            for (int y = 0; y < img.func_195714_b(); ++y) {
                imgNew.func_195700_a(x, y, img.func_195709_a(x, y));
            }
        }
        img.close();
        PlayerEventHandler.playersCape.put(uuid, true);
        return imgNew;
    }
}

