/*
 * Decompiled with CFR 0.152.
 */
package com.matez.wildnature.util.noise;

import com.matez.wildnature.util.noise.FastMath;
import com.matez.wildnature.util.noise.Vec2f;

public class NoiseUtil {
    public static final int X_PRIME = 1619;
    public static final int Y_PRIME = 31337;
    public static final Vec2f[] GRAD_2D = new Vec2f[]{new Vec2f(-1.0f, -1.0f), new Vec2f(1.0f, -1.0f), new Vec2f(-1.0f, 1.0f), new Vec2f(1.0f, 1.0f), new Vec2f(0.0f, -1.0f), new Vec2f(-1.0f, 0.0f), new Vec2f(0.0f, 1.0f), new Vec2f(1.0f, 0.0f)};
    public static final Vec2f[] GRAD_2D_24 = new Vec2f[]{new Vec2f(0.13052619f, 0.9914449f), new Vec2f(0.38268343f, 0.9238795f), new Vec2f(0.6087614f, 0.7933533f), new Vec2f(0.6087614f, 0.7933533f), new Vec2f(0.7933533f, 0.6087614f), new Vec2f(0.9238795f, 0.38268343f), new Vec2f(0.9914449f, 0.13052619f), new Vec2f(0.9914449f, 0.13052619f), new Vec2f(0.9914449f, -0.13052619f), new Vec2f(0.9238795f, -0.38268343f), new Vec2f(0.7933533f, -0.6087614f), new Vec2f(0.7933533f, -0.6087614f), new Vec2f(0.6087614f, -0.7933533f), new Vec2f(0.38268343f, -0.9238795f), new Vec2f(0.13052619f, -0.9914449f), new Vec2f(0.13052619f, -0.9914449f), new Vec2f(-0.13052619f, -0.9914449f), new Vec2f(-0.38268343f, -0.9238795f), new Vec2f(-0.6087614f, -0.7933533f), new Vec2f(-0.6087614f, -0.7933533f), new Vec2f(-0.7933533f, -0.6087614f), new Vec2f(-0.9238795f, -0.38268343f), new Vec2f(-0.9914449f, -0.13052619f), new Vec2f(-0.9914449f, -0.13052619f), new Vec2f(-0.9914449f, 0.13052619f), new Vec2f(-0.9238795f, 0.38268343f), new Vec2f(-0.7933533f, 0.6087614f), new Vec2f(-0.7933533f, 0.6087614f), new Vec2f(-0.6087614f, 0.7933533f), new Vec2f(-0.38268343f, 0.9238795f), new Vec2f(-0.13052619f, 0.9914449f), new Vec2f(-0.13052619f, 0.9914449f)};
    public static final Vec2f[] CELL_2D = new Vec2f[]{new Vec2f(-0.43135393f, 0.12819435f), new Vec2f(-0.17333168f, 0.41527838f), new Vec2f(-0.28219575f, -0.35052183f), new Vec2f(-0.28064737f, 0.35176277f), new Vec2f(0.3125509f, -0.3237467f), new Vec2f(0.33830184f, -0.29673535f), new Vec2f(-0.4393982f, -0.09710417f), new Vec2f(-0.44604436f, -0.05953503f), new Vec2f(-0.30222303f, 0.3334085f), new Vec2f(-0.21268106f, -0.39656875f), new Vec2f(-0.29911566f, 0.33619907f), new Vec2f(0.22933237f, 0.38717782f), new Vec2f(0.44754392f, -0.046951506f), new Vec2f(0.1777518f, 0.41340572f), new Vec2f(0.16885225f, -0.4171198f), new Vec2f(-0.097659715f, 0.43927506f), new Vec2f(0.084501885f, 0.44199485f), new Vec2f(-0.40987605f, -0.18574613f), new Vec2f(0.34765857f, -0.2857158f), new Vec2f(-0.335067f, -0.30038327f), new Vec2f(0.229819f, -0.38688916f), new Vec2f(-0.010699241f, 0.4498728f), new Vec2f(-0.44601414f, -0.059761196f), new Vec2f(0.3650294f, 0.26316068f), new Vec2f(-0.34947944f, 0.28348568f), new Vec2f(-0.41227207f, 0.18036559f), new Vec2f(-0.26732782f, 0.36198872f), new Vec2f(0.32212403f, -0.31422302f), new Vec2f(0.2880446f, -0.34573156f), new Vec2f(0.38921708f, -0.22585405f), new Vec2f(0.4492085f, -0.026678115f), new Vec2f(-0.44977248f, 0.014307996f), new Vec2f(0.12781754f, -0.43146574f), new Vec2f(-0.035721004f, 0.44858f), new Vec2f(-0.4297407f, -0.13350253f), new Vec2f(-0.32178178f, 0.3145735f), new Vec2f(-0.3057159f, 0.33020872f), new Vec2f(-0.414504f, 0.17517549f), new Vec2f(-0.373814f, 0.25052565f), new Vec2f(0.22368914f, -0.39046532f), new Vec2f(0.0029677756f, -0.4499902f), new Vec2f(0.17471284f, -0.4146992f), new Vec2f(-0.44237724f, -0.08247648f), new Vec2f(-0.2763961f, -0.35511294f), new Vec2f(-0.4019386f, -0.20234962f), new Vec2f(0.3871414f, -0.22939382f), new Vec2f(-0.43000874f, 0.1326367f), new Vec2f(-0.030375743f, -0.44897363f), new Vec2f(-0.34861815f, 0.28454417f), new Vec2f(0.045535173f, -0.44769025f), new Vec2f(-0.037580293f, 0.44842806f), new Vec2f(0.3266409f, 0.309525f), new Vec2f(0.065400176f, -0.4452222f), new Vec2f(0.03409026f, 0.44870687f), new Vec2f(-0.44491938f, 0.06742967f), new Vec2f(-0.4255936f, -0.14618507f), new Vec2f(0.4499173f, 0.008627303f), new Vec2f(0.052426063f, 0.44693568f), new Vec2f(-0.4495305f, -0.020550266f), new Vec2f(-0.12047757f, 0.43357256f), new Vec2f(-0.3419864f, -0.2924813f), new Vec2f(0.386532f, 0.23041917f), new Vec2f(0.045060977f, -0.4477382f), new Vec2f(-0.06283466f, 0.4455915f), new Vec2f(0.39326003f, -0.21873853f), new Vec2f(0.44722617f, -0.04988731f), new Vec2f(0.3753571f, -0.24820767f), new Vec2f(-0.2736623f, 0.35722396f), new Vec2f(0.17004615f, 0.4166345f), new Vec2f(0.41026923f, 0.18487608f), new Vec2f(0.3232272f, -0.31308815f), new Vec2f(-0.28823102f, -0.34557614f), new Vec2f(0.20509727f, 0.4005435f), new Vec2f(0.4414086f, -0.08751257f), new Vec2f(-0.16847004f, 0.4172743f), new Vec2f(-0.0039780326f, 0.4499824f), new Vec2f(-0.20551336f, 0.4003302f), new Vec2f(-0.006095675f, -0.4499587f), new Vec2f(-0.11962281f, -0.43380916f), new Vec2f(0.39015284f, -0.2242337f), new Vec2f(0.017235318f, 0.4496698f), new Vec2f(-0.30150703f, 0.33405614f), new Vec2f(-0.015142624f, -0.44974515f), new Vec2f(-0.4142574f, -0.1757578f), new Vec2f(-0.19163772f, -0.40715474f), new Vec2f(0.37492487f, 0.24886008f), new Vec2f(-0.22377743f, 0.39041474f), new Vec2f(-0.41663432f, -0.17004661f), new Vec2f(0.36191717f, 0.2674247f), new Vec2f(0.18911268f, -0.4083337f), new Vec2f(-0.3127425f, 0.3235616f), new Vec2f(-0.3281808f, 0.30789182f), new Vec2f(-0.22948067f, 0.38708994f), new Vec2f(-0.34452662f, 0.28948474f), new Vec2f(-0.41670954f, -0.16986217f), new Vec2f(-0.2578903f, -0.36877173f), new Vec2f(-0.3612038f, 0.26838747f), new Vec2f(0.22679965f, 0.38866684f), new Vec2f(0.20715706f, 0.3994821f), new Vec2f(0.083551764f, -0.44217542f), new Vec2f(-0.43122333f, 0.12863296f), new Vec2f(0.32570556f, 0.3105091f), new Vec2f(0.1777011f, -0.41342753f), new Vec2f(-0.44518253f, 0.0656698f), new Vec2f(0.39551434f, 0.21463552f), new Vec2f(-0.4264614f, 0.14363383f), new Vec2f(-0.37937996f, -0.24201414f), new Vec2f(0.04617599f, -0.4476246f), new Vec2f(-0.37140542f, -0.25408268f), new Vec2f(0.25635704f, -0.36983925f), new Vec2f(0.03476646f, 0.44865498f), new Vec2f(-0.30654544f, 0.32943875f), new Vec2f(-0.22569798f, 0.38930762f), new Vec2f(0.41164485f, -0.18179253f), new Vec2f(-0.29077458f, -0.3434387f), new Vec2f(0.28422785f, -0.3488761f), new Vec2f(0.31145895f, -0.32479736f), new Vec2f(0.44641557f, -0.05668443f), new Vec2f(-0.3037334f, -0.33203316f), new Vec2f(0.4079607f, 0.18991591f), new Vec2f(-0.3486949f, -0.2844501f), new Vec2f(0.32648215f, 0.30969244f), new Vec2f(0.32111424f, 0.3152549f), new Vec2f(0.011833827f, 0.44984436f), new Vec2f(0.43338442f, 0.1211526f), new Vec2f(0.31186685f, 0.32440573f), new Vec2f(-0.27275348f, 0.35791835f), new Vec2f(-0.42222863f, -0.15563737f), new Vec2f(-0.10097001f, -0.438526f), new Vec2f(-0.2741171f, -0.35687506f), new Vec2f(-0.14651251f, 0.425481f), new Vec2f(0.2302279f, -0.38664597f), new Vec2f(-0.36994356f, 0.25620648f), new Vec2f(0.10570035f, -0.4374099f), new Vec2f(-0.26467136f, 0.36393553f), new Vec2f(0.3521828f, 0.2801201f), new Vec2f(-0.18641879f, -0.40957054f), new Vec2f(0.1994493f, -0.40338564f), new Vec2f(0.3937065f, 0.21793391f), new Vec2f(-0.32261583f, 0.31371805f), new Vec2f(0.37962353f, 0.2416319f), new Vec2f(0.1482922f, 0.424864f), new Vec2f(-0.4074004f, 0.19111493f), new Vec2f(0.4212853f, 0.15817298f), new Vec2f(-0.26212972f, 0.36577043f), new Vec2f(-0.2536987f, -0.37166783f), new Vec2f(-0.21002364f, 0.3979825f), new Vec2f(0.36241525f, 0.2667493f), new Vec2f(-0.36450386f, -0.26388812f), new Vec2f(0.23184867f, 0.38567626f), new Vec2f(-0.3260457f, 0.3101519f), new Vec2f(-0.21300453f, -0.3963951f), new Vec2f(0.3814999f, -0.23865843f), new Vec2f(-0.34297732f, 0.29131868f), new Vec2f(-0.43558657f, 0.11297941f), new Vec2f(-0.21046796f, 0.3977477f), new Vec2f(0.33483645f, -0.30064023f), new Vec2f(0.34304687f, 0.29123673f), new Vec2f(-0.22918367f, -0.38726586f), new Vec2f(0.25477073f, -0.3709338f), new Vec2f(0.42361748f, -0.1518164f), new Vec2f(-0.15387742f, 0.4228732f), new Vec2f(-0.44074494f, 0.09079596f), new Vec2f(-0.06805276f, -0.4448245f), new Vec2f(0.44535172f, -0.06451237f), new Vec2f(0.25624645f, -0.36991587f), new Vec2f(0.32781982f, -0.30827612f), new Vec2f(-0.41227743f, -0.18035334f), new Vec2f(0.3354091f, -0.30000123f), new Vec2f(0.44663286f, -0.054946158f), new Vec2f(-0.16089533f, 0.42025313f), new Vec2f(-0.09463955f, 0.43993562f), new Vec2f(-0.026376883f, -0.4492263f), new Vec2f(0.44710281f, -0.050981198f), new Vec2f(-0.4365671f, 0.10912917f), new Vec2f(-0.39598587f, 0.21376434f), new Vec2f(-0.42400482f, -0.15073125f), new Vec2f(-0.38827947f, 0.22746222f), new Vec2f(-0.42836526f, -0.13785212f), new Vec2f(0.3303888f, 0.30552125f), new Vec2f(0.3321435f, -0.30361274f), new Vec2f(-0.41302106f, -0.17864382f), new Vec2f(0.084030606f, -0.44208467f), new Vec2f(-0.38228828f, 0.23739347f), new Vec2f(-0.37123957f, -0.25432497f), new Vec2f(0.4472364f, -0.049795635f), new Vec2f(-0.44665912f, 0.054732345f), new Vec2f(0.048627254f, -0.44736493f), new Vec2f(-0.42031014f, -0.16074637f), new Vec2f(0.22053608f, 0.3922548f), new Vec2f(-0.36249006f, 0.2666476f), new Vec2f(-0.40360868f, -0.19899757f), new Vec2f(0.21527278f, 0.39516786f), new Vec2f(-0.43593928f, -0.11161062f), new Vec2f(0.4178354f, 0.1670735f), new Vec2f(0.20076302f, 0.40273342f), new Vec2f(-0.07278067f, -0.4440754f), new Vec2f(0.36447486f, -0.26392817f), new Vec2f(-0.43174517f, 0.12687041f), new Vec2f(-0.29743645f, 0.33768559f), new Vec2f(-0.2998672f, 0.3355289f), new Vec2f(-0.26736742f, 0.3619595f), new Vec2f(0.28084233f, 0.35160714f), new Vec2f(0.34989464f, 0.28297302f), new Vec2f(-0.22296856f, 0.39087725f), new Vec2f(0.33058232f, 0.30531186f), new Vec2f(-0.24366812f, -0.37831977f), new Vec2f(-0.034027766f, 0.4487116f), new Vec2f(-0.31935883f, 0.31703302f), new Vec2f(0.44546336f, -0.063737005f), new Vec2f(0.44835043f, 0.03849544f), new Vec2f(-0.44273585f, -0.08052933f), new Vec2f(0.054522987f, 0.44668472f), new Vec2f(-0.28125608f, 0.35127628f), new Vec2f(0.12666969f, 0.43180412f), new Vec2f(-0.37359813f, 0.25084746f), new Vec2f(0.29597083f, -0.3389709f), new Vec2f(-0.37143773f, 0.25403547f), new Vec2f(-0.4044671f, -0.19724695f), new Vec2f(0.16361657f, -0.41920117f), new Vec2f(0.32891855f, -0.30710354f), new Vec2f(-0.2494825f, -0.374511f), new Vec2f(0.032831334f, 0.44880074f), new Vec2f(-0.16630606f, -0.41814148f), new Vec2f(-0.10683318f, 0.43713462f), new Vec2f(0.0644026f, -0.4453676f), new Vec2f(-0.4483231f, 0.03881238f), new Vec2f(-0.42137775f, -0.15792651f), new Vec2f(0.05097921f, -0.44710302f), new Vec2f(0.20505841f, -0.40056342f), new Vec2f(0.41780984f, -0.16713744f), new Vec2f(-0.35651895f, -0.27458012f), new Vec2f(0.44783983f, 0.04403978f), new Vec2f(-0.33999997f, -0.2947881f), new Vec2f(0.3767122f, 0.24614613f), new Vec2f(-0.31389344f, 0.32244518f), new Vec2f(-0.14620018f, -0.42558843f), new Vec2f(0.39702904f, -0.21182053f), new Vec2f(0.44591492f, -0.0604969f), new Vec2f(-0.41048893f, -0.18438771f), new Vec2f(0.1475104f, -0.4251361f), new Vec2f(0.0925803f, 0.44037357f), new Vec2f(-0.15896647f, -0.42098653f), new Vec2f(0.2482445f, 0.37533274f), new Vec2f(0.43836242f, -0.10167786f), new Vec2f(0.06242803f, 0.44564867f), new Vec2f(0.2846591f, -0.3485243f), new Vec2f(-0.34420276f, -0.28986976f), new Vec2f(0.11981889f, -0.43375504f), new Vec2f(-0.2435907f, 0.37836963f), new Vec2f(0.2958191f, -0.3391033f), new Vec2f(-0.1164008f, 0.43468478f), new Vec2f(0.12740372f, -0.4315881f), new Vec2f(0.3680473f, 0.2589231f), new Vec2f(0.2451437f, 0.3773653f), new Vec2f(-0.43145096f, 0.12786736f)};

    public static float map(float value, float min, float max, float range) {
        float dif = NoiseUtil.clamp(value, min, max) - min;
        if (dif > range) {
            return 1.0f;
        }
        return dif / range;
    }

    public static float range(float input, float input_start, float input_end, float output_start, float output_end) {
        float input_range = input_end - input_start;
        float output_range = output_end - output_start;
        return (input - input_start) * output_range / input_range + output_start;
    }

    public static float clamp(float value, float min, float max) {
        if (value < min) {
            return min;
        }
        if (value > max) {
            return max;
        }
        return value;
    }

    public static int toInt(float f) {
        int i = Float.floatToRawIntBits(f);
        return i ^ i >> 16;
    }

    public static int floor(float f) {
        return f >= 0.0f ? (int)f : (int)f - 1;
    }

    public static int round(float f) {
        return f >= 0.0f ? (int)(f + 0.5f) : (int)(f - 0.5f);
    }

    public static float lerp(float a, float b, float alpha) {
        return a + alpha * (b - a);
    }

    public static float interpHermite(float t) {
        return t * t * (3.0f - 2.0f * t);
    }

    public static float interpQuintic(float t) {
        return t * t * t * (t * (t * 6.0f - 15.0f) + 10.0f);
    }

    public static float curve(float t, float steepness) {
        return NoiseUtil.curve(t, 0.5f, steepness);
    }

    public static float curve(float t, float mid, float steepness) {
        return 1.0f / (1.0f + NoiseUtil.exp(-steepness * (t - mid)));
    }

    public static float cubicLerp(float a, float b, float c, float d, float t) {
        float p = d - c - (a - b);
        return t * t * t * p + t * t * (a - b - p) + t * (c - a) + b;
    }

    public static float exp(float x) {
        x = 1.0f + x / 256.0f;
        x *= x;
        x *= x;
        x *= x;
        x *= x;
        x *= x;
        x *= x;
        x *= x;
        x *= x;
        return x;
    }

    public static int hash(int x, int y) {
        int hash = x;
        hash ^= 31337 * y;
        hash = hash * hash * hash * 60493;
        hash = hash >> 13 ^ hash;
        return hash;
    }

    public static int hash2D(int seed, int x, int y) {
        int hash = seed;
        hash ^= 1619 * x;
        hash ^= 31337 * y;
        hash = hash * hash * hash * 60493;
        hash = hash >> 13 ^ hash;
        return hash;
    }

    public static float valCoord2D(int seed, int x, int y) {
        int n = seed;
        n ^= 1619 * x;
        return (float)((n ^= 31337 * y) * n * n * 60493) / 2.1474836E9f;
    }

    public static Vec2f coord2D(int seed, int x, int y) {
        int hash = seed;
        hash ^= 1619 * x;
        hash ^= 31337 * y;
        hash = hash * hash * hash * 60493;
        hash = hash >> 13 ^ hash;
        return GRAD_2D[hash & 7];
    }

    public static Vec2f coord2D_24(int seed, int x, int y) {
        int hash = seed;
        hash ^= 1619 * x;
        hash ^= 31337 * y;
        hash = hash * hash * hash * 60493;
        hash = hash >> 13 ^ hash;
        int selector24 = (int)((float)(hash & 0x3FFFFF) * 1.3333334f) & 0x1F;
        return GRAD_2D_24[selector24];
    }

    public static float gradCoord2D(int seed, int x, int y, float xd, float yd) {
        Vec2f g = NoiseUtil.coord2D(seed, x, y);
        return xd * g.x + yd * g.y;
    }

    public static float gradCoord2D_24(int seed, int x, int y, float xd, float yd) {
        Vec2f g = NoiseUtil.coord2D_24(seed, x, y);
        return xd * g.x + yd * g.y;
    }

    public static float pow(float value, float power) {
        return (float)FastMath.pow((double)value, power);
    }
}

