/*
 * Decompiled with CFR 0.152.
 */
package com.matez.wildnature.util.other;

import com.matez.wildnature.util.other.BiomeWeighList;
import com.matez.wildnature.util.other.BlockWeighList;
import com.matez.wildnature.util.other.TreeWeighList;
import com.matez.wildnature.util.other.WeightedList;
import com.matez.wildnature.world.generation.structures.nature.SchemFeature;
import java.awt.Color;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.BushBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeContainer;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.chunk.IChunk;

public class Utilities {
    public static int rint(int min, int max) {
        if (min == max) {
            return min;
        }
        if (min >= max) {
            return max;
        }
        Random r = new Random();
        return r.nextInt(max - min + 1) + min;
    }

    public static int rint(int min, int max, Random rand) {
        if (min == max) {
            return min;
        }
        if (min >= max) {
            return max;
        }
        return rand.nextInt(max - min + 1) + min;
    }

    public static double rdoub(double min, double max) {
        if (min == max) {
            return min;
        }
        if (min >= max) {
            return max;
        }
        Random r = new Random();
        return min + (max - min) * r.nextDouble();
    }

    public static double rdoub(double min, double max, Random rand) {
        if (min == max) {
            return min;
        }
        if (min >= max) {
            return max;
        }
        return min + (max - min) * rand.nextDouble();
    }

    public static boolean iBetween(int rangeMin, int rangeMax, int number) {
        return number > rangeMin && number < rangeMax;
    }

    public static boolean dBetween(double rangeMin, double rangeMax, double number) {
        return number > rangeMin && number < rangeMax;
    }

    public static boolean chance(double percentChance) {
        double x = Utilities.rdoub(0.0, 100.0);
        return percentChance >= x;
    }

    public static boolean chance(double percentChance, Random rand) {
        double x = Utilities.rdoub(0.0, 100.0, rand);
        return percentChance <= x;
    }

    public static BlockState getWeighBlock(BlockWeighList list) {
        if (list.size() != 0) {
            ArrayList<BlockState> blockStates = list.getNormalArrayList();
            int block = Utilities.rint(0, blockStates.size() - 1);
            return blockStates.get(block);
        }
        return null;
    }

    public static SchemFeature getWeighTree(TreeWeighList list) {
        if (list.size() != 0) {
            ArrayList<SchemFeature> trees = list.getNormalArrayList();
            int block = Utilities.rint(0, trees.size() - 1);
            return trees.get(block);
        }
        return null;
    }

    public static SchemFeature getWeighTree(TreeWeighList list, Random rand) {
        if (list.size() != 0) {
            ArrayList<SchemFeature> trees = list.getNormalArrayList();
            int block = Utilities.rint(0, trees.size() - 1, rand);
            return trees.get(block);
        }
        return null;
    }

    public static Biome getWeighBiome(BiomeWeighList list, Random rand) {
        if (list.size() != 0) {
            ArrayList<Biome> biomes = list.getNormalArrayList();
            int biome = Utilities.rint(0, biomes.size() - 1, rand);
            return biomes.get(biome);
        }
        return null;
    }

    public static Biome getWeighBiome(BiomeWeighList list) {
        if (list.size() != 0) {
            ArrayList<Biome> biomes = list.getNormalArrayList();
            int biome = Utilities.rint(0, biomes.size() - 1);
            return biomes.get(biome);
        }
        return null;
    }

    public static int blockDistance(BlockPos pos1, BlockPos pos2) {
        return (int)Math.sqrt(Math.pow(pos2.func_177958_n() - pos1.func_177958_n(), 2.0) + Math.pow(pos2.func_177956_o() - pos1.func_177956_o(), 2.0) + Math.pow(pos2.func_177952_p() - pos1.func_177952_p(), 2.0));
    }

    public static double blockDistanceDouble(BlockPos pos1, BlockPos pos2) {
        return Math.sqrt(Math.pow(pos2.func_177958_n() - pos1.func_177958_n(), 2.0) + Math.pow(pos2.func_177956_o() - pos1.func_177956_o(), 2.0) + Math.pow(pos2.func_177952_p() - pos1.func_177952_p(), 2.0));
    }

    @Nullable
    public static PlayerEntity getClosestPlayer(World world, double x, double y, double z) {
        PlayerEntity entity = null;
        double closestDistance = -1.0;
        boolean nb = true;
        for (PlayerEntity player : world.func_217369_A()) {
            if (player.func_175149_v()) continue;
            double distance = Utilities.blockDistanceDouble(new BlockPos(x, y, z), player.func_180425_c());
            if (nb) {
                entity = player;
                closestDistance = distance;
                nb = false;
                continue;
            }
            if (!(closestDistance > distance)) continue;
            entity = player;
            closestDistance = distance;
        }
        return entity;
    }

    public static int SumOfDigits(String str, int n) {
        int sum = 0;
        for (int i = 0; i < n; ++i) {
            sum += str.charAt(i) - 48;
        }
        return sum;
    }

    public static boolean isDivisible(String str, int n) {
        return Utilities.SumOfDigits(str, n) % 3 == 0 && str.charAt(n - 1) == '0';
    }

    public static boolean isStringEqual(String s, String ... strings) {
        ArrayList<String> sar = new ArrayList<String>(Arrays.asList(strings));
        for (int i = 0; i < sar.size(); ++i) {
            if (!s.equals(sar.get(i))) continue;
            return true;
        }
        return false;
    }

    public static Direction rotateLeft(Direction old) {
        Direction newDir = old == Direction.NORTH ? Direction.WEST : (old == Direction.WEST ? Direction.SOUTH : (old == Direction.SOUTH ? Direction.EAST : Direction.NORTH));
        return newDir;
    }

    public static Direction rotateRight(Direction old) {
        Direction newDir = old == Direction.NORTH ? Direction.EAST : (old == Direction.EAST ? Direction.SOUTH : (old == Direction.SOUTH ? Direction.WEST : Direction.NORTH));
        return newDir;
    }

    public static CompoundNBT saveItem(CompoundNBT nbt, ItemStack stack) {
        stack.func_77955_b(nbt);
        return nbt;
    }

    public static ItemStack loadItem(CompoundNBT nbt) {
        ItemStack stack = ItemStack.func_199557_a((CompoundNBT)nbt);
        return stack;
    }

    public static CompoundNBT saveItemTile(CompoundNBT nbt, ItemStack stack) {
        stack.func_77955_b(nbt);
        return nbt;
    }

    public static ItemStack loadItemTile(CompoundNBT nbt) {
        ItemStack stack = ItemStack.func_199557_a((CompoundNBT)nbt);
        return stack;
    }

    public static CompoundNBT saveItems(CompoundNBT nbt, ArrayList<ItemStack> stack) {
        if (nbt.func_74764_b("Items")) {
            nbt.func_82580_o("Items");
        }
        ListNBT l = new ListNBT();
        for (ItemStack itemStack : stack) {
            CompoundNBT n = new CompoundNBT();
            itemStack.func_77955_b(n);
            l.add((Object)n);
        }
        nbt.func_218657_a("Items", (INBT)l);
        return nbt;
    }

    public static ArrayList<ItemStack> loadItems(CompoundNBT nbt) {
        if (nbt.func_74764_b("Items")) {
            ListNBT l = (ListNBT)nbt.func_74781_a("Items");
            assert (l != null);
            ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
            for (INBT inbt : l) {
                ItemStack s = ItemStack.func_199557_a((CompoundNBT)((CompoundNBT)inbt));
                stacks.add(s);
            }
            return stacks;
        }
        return new ArrayList<ItemStack>();
    }

    public static Object getRandomEntry(ArrayList<?> array, Random rand) {
        return array.get(Utilities.rint(0, array.size() - 1, rand));
    }

    public static Object getWeightedEntry(WeightedList<?> list) {
        if (list.size() != 0) {
            ArrayList<?> objects = list.getSimplifedArray();
            int x = Utilities.rint(0, objects.size() - 1);
            return objects.get(x);
        }
        return null;
    }

    public static Object getWeightedEntry(WeightedList<?> list, Random rand) {
        if (list.size() != 0) {
            ArrayList<?> objects = list.getSimplifedArray();
            int x = Utilities.rint(0, objects.size() - 1, rand);
            return objects.get(x);
        }
        return null;
    }

    public static int countDuplicates(ArrayList<?> list, Object obj) {
        return Collections.frequency(list, obj);
    }

    public static int getColorValue(int hex) {
        return hex | 0xFF000000;
    }

    public static String blendColors(Color clOne, Color clTwo, float fAmount) {
        float fInverse = 1.0f - fAmount;
        float[] afOne = new float[3];
        clOne.getColorComponents(afOne);
        float[] afTwo = new float[3];
        clTwo.getColorComponents(afTwo);
        float[] afResult = new float[]{afOne[0] * fAmount + afTwo[0] * fInverse, afOne[1] * fAmount + afTwo[1] * fInverse, afOne[2] * fAmount + afTwo[2] * fInverse};
        Color c = new Color(afResult[0], afResult[1], afResult[2]);
        String hex = String.format("%02x%02x%02x", c.getRed(), c.getGreen(), c.getBlue());
        return hex;
    }

    public static float getDistance(BlockPos pos1, BlockPos pos2) {
        float f = pos1.func_177958_n() - pos2.func_177958_n();
        float f1 = pos1.func_177956_o() - pos2.func_177956_o();
        float f2 = pos1.func_177952_p() - pos2.func_177952_p();
        return MathHelper.func_76129_c((float)(f * f + f1 * f1 + f2 * f2));
    }

    public static boolean isBlockNear(IWorld world, BlockPos pos, Block ... blocks) {
        try {
            for (Block block : blocks) {
                if (world.func_180495_p(pos.func_177972_a(Direction.NORTH)).func_177230_c() == block) {
                    return true;
                }
                if (world.func_180495_p(pos.func_177972_a(Direction.SOUTH)).func_177230_c() == block) {
                    return true;
                }
                if (world.func_180495_p(pos.func_177972_a(Direction.EAST)).func_177230_c() == block) {
                    return true;
                }
                if (world.func_180495_p(pos.func_177972_a(Direction.WEST)).func_177230_c() != block) continue;
                return true;
            }
            return false;
        }
        catch (Exception e) {
            return true;
        }
    }

    public static boolean isUnsolidBlockNear(IWorld world, BlockPos pos) {
        try {
            if (!world.func_180495_p(pos.func_177972_a(Direction.NORTH)).func_200132_m()) {
                return true;
            }
            if (!world.func_180495_p(pos.func_177972_a(Direction.SOUTH)).func_200132_m()) {
                return true;
            }
            if (!world.func_180495_p(pos.func_177972_a(Direction.EAST)).func_200132_m()) {
                return true;
            }
            return !world.func_180495_p(pos.func_177972_a(Direction.WEST)).func_200132_m();
        }
        catch (Exception e) {
            return true;
        }
    }

    public static boolean isBlockNear(IChunk world, BlockPos pos, Block ... blocks) {
        for (Block block : blocks) {
            if (world.func_180495_p(pos.func_177972_a(Direction.NORTH)).func_177230_c() == block) {
                return true;
            }
            if (world.func_180495_p(pos.func_177972_a(Direction.SOUTH)).func_177230_c() == block) {
                return true;
            }
            if (world.func_180495_p(pos.func_177972_a(Direction.EAST)).func_177230_c() == block) {
                return true;
            }
            if (world.func_180495_p(pos.func_177972_a(Direction.WEST)).func_177230_c() != block) continue;
            return true;
        }
        return false;
    }

    public static boolean isValidGroundFor(BlockState plant, BlockState placeState, @Nullable IBlockReader world, @Nullable BlockPos pos) throws Exception {
        if (plant.func_177230_c() instanceof BushBlock) {
            Class<?> clazz;
            Method method = null;
            for (Class<?> superclass = clazz = plant.func_177230_c().getClass(); superclass != null; superclass = superclass.getSuperclass()) {
                try {
                    method = superclass.getDeclaredMethod("func_200014_a_", BlockState.class, IBlockReader.class, BlockPos.class);
                    break;
                }
                catch (Exception e) {
                    continue;
                }
            }
            if (method != null) {
                method.setAccessible(true);
                return (Boolean)method.invoke((Object)plant.func_177230_c(), placeState, world, pos);
            }
            return false;
        }
        return false;
    }

    public static Biome getBiomeOnPos(BiomeProvider provider, int x, int z) {
        return provider.func_225526_b_(x / 4, 0, z / 4);
    }

    public static Biome getBiomeOnPos(BiomeContainer provider, int x, int z) {
        return provider.func_225526_b_(x / 4, 0, z / 4);
    }

    public static float scaleBetween(float unscaledNum, float minAllowed, float maxAllowed, float min, float max) {
        return (maxAllowed - minAllowed) * (unscaledNum - min) / (max - min) + minAllowed;
    }

    public static double scaleBetween(double unscaledNum, double minAllowed, double maxAllowed, double min, double max) {
        return (maxAllowed - minAllowed) * (unscaledNum - min) / (max - min) + minAllowed;
    }

    public static int scaleBetween(int unscaledNum, int minAllowed, int maxAllowed, int min, int max) {
        return (maxAllowed - minAllowed) * (unscaledNum - min) / (max - min) + minAllowed;
    }

    public static PlayerEntity getPlayerByUUID(String uuid, World world) {
        try {
            return world.func_217371_b(UUID.fromString(uuid));
        }
        catch (Exception e) {
            return null;
        }
    }

    public static PlayerEntity getPlayerByUUID(String uuid, MinecraftServer server) {
        try {
            return server.func_184103_al().func_177451_a(UUID.fromString(uuid));
        }
        catch (Exception e) {
            return null;
        }
    }

    public static PlayerEntity getPlayerByUUID(UUID uuid, MinecraftServer server) {
        try {
            return server.func_184103_al().func_177451_a(uuid);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static boolean canPlantHurt(Entity entity) {
        if (entity instanceof LivingEntity) {
            if (entity instanceof PlayerEntity) {
                return true;
            }
            if (entity.func_145818_k_()) {
                return false;
            }
            if (entity instanceof TameableEntity && ((TameableEntity)entity).func_70909_n()) {
                return false;
            }
        }
        return true;
    }
}

