/*
 * Decompiled with CFR 0.152.
 */
package com.matez.wildnature.world.generation.biome.setup;

import com.matez.wildnature.world.generation.biome.registry.WNBiomes;
import com.matez.wildnature.world.generation.generators.functions.interpolation.LerpConfiguration;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;

public class BiomeVariants {
    private final SmallGroup smallGroup;
    private final LargeGroup largeGroup;
    public static BiomeVariants LAND = new BiomeVariants(SmallGroup.BODY, LargeGroup.LAND);
    public static BiomeVariants PLATEAU = new BiomeVariants(SmallGroup.RIVER, LargeGroup.LAND);
    public static BiomeVariants RIVER = new BiomeVariants(SmallGroup.RIVER, LargeGroup.RIVER);
    public static BiomeVariants LAKE = new BiomeVariants(SmallGroup.BODY, LargeGroup.LAKE);
    public static BiomeVariants SHORE = new BiomeVariants(SmallGroup.BODY, LargeGroup.LAKE);
    public static BiomeVariants OCEAN = new BiomeVariants(SmallGroup.BODY, LargeGroup.OCEAN);
    public static BiomeVariants SMALL_ISLAND = new BiomeVariants(SmallGroup.RIVER, LargeGroup.OCEAN);
    public static BiomeVariants PATH = new BiomeVariants(SmallGroup.RIVER, LargeGroup.RIVER);

    public BiomeVariants(SmallGroup smallGroup, LargeGroup largeGroup) {
        this.smallGroup = smallGroup;
        this.largeGroup = largeGroup;
    }

    public LargeGroup getLargeGroup() {
        return this.largeGroup;
    }

    public SmallGroup getSmallGroup() {
        return this.smallGroup;
    }

    public static BiomeVariants getVariantsFor(Biome biome) {
        if (biome == WNBiomes.RiverValleySharp) {
            return SHORE;
        }
        if (biome == WNBiomes.RiverValleySmooth) {
            return LAND;
        }
        if (biome == WNBiomes.Island || biome == WNBiomes.ForestedIsland || biome == WNBiomes.SnowyIsland || biome == WNBiomes.ParadiseIsland) {
            return SMALL_ISLAND;
        }
        if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.OCEAN)) {
            return OCEAN;
        }
        if (biome == WNBiomes.ColdLake || biome == WNBiomes.DriedLake || biome == WNBiomes.FrozenLake || biome == WNBiomes.TropicalLake || biome == WNBiomes.WarmLake || biome == WNBiomes.MorskieOko || biome == WNBiomes.FrozenMorskieOko) {
            return LAKE;
        }
        if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.BEACH)) {
            return SHORE;
        }
        if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.RIVER)) {
            return RIVER;
        }
        if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.PLATEAU)) {
            return PLATEAU;
        }
        return LAND;
    }

    public static BiomeVariants getVariantsFor(LerpConfiguration configuration) {
        return BiomeVariants.getVariantsFor(configuration.getBiome());
    }

    public static enum SmallGroup {
        BODY,
        RIVER;

        public static final int SIZE;

        static {
            SIZE = SmallGroup.values().length;
        }
    }

    public static enum LargeGroup {
        LAND,
        OCEAN,
        RIVER,
        LAKE;

        public static final int SIZE;

        static {
            SIZE = LargeGroup.values().length;
        }
    }
}

