/*
 * Decompiled with CFR 0.152.
 */
package com.matez.wildnature.world.generation.biome.setup.grid;

import com.matez.wildnature.init.WN;
import com.matez.wildnature.world.generation.biome.setup.grid.BiomeTerrain;
import com.matez.wildnature.world.generation.biome.setup.grid.SubBiome;
import com.matez.wildnature.world.generation.transformer.transformers.MainBiomeTransformer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;

public class BiomeGroup {
    private int id;
    private String name;
    private int weight;
    private Biome baseBiome;
    private SubBiome[] subBiomes;
    private Biome[] weightedBiomes;

    private BiomeGroup(String name, int weight, Biome baseBiome, SubBiome ... subBiomes) {
        this.name = name;
        this.weight = weight;
        this.baseBiome = baseBiome;
        this.subBiomes = subBiomes;
        this.weightedBiomes = this.initWeightedBiomes();
        this.setID(++BiomeTerrain.ids);
    }

    public String getName() {
        if (this.name.isEmpty()) {
            return "not named group";
        }
        return this.name;
    }

    public void setID(int id) {
        this.id = id;
    }

    public int getId() {
        return this.id;
    }

    public Biome getBaseBiome() {
        return this.baseBiome;
    }

    public SubBiome[] getSubBiomes() {
        return this.subBiomes;
    }

    public int getWeight() {
        return this.weight;
    }

    public Biome[] initWeightedBiomes() {
        ArrayList<Biome> biomeGroups = new ArrayList<Biome>();
        for (SubBiome subBiome : this.getSubBiomes()) {
            for (int i = 0; i < subBiome.getWeight(); ++i) {
                biomeGroups.add(subBiome.getBiome());
            }
        }
        for (int i = 0; i < 10; ++i) {
            biomeGroups.add(this.getBaseBiome());
        }
        return biomeGroups.toArray(new Biome[0]);
    }

    public Biome[] getWeightedBiomes() {
        return this.weightedBiomes;
    }

    public String toString() {
        return "BiomeGroup{weight=" + this.weight + ", baseBiome=" + this.baseBiome + ", subBiomes=" + Arrays.toString(this.subBiomes) + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BiomeGroup that = (BiomeGroup)o;
        return this.weight == that.weight && this.name.equals(that.name) && this.baseBiome.equals(that.baseBiome) && Arrays.equals(this.subBiomes, that.subBiomes) && Arrays.equals(this.weightedBiomes, that.weightedBiomes);
    }

    public int hashCode() {
        int result = Objects.hash(this.name, this.weight, this.baseBiome);
        result = 31 * result + Arrays.hashCode(this.subBiomes);
        result = 31 * result + Arrays.hashCode(this.weightedBiomes);
        return result;
    }

    public static BiomeGroup[] guess(MainBiomeTransformer.TerrainCategory category, BiomeDictionary.Type[] allowedTypes, BiomeDictionary.Type[] deniedTypes) {
        return BiomeGroup.guess(category, allowedTypes, deniedTypes, false);
    }

    public static BiomeGroup[] guess(MainBiomeTransformer.TerrainCategory category, BiomeDictionary.Type[] allowedTypes, BiomeDictionary.Type[] deniedTypes, boolean ignoreOceans) {
        ArrayList<BiomeGroup> groups = new ArrayList<BiomeGroup>();
        for (BiomeTerrain terrain : BiomeTerrain.getTerrains()) {
            int weight;
            if (!terrain.canGuess()) continue;
            BiomeGroup group = terrain.getGroup();
            if (allowedTypes.length != 0 && !BiomeDictionary.getTypes((Biome)group.getBaseBiome()).containsAll(Arrays.asList(allowedTypes))) continue;
            if (deniedTypes.length != 0) {
                boolean containsDenied = false;
                for (BiomeDictionary.Type deniedType : deniedTypes) {
                    if (!BiomeDictionary.getTypes((Biome)group.getBaseBiome()).contains(deniedType)) continue;
                    containsDenied = true;
                    break;
                }
                if (containsDenied) continue;
            }
            if (ignoreOceans && group.getBaseBiome().func_201856_r() == Biome.Category.OCEAN) continue;
            BiomeGroup newGroup = null;
            float baseBiomeDepth = group.baseBiome.func_185355_j();
            MainBiomeTransformer.TerrainCategory depthCategory = BiomeGroup.getCategoryByDepth(baseBiomeDepth, ignoreOceans);
            SubBiome maxBiome = null;
            float maxBiomeDepth = 0.0f;
            MainBiomeTransformer.TerrainCategory maxBiomeCategory = null;
            SubBiome minBiome = null;
            float minBiomeDepth = 0.0f;
            MainBiomeTransformer.TerrainCategory minBiomeCategory = null;
            for (SubBiome subBiome : group.getSubBiomes()) {
                float depth = subBiome.getBiome().func_185355_j();
                if ((depth > maxBiomeDepth || maxBiome == null) && Math.max(depth, group.getBaseBiome().func_185355_j()) - Math.min(depth, group.getBaseBiome().func_185355_j()) > 0.6f) {
                    maxBiomeDepth = depth;
                    maxBiome = subBiome;
                    maxBiomeCategory = BiomeGroup.getCategoryByDepth(maxBiomeDepth, ignoreOceans);
                }
                if (!(depth < minBiomeDepth) && minBiome != null || !(Math.max(depth, group.getBaseBiome().func_185355_j()) - Math.min(depth, group.getBaseBiome().func_185355_j()) < 0.6f)) continue;
                minBiomeDepth = depth;
                minBiome = subBiome;
                minBiomeCategory = BiomeGroup.getCategoryByDepth(minBiomeDepth, ignoreOceans);
            }
            ArrayList<SubBiome> subBiomes = new ArrayList<SubBiome>(Arrays.asList(group.getSubBiomes()));
            if (depthCategory == category) {
                newGroup = group;
            } else if (maxBiomeCategory == category) {
                subBiomes.remove(maxBiome);
                subBiomes.add(new SubBiome(group.getBaseBiome(), maxBiome.getWeight(), new BiomeDictionary.Type[0]));
                weight = group.weight - group.weight / 3;
                if (weight == 0) {
                    weight = 1;
                } else if (weight < 0) continue;
                newGroup = new BiomeGroup(group.getName(), weight, maxBiome.getBiome(), subBiomes.toArray(new SubBiome[0]));
                newGroup.setID(group.getId());
            } else if (minBiomeCategory == category) {
                subBiomes.remove(minBiome);
                subBiomes.add(new SubBiome(group.getBaseBiome(), minBiome.getWeight(), new BiomeDictionary.Type[0]));
                weight = group.weight - group.weight / 3;
                if (weight == 0) {
                    weight = 1;
                } else if (weight < 0) continue;
                newGroup = new BiomeGroup(group.getName(), weight, minBiome.getBiome(), subBiomes.toArray(new SubBiome[0]));
                newGroup.setID(group.getId());
            }
            if (newGroup == null) continue;
            groups.add(newGroup);
        }
        WN.LOGGER.info("Guessed " + groups.size() + " groups for terrain " + category.getName() + " and types: " + Arrays.toString(allowedTypes));
        return groups.toArray(new BiomeGroup[0]);
    }

    private static MainBiomeTransformer.TerrainCategory getCategoryByDepth(float depth, boolean ignoreOceans) {
        if (depth < -1.2f) {
            return ignoreOceans ? MainBiomeTransformer.TerrainCategory.LOWLANDS : MainBiomeTransformer.TerrainCategory.DEEP_OCEAN;
        }
        if ((double)depth < -0.3) {
            return ignoreOceans ? MainBiomeTransformer.TerrainCategory.LOWLANDS : MainBiomeTransformer.TerrainCategory.OCEAN;
        }
        if ((double)depth < 0.45) {
            return MainBiomeTransformer.TerrainCategory.LOWLANDS;
        }
        return MainBiomeTransformer.TerrainCategory.HIGHLANDS;
    }

    public static class SingleBuilder {
        public static BiomeGroup configure(int weight, Biome baseBiome, SubBiome ... subBiomes) {
            return SingleBuilder.configure("", weight, baseBiome, subBiomes);
        }

        public static BiomeGroup configure(Biome baseBiome, SubBiome ... subBiomes) {
            return SingleBuilder.configure("", baseBiome, subBiomes);
        }

        public static BiomeGroup configure(String groupName, int weight, Biome baseBiome, SubBiome ... subBiomes) {
            return new BiomeGroup(groupName, weight, baseBiome, subBiomes);
        }

        public static BiomeGroup configure(String groupName, Biome baseBiome, SubBiome ... subBiomes) {
            return new BiomeGroup(groupName, 10, baseBiome, subBiomes);
        }
    }

    public static class Builder {
        private ArrayList<BiomeGroup> groups = new ArrayList();

        public Builder add(int weight, Biome baseBiome, SubBiome ... subBiomes) {
            this.add("", weight, baseBiome, subBiomes);
            return this;
        }

        public Builder add(Biome baseBiome, SubBiome ... subBiomes) {
            this.add("", baseBiome, subBiomes);
            return this;
        }

        public Builder add(String groupName, int weight, Biome baseBiome, SubBiome ... subBiomes) {
            this.groups.add(new BiomeGroup(groupName, weight, baseBiome, subBiomes));
            return this;
        }

        public Builder add(String groupName, Biome baseBiome, SubBiome ... subBiomes) {
            this.groups.add(new BiomeGroup(groupName, 10, baseBiome, subBiomes));
            return this;
        }

        public BiomeGroup[] build() {
            return this.groups.toArray(new BiomeGroup[0]);
        }
    }
}

