/*
 * Decompiled with CFR 0.152.
 */
package com.matez.wildnature.world.generation.biome.setup.grid;

import com.matez.wildnature.init.WN;
import com.matez.wildnature.world.generation.biome.setup.grid.BiomeGroup;
import com.matez.wildnature.world.generation.biome.setup.grid.SubBiome;
import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;

public class BiomeTerrain {
    public static int ids = 0;
    public static ArrayList<BiomeTerrain> terrains = new ArrayList();
    private BiomeGroup group;
    private boolean canGuess;
    private BiomeDictionary.Type[] types;

    public static void register(BiomeGroup group, boolean canGuess, BiomeDictionary.Type ... types) {
        ArrayList<BiomeDictionary.Type> ovTypes = new ArrayList<BiomeDictionary.Type>(Arrays.asList(types));
        ovTypes.add(BiomeDictionary.Type.OVERWORLD);
        terrains.add(new BiomeTerrain(group, canGuess, ovTypes.toArray(new BiomeDictionary.Type[0])));
    }

    public static void register(BiomeGroup group, BiomeDictionary.Type ... types) {
        ArrayList<BiomeDictionary.Type> ovTypes = new ArrayList<BiomeDictionary.Type>(Arrays.asList(types));
        ovTypes.add(BiomeDictionary.Type.OVERWORLD);
        terrains.add(new BiomeTerrain(group, true, ovTypes.toArray(new BiomeDictionary.Type[0])));
    }

    public static void register(BiomeGroup group, boolean canGuess) {
        terrains.add(new BiomeTerrain(group, canGuess, BiomeDictionary.getTypes((Biome)group.getBaseBiome()).toArray(new BiomeDictionary.Type[0])));
    }

    public static void register(BiomeGroup group) {
        terrains.add(new BiomeTerrain(group, true, BiomeDictionary.getTypes((Biome)group.getBaseBiome()).toArray(new BiomeDictionary.Type[0])));
    }

    public static BiomeGroup getGroupByName(String name) {
        for (BiomeTerrain terrain : terrains) {
            if (!terrain.getGroup().getName().equals(name)) continue;
            return terrain.getGroup();
        }
        return null;
    }

    private BiomeTerrain(BiomeGroup group, boolean canGuess, BiomeDictionary.Type[] types) {
        this.group = group;
        this.canGuess = canGuess;
        this.types = types;
        if (types.length == 0) {
            WN.LOGGER.warn("No types registered for group " + group.toString());
        }
        BiomeDictionary.addTypes((Biome)group.getBaseBiome(), (BiomeDictionary.Type[])types);
        for (SubBiome subBiome : group.getSubBiomes()) {
            ArrayList<BiomeDictionary.Type> typesArraylist = new ArrayList<BiomeDictionary.Type>();
            typesArraylist.addAll(Arrays.asList(types));
            typesArraylist.addAll(Arrays.asList(subBiome.getAddionalTypes()));
            BiomeDictionary.addTypes((Biome)subBiome.getBiome(), (BiomeDictionary.Type[])typesArraylist.toArray(new BiomeDictionary.Type[0]));
            typesArraylist.clear();
        }
    }

    public static ArrayList<BiomeTerrain> getTerrains() {
        return terrains;
    }

    public BiomeGroup getGroup() {
        return this.group;
    }

    public BiomeDictionary.Type[] getTypes() {
        return this.types;
    }

    public boolean canGuess() {
        return this.canGuess;
    }
}

