/*
 * Decompiled with CFR 0.152.
 */
package com.matez.wildnature.world.generation.biome.setup.grid;

import com.matez.wildnature.util.config.CommonConfig;
import com.matez.wildnature.world.generation.biome.registry.WNBiomes;
import com.matez.wildnature.world.generation.biome.setup.grid.BiomeGroup;
import java.util.ArrayList;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;

public class IslandBiome {
    public static int RARITY_BIG = (Integer)CommonConfig.bigIslandRarity.get();
    public static int RARITY_SMALL = (Integer)CommonConfig.smallIslandRarity.get();
    private static ArrayList<IslandBiome> islandBiomes = new ArrayList();
    private BiomeGroup islandBiome;
    private IslandType type;
    private Biome[] oceans;
    private int weight;

    public static void register(BiomeGroup islandBiome, int weight, IslandType type, Biome[] oceans, BiomeDictionary.Type ... types) {
        islandBiomes.add(new IslandBiome(islandBiome, weight, type, oceans));
        WNBiomes.register(islandBiome, false, types);
    }

    public static void register(BiomeGroup islandBiome, int weight, Biome[] oceans, BiomeDictionary.Type ... types) {
        islandBiomes.add(new IslandBiome(islandBiome, weight, IslandType.BIG, oceans));
        islandBiomes.add(new IslandBiome(islandBiome, weight, IslandType.SMALL, oceans));
        WNBiomes.register(islandBiome, false, types);
    }

    public static ArrayList<IslandBiome> getIslandBiomes() {
        return islandBiomes;
    }

    private IslandBiome(BiomeGroup islandBiome, int weight, IslandType type, Biome ... oceans) {
        this.islandBiome = islandBiome;
        this.weight = weight;
        this.type = type;
        this.oceans = oceans;
    }

    public BiomeGroup getIslandBiome() {
        return this.islandBiome;
    }

    public Biome[] getOceans() {
        return this.oceans;
    }

    public IslandType getType() {
        return this.type;
    }

    public int getWeight() {
        return this.weight;
    }

    public static enum IslandType {
        SMALL,
        BIG;

    }
}

