/*
 * Decompiled with CFR 0.152.
 */
package com.matez.wildnature.world.generation.chunk.generation;

import com.matez.wildnature.util.config.CommonConfig;
import com.matez.wildnature.world.generation.biome.setup.BiomeVariants;
import com.matez.wildnature.world.generation.biome.setup.WNGenSettings;
import com.matez.wildnature.world.generation.chunk.WNWorldContext;
import com.matez.wildnature.world.generation.chunk.generation.ChunkArraySampler;
import com.matez.wildnature.world.generation.chunk.generation.landscape.ChunkLandscape;
import com.matez.wildnature.world.generation.chunk.generation.noise.NoiseProcessors;
import com.matez.wildnature.world.generation.generators.carves.PathGenerator;
import com.matez.wildnature.world.generation.generators.carves.UndergroundRiverGenerator;
import com.matez.wildnature.world.generation.generators.functions.interpolation.LerpConfiguration;
import com.matez.wildnature.world.generation.grid.Cell;
import com.matez.wildnature.world.generation.layer.ColumnBiomeContainer;
import com.matez.wildnature.world.generation.layer.SmoothColumnBiomeMagnifier;
import com.matez.wildnature.world.generation.layer.grid.GridBiomeLayer;
import com.matez.wildnature.world.generation.processors.TerrainProcessor;
import com.matez.wildnature.world.generation.processors.ThermalErosionProcessor;
import com.matez.wildnature.world.generation.processors.ThermalErosionTestProcessor;
import com.matez.wildnature.world.generation.provider.WNGridBiomeProvider;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.objects.Object2DoubleMap;
import it.unimi.dsi.fastutil.objects.Object2DoubleOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.HashMap;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.ReportedException;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.registry.Registry;
import net.minecraft.village.VillageSiege;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeContainer;
import net.minecraft.world.biome.BiomeManager;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.PerlinNoiseGenerator;
import net.minecraft.world.gen.WorldGenRegion;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.jigsaw.JigsawJunction;
import net.minecraft.world.gen.feature.jigsaw.JigsawPattern;
import net.minecraft.world.gen.feature.structure.AbstractVillagePiece;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.minecraft.world.gen.feature.template.TemplateManager;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.spawner.CatSpawner;
import net.minecraft.world.spawner.PatrolSpawner;
import net.minecraft.world.spawner.PhantomSpawner;
import net.minecraft.world.spawner.WorldEntitySpawner;

public class WNSimplexChunkGenerator
extends ChunkGenerator<WNGenSettings> {
    private static final float[] field_222561_h = (float[])Util.func_200696_a((Object)new float[13824], p_222557_0_ -> {
        for (int i = 0; i < 24; ++i) {
            for (int j = 0; j < 24; ++j) {
                for (int k = 0; k < 24; ++k) {
                    p_222557_0_[i * 24 * 24 + j * 24 + k] = (float)WNSimplexChunkGenerator.func_222554_b(j - 12, k - 12, i - 12);
                }
            }
        }
    });
    private int threadCount = (Integer)CommonConfig.generatorThreads.get();
    private static final BlockState AIR = Blocks.field_150350_a.func_176223_P();
    protected IChunk chunk = null;
    private WNGenSettings settings;
    private final int verticalNoiseResolution;
    private final int horizontalNoiseResolution;
    private final int noiseSizeX;
    private final int noiseSizeY;
    private final int noiseSizeZ;
    private final PerlinNoiseGenerator surfaceDepthNoise;
    private final PhantomSpawner phantomSpawner = new PhantomSpawner();
    private final PatrolSpawner patrolSpawner = new PatrolSpawner();
    private final CatSpawner catSpawner = new CatSpawner();
    private final VillageSiege siegeSpawner = new VillageSiege();
    protected HashMap<Long, int[]> noiseCache = new HashMap();
    private static TerrainProcessor thermalErosionProcessor = new ThermalErosionProcessor();
    private static TerrainProcessor thermalErosionTestProcessor = new ThermalErosionTestProcessor();
    private SharedSeedRandom randomSeed;
    private WNWorldContext context;
    private final PathGenerator pathGenerator;
    private final UndergroundRiverGenerator undergroundRiverGenerator;
    private final WNGridBiomeProvider gridProvider;

    public WNSimplexChunkGenerator(IWorld worldIn, BiomeProvider biomeProviderIn, WNGenSettings generationSettingsIn) {
        super(worldIn, biomeProviderIn, (GenerationSettings)generationSettingsIn);
        this.settings = generationSettingsIn;
        this.randomSeed = new SharedSeedRandom(this.field_222541_b);
        this.gridProvider = biomeProviderIn instanceof WNGridBiomeProvider ? (WNGridBiomeProvider)biomeProviderIn : null;
        this.verticalNoiseResolution = 8;
        this.horizontalNoiseResolution = 4;
        this.noiseSizeX = 16 / this.horizontalNoiseResolution;
        this.noiseSizeY = 256 / this.verticalNoiseResolution;
        this.noiseSizeZ = 16 / this.horizontalNoiseResolution;
        this.surfaceDepthNoise = new PerlinNoiseGenerator(this.randomSeed, 3, 0);
        this.pathGenerator = new PathGenerator(worldIn);
        this.undergroundRiverGenerator = new UndergroundRiverGenerator(worldIn);
        thermalErosionProcessor.init(this, this.field_222541_b);
        thermalErosionTestProcessor.init(this, this.field_222541_b);
        NoiseProcessors.init(this.func_202089_c(), (Random)this.randomSeed, ChunkLandscape.octaves);
    }

    public WNWorldContext getContext() {
        return this.context;
    }

    public WNGridBiomeProvider getGridProvider() {
        return this.gridProvider;
    }

    public void setContext(WNWorldContext context) {
        this.context = context;
    }

    public void func_222539_a(IChunk chunkIn) {
        ((ChunkPrimer)chunkIn).func_225548_a_((BiomeContainer)new ColumnBiomeContainer(chunkIn.func_76632_l(), this.field_222542_c));
    }

    public void func_225551_a_(WorldGenRegion worldGenRegion, IChunk chunkIn) {
        ChunkPos chunkpos = chunkIn.func_76632_l();
        int i = chunkpos.field_77276_a;
        int j = chunkpos.field_77275_b;
        SharedSeedRandom sharedseedrandom = new SharedSeedRandom();
        sharedseedrandom.func_202422_a(i, j);
        int xChunkPos = chunkpos.func_180334_c();
        int zChunkPos = chunkpos.func_180333_d();
        BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
        for (int relativeX = 0; relativeX < 16; ++relativeX) {
            for (int relativeZ = 0; relativeZ < 16; ++relativeZ) {
                int x = xChunkPos + relativeX;
                int z = zChunkPos + relativeZ;
                int startHeight = chunkIn.func_201576_a(Heightmap.Type.WORLD_SURFACE_WG, relativeX, relativeZ) + 1;
                double noise = this.surfaceDepthNoise.func_215460_a((double)x * 0.0625, (double)z * 0.0625, 0.0625, (double)startHeight * 0.0625) * 15.0;
                Biome biome = worldGenRegion.func_226691_t_((BlockPos)blockpos$mutable.func_181079_c(x, startHeight, z));
                Cell cell = this.gridProvider.getNoiseCell(x, z);
                biome = GridBiomeLayer.applyHeightmapBiome(biome, (BlockPos)blockpos$mutable, (IWorld)worldGenRegion, 1);
                biome.func_206854_a((Random)sharedseedrandom, chunkIn, x, z, startHeight, noise, ((WNGenSettings)this.func_201496_a_()).func_205532_l(), ((WNGenSettings)this.func_201496_a_()).func_205533_m(), this.func_222530_f(), this.field_222540_a.func_72905_C());
                this.pathGenerator.generate(x, startHeight, z, biome, chunkIn);
                this.undergroundRiverGenerator.generate(x, startHeight, z, cell, biome, chunkIn);
                cell = null;
            }
        }
        this.makeBedrock(chunkIn, (Random)sharedseedrandom);
    }

    public void func_202092_b(WorldGenRegion region) {
        int i = region.func_201679_a();
        int j = region.func_201680_b();
        int k = i * 16;
        int l = j * 16;
        BlockPos blockpos = new BlockPos(k, 0, l);
        Biome biome = this.func_225552_a_(region.func_225523_d_(), blockpos.func_177982_a(8, 8, 8));
        biome = GridBiomeLayer.applyHeightmapBiome(biome, blockpos, (IWorld)region, 16);
        SharedSeedRandom sharedseedrandom = new SharedSeedRandom();
        long i1 = sharedseedrandom.func_202424_a(region.func_72905_C(), k, l);
        for (GenerationStage.Decoration generationstage$decoration : GenerationStage.Decoration.values()) {
            try {
                biome.func_203608_a(generationstage$decoration, (ChunkGenerator)this, (IWorld)region, i1, sharedseedrandom, blockpos);
            }
            catch (Exception exception) {
                CrashReport crashreport = CrashReport.func_85055_a((Throwable)exception, (String)"Biome decoration");
                crashreport.func_85058_a("Generation").func_71507_a("CenterX", (Object)i).func_71507_a("CenterZ", (Object)j).func_71507_a("Step", (Object)generationstage$decoration).func_71507_a("Seed", (Object)i1).func_71507_a("Biome", (Object)Registry.field_212624_m.func_177774_c((Object)biome));
                throw new ReportedException(crashreport);
            }
        }
    }

    public void func_227058_a_(BiomeManager p_227058_1_, IChunk chunk, ChunkGenerator<?> p_227058_3_, TemplateManager p_227058_4_) {
        for (Structure structure : Feature.field_202300_at.values()) {
            if (!p_227058_3_.func_202090_b().func_205004_a(structure)) continue;
            StructureStart structurestart = chunk.func_201585_a(structure.func_143025_a());
            int i = structurestart != null ? structurestart.func_227457_j_() : 0;
            SharedSeedRandom sharedseedrandom = new SharedSeedRandom();
            ChunkPos chunkpos = chunk.func_76632_l();
            StructureStart structurestart1 = StructureStart.field_214630_a;
            BlockPos biomePos = new BlockPos(chunkpos.func_180334_c() + 9, 0, chunkpos.func_180333_d() + 9);
            Biome biome = p_227058_1_.func_226836_a_(biomePos);
            if (structure.func_225558_a_(p_227058_1_, p_227058_3_, (Random)sharedseedrandom, chunkpos.field_77276_a, chunkpos.field_77275_b, biome)) {
                StructureStart structurestart2 = structure.func_214557_a().create(structure, chunkpos.field_77276_a, chunkpos.field_77275_b, MutableBoundingBox.func_78887_a(), i, p_227058_3_.func_202089_c());
                structurestart2.func_214625_a((ChunkGenerator)this, p_227058_4_, chunkpos.field_77276_a, chunkpos.field_77275_b, biome);
                structurestart1 = structurestart2.func_75069_d() ? structurestart2 : StructureStart.field_214630_a;
            }
            chunk.func_201584_a(structure.func_143025_a(), structurestart1);
        }
    }

    protected void makeBedrock(IChunk chunkIn, Random rand) {
        BlockPos.Mutable blockpos$mutableblockpos = new BlockPos.Mutable();
        int i = chunkIn.func_76632_l().func_180334_c();
        int j = chunkIn.func_76632_l().func_180333_d();
        WNGenSettings t = (WNGenSettings)this.func_201496_a_();
        int k = t.func_214968_u();
        int l = t.func_214967_t();
        for (BlockPos blockpos : BlockPos.func_191531_b((int)i, (int)0, (int)j, (int)(i + 15), (int)0, (int)(j + 15))) {
            if (l > 0) {
                for (int i1 = l; i1 >= l - 4; --i1) {
                    if (i1 < l - rand.nextInt(5)) continue;
                    chunkIn.func_177436_a((BlockPos)blockpos$mutableblockpos.func_181079_c(blockpos.func_177958_n(), i1, blockpos.func_177952_p()), Blocks.field_150357_h.func_176223_P(), false);
                }
            }
            if (k >= 256) continue;
            for (int j1 = k + 4; j1 >= k; --j1) {
                if (j1 > k + rand.nextInt(5)) continue;
                chunkIn.func_177436_a((BlockPos)blockpos$mutableblockpos.func_181079_c(blockpos.func_177958_n(), j1, blockpos.func_177952_p()), Blocks.field_150357_h.func_176223_P(), false);
            }
        }
    }

    public int func_205470_d() {
        return this.func_222530_f() + 1;
    }

    public void func_222537_b(IWorld worldIn, IChunk chunkIn) {
        this.chunk = chunkIn;
        ObjectArrayList structurePieces = new ObjectArrayList(10);
        ObjectArrayList jigsaws = new ObjectArrayList(32);
        ChunkPos chunkpos = chunkIn.func_76632_l();
        int chunkX = chunkpos.field_77276_a;
        int chunkZ = chunkpos.field_77275_b;
        int chunkStartX = chunkX << 4;
        int chunkStartZ = chunkZ << 4;
        for (Structure structure : Feature.field_214488_aQ) {
            String s = structure.func_143025_a();
            LongIterator longiterator = chunkIn.func_201578_b(s).iterator();
            while (longiterator.hasNext()) {
                long j1 = longiterator.nextLong();
                ChunkPos chunkpos1 = new ChunkPos(j1);
                IChunk ichunk = worldIn.func_212866_a_(chunkpos1.field_77276_a, chunkpos1.field_77275_b);
                StructureStart structurestart = ichunk.func_201585_a(s);
                if (structurestart == null || !structurestart.func_75069_d()) continue;
                for (StructurePiece structurepiece : structurestart.func_186161_c()) {
                    if (!structurepiece.func_214810_a(chunkpos, 12) || !(structurepiece instanceof AbstractVillagePiece)) continue;
                    AbstractVillagePiece abstractvillagepiece = (AbstractVillagePiece)structurepiece;
                    JigsawPattern.PlacementBehaviour jigsawpattern$placementbehaviour = abstractvillagepiece.func_214826_b().func_214854_c();
                    if (jigsawpattern$placementbehaviour == JigsawPattern.PlacementBehaviour.RIGID) {
                        structurePieces.add((Object)abstractvillagepiece);
                    }
                    for (JigsawJunction jigsawjunction : abstractvillagepiece.func_214829_e()) {
                        int k1 = jigsawjunction.func_214895_a();
                        int l1 = jigsawjunction.func_214893_c();
                        if (k1 <= chunkStartX - 12 || l1 <= chunkStartZ - 12 || k1 >= chunkStartX + 15 + 12 || l1 >= chunkStartZ + 15 + 12) continue;
                        jigsaws.add((Object)jigsawjunction);
                    }
                }
            }
        }
        int[] heights = this.getHeightsInChunk(chunkpos, worldIn);
        this.generateTerrain(worldIn, chunkIn, heights);
        BlockPos.Mutable mutable = new BlockPos.Mutable();
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                mutable.func_181079_c(x, 0, z);
                int rX = chunkStartX + x;
                int rZ = chunkStartZ + z;
                int height = heights[x * 16 + z];
                for (AbstractVillagePiece piece : structurePieces) {
                    int structureY;
                    MutableBoundingBox boundingBox = piece.func_74874_b();
                    int minX = boundingBox.field_78897_a - 1;
                    int minZ = boundingBox.field_78896_c - 1;
                    int maxX = boundingBox.field_78893_d + 1;
                    int maxZ = boundingBox.field_78892_f + 1;
                    if (rX < minX || rX > maxX || rZ < minZ || rZ > maxZ || (structureY = boundingBox.field_78895_b) <= height) continue;
                    int minXDist = rX - minX;
                    int minZDist = rZ - minZ;
                    int maxXDist = maxX - rX;
                    int maxZDist = maxZ - rZ;
                    int xDist = Math.min(minXDist, maxXDist);
                    int zDist = Math.min(minZDist, maxZDist);
                    int dist = Math.min(xDist, zDist);
                    for (int l = structureY; l > structureY - dist; --l) {
                        mutable.func_185336_p(l - 1);
                        this.chunk.func_177436_a((BlockPos)mutable, this.settings.func_205532_l(), false);
                    }
                }
            }
        }
    }

    public void generateTerrain(IWorld world, IChunk chunk, int[] noise) {
        BlockPos.Mutable mutable = new BlockPos.Mutable();
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                mutable.func_181079_c(x, 0, z);
                int height = noise[x * 16 + z];
                for (int y = 0; y < 256; ++y) {
                    mutable.func_185336_p(y);
                    if (y > height) {
                        if (y >= this.func_222530_f()) continue;
                        chunk.func_177436_a((BlockPos)mutable, this.settings.func_205533_m(), false);
                        continue;
                    }
                    chunk.func_177436_a((BlockPos)mutable, this.settings.func_205532_l(), false);
                }
            }
        }
    }

    protected void erode(IWorld world, IChunk chunk, int[] noise) {
        int i;
        int threads = 8;
        CompletableFuture[] futures = new CompletableFuture[threads];
        for (i = 0; i < threads; ++i) {
            int position = i;
            futures[i] = CompletableFuture.runAsync(() -> this.runErosion(world, chunk, position * 16 / threads, 16 / threads, noise));
        }
        for (i = 0; i < futures.length; ++i) {
            futures[i].join();
        }
    }

    private void runErosion(IWorld world, IChunk chunk, int start, int size, int[] noise) {
        for (int x = start; x < start + size; ++x) {
            for (int z = 0; z < 16; ++z) {
                thermalErosionTestProcessor.process(world, chunk, new Random(this.field_222541_b), chunk.func_76632_l().field_77276_a, chunk.func_76632_l().field_77275_b, x, z, noise);
            }
        }
    }

    protected int[] getHeightsInChunk(ChunkPos pos, IWorld worldIn) {
        int i;
        int[] res = this.noiseCache.get(pos.func_201841_a());
        if (res != null) {
            return res;
        }
        int[] vals = new int[256];
        int threads = this.threadCount;
        CompletableFuture[] futures = new CompletableFuture[threads];
        for (i = 0; i < threads; ++i) {
            int position = i;
            futures[i] = CompletableFuture.runAsync(() -> this.useNoise(vals, pos, position * 16 / threads, 16 / threads, worldIn));
        }
        for (i = 0; i < futures.length; ++i) {
            futures[i].join();
        }
        this.noiseCache.put(pos.func_201841_a(), vals);
        return vals;
    }

    public void useNoise(int[] noise, ChunkPos pos, int start, int size, IWorld worldIn) {
        Object2DoubleOpenHashMap weightMap16 = new Object2DoubleOpenHashMap(4);
        Object2DoubleOpenHashMap weightMap4 = new Object2DoubleOpenHashMap(2);
        Object2DoubleOpenHashMap weightMap1 = new Object2DoubleOpenHashMap();
        ChunkArraySampler.CoordinateAccessor<LerpConfiguration> biomeAccessor = (x, z) -> {
            Biome biome = SmoothColumnBiomeMagnifier.SMOOTH.getBiome(worldIn.func_72905_C(), pos.field_77276_a * 16 + x, 0, pos.field_77275_b * 16 + z, this.gridProvider, true);
            return LerpConfiguration.get(biome);
        };
        LerpConfiguration[] sampledBiomes16 = ChunkArraySampler.fillSampledArray(new LerpConfiguration[100], biomeAccessor, 4);
        LerpConfiguration[] sampledBiomes4 = ChunkArraySampler.fillSampledArray(new LerpConfiguration[169], biomeAccessor, 2);
        LerpConfiguration[] sampledBiomes1 = ChunkArraySampler.fillSampledArray(new LerpConfiguration[576], biomeAccessor);
        for (int x2 = start; x2 < start + size; ++x2) {
            for (int z2 = 0; z2 < 16; ++z2) {
                ChunkArraySampler.fillSampledWeightMap(sampledBiomes16, weightMap16, 4, x2, z2);
                ChunkArraySampler.fillSampledWeightMap(sampledBiomes4, weightMap4, 2, x2, z2);
                ChunkArraySampler.fillSampledWeightMap(sampledBiomes1, weightMap1, x2, z2);
                Function<LerpConfiguration, BiomeVariants> variantAccessor = LerpConfiguration::getBiomeVariants;
                ChunkArraySampler.reduceGroupedWeightMap(weightMap4, weightMap16, variantAccessor.andThen(BiomeVariants::getLargeGroup), BiomeVariants.LargeGroup.SIZE);
                ChunkArraySampler.reduceGroupedWeightMap(weightMap1, weightMap4, variantAccessor.andThen(BiomeVariants::getSmallGroup), BiomeVariants.SmallGroup.SIZE);
                noise[x2 * 16 + z2] = this.getTerrainHeight(pos.field_77276_a * 16 + x2, pos.field_77275_b * 16 + z2, (Object2DoubleMap<LerpConfiguration>)weightMap1, variantAccessor);
            }
        }
    }

    public int getTerrainHeight(int x, int z, Object2DoubleMap<LerpConfiguration> weightMap1, Function<LerpConfiguration, BiomeVariants> variantAccessor) {
        Cell cell = this.gridProvider.getNoiseCell(x >> 2, z >> 2);
        Biome biome = this.gridProvider.getNoiseBiome(cell, x >> 2, 1, z >> 2, true);
        ChunkLandscape chunkLandscape = ChunkLandscape.getOrCreate(x, z, this.field_222541_b, this.func_222530_f(), biome, this.chunk);
        int height = (int)chunkLandscape.generateHeightmap(this.field_222542_c, weightMap1, variantAccessor);
        cell = null;
        return height;
    }

    public int func_222529_a(int blockX, int blockZ, Heightmap.Type heightmap) {
        int chunkX = blockX >> 4;
        int chunkZ = blockZ >> 4;
        Object2DoubleOpenHashMap weightMap16 = new Object2DoubleOpenHashMap(4);
        Object2DoubleOpenHashMap weightMap4 = new Object2DoubleOpenHashMap(2);
        Object2DoubleOpenHashMap weightMap1 = new Object2DoubleOpenHashMap();
        ChunkArraySampler.CoordinateAccessor<LerpConfiguration> biomeAccessor = (x, z) -> {
            Biome biome = SmoothColumnBiomeMagnifier.SMOOTH.getBiome(this.field_222541_b, chunkX * 16 + x, 0, chunkZ * 16 + z, this.gridProvider, true);
            return LerpConfiguration.get(biome);
        };
        LerpConfiguration[] sampledBiomes16 = ChunkArraySampler.fillSampledArray(new LerpConfiguration[100], biomeAccessor, 4);
        LerpConfiguration[] sampledBiomes4 = ChunkArraySampler.fillSampledArray(new LerpConfiguration[169], biomeAccessor, 2);
        LerpConfiguration[] sampledBiomes1 = ChunkArraySampler.fillSampledArray(new LerpConfiguration[576], biomeAccessor);
        for (int x2 = 0; x2 < 16; ++x2) {
            for (int z2 = 0; z2 < 16; ++z2) {
                if (chunkX * 16 + x2 != blockX || chunkZ * 16 + z2 != blockZ) continue;
                ChunkArraySampler.fillSampledWeightMap(sampledBiomes16, weightMap16, 4, x2, z2);
                ChunkArraySampler.fillSampledWeightMap(sampledBiomes4, weightMap4, 2, x2, z2);
                ChunkArraySampler.fillSampledWeightMap(sampledBiomes1, weightMap1, x2, z2);
                Function<LerpConfiguration, BiomeVariants> variantAccessor = LerpConfiguration::getBiomeVariants;
                ChunkArraySampler.reduceGroupedWeightMap(weightMap4, weightMap16, variantAccessor.andThen(BiomeVariants::getLargeGroup), BiomeVariants.LargeGroup.SIZE);
                ChunkArraySampler.reduceGroupedWeightMap(weightMap1, weightMap4, variantAccessor.andThen(BiomeVariants::getSmallGroup), BiomeVariants.SmallGroup.SIZE);
                int height = this.getTerrainHeight(chunkX * 16 + x2, chunkZ * 16 + z2, (Object2DoubleMap<LerpConfiguration>)weightMap1, variantAccessor) + 1;
                if (height <= this.func_222530_f()) {
                    return this.func_222530_f();
                }
                return height;
            }
        }
        return this.func_222530_f();
    }

    public void func_202093_c(WorldGenRegion region) {
        int i = region.func_201679_a();
        int j = region.func_201680_b();
        Biome biome = region.func_226691_t_(new ChunkPos(i, j).func_206849_h());
        SharedSeedRandom sharedseedrandom = new SharedSeedRandom();
        sharedseedrandom.func_202424_a(region.func_72905_C(), i << 4, j << 4);
        WorldEntitySpawner.func_77191_a((IWorld)region, (Biome)biome, (int)i, (int)j, (Random)sharedseedrandom);
    }

    public void func_203222_a(ServerWorld worldIn, boolean spawnHostileMobs, boolean spawnPeacefulMobs) {
        this.phantomSpawner.func_203232_a(worldIn, spawnHostileMobs, spawnPeacefulMobs);
        this.patrolSpawner.func_222696_a(worldIn, spawnHostileMobs, spawnPeacefulMobs);
        this.catSpawner.func_221124_a(worldIn, spawnHostileMobs, spawnPeacefulMobs);
        this.siegeSpawner.func_225477_a(worldIn, spawnHostileMobs, spawnPeacefulMobs);
    }

    private static double func_222556_a(int p_222556_0_, int p_222556_1_, int p_222556_2_) {
        int i = p_222556_0_ + 12;
        int j = p_222556_1_ + 12;
        int k = p_222556_2_ + 12;
        if (i >= 0 && i < 24) {
            if (j >= 0 && j < 24) {
                return k >= 0 && k < 24 ? (double)field_222561_h[k * 24 * 24 + i * 24 + j] : 0.0;
            }
            return 0.0;
        }
        return 0.0;
    }

    private static double func_222554_b(int p_222554_0_, int p_222554_1_, int p_222554_2_) {
        double d0 = p_222554_0_ * p_222554_0_ + p_222554_2_ * p_222554_2_;
        double d1 = (double)p_222554_1_ + 0.5;
        double d2 = d1 * d1;
        double d3 = Math.pow(Math.E, -(d2 / 16.0 + d0 / 16.0));
        double d4 = -d1 * MathHelper.func_181161_i((double)(d2 / 2.0 + d0 / 2.0)) / 2.0;
        return d4 * d3;
    }
}

