/*
 * Decompiled with CFR 0.152.
 */
package com.matez.wildnature.world.generation.chunk.generation.landscape;

import com.matez.wildnature.util.other.Utilities;
import com.matez.wildnature.world.generation.biome.setup.BiomeVariants;
import com.matez.wildnature.world.generation.chunk.generation.noise.NoiseProcessor;
import com.matez.wildnature.world.generation.chunk.generation.noise.NoiseProcessors;
import com.matez.wildnature.world.generation.generators.functions.interpolation.BiomeBlender;
import com.matez.wildnature.world.generation.generators.functions.interpolation.LerpConfiguration;
import com.matez.wildnature.world.generation.grid.Cell;
import com.matez.wildnature.world.generation.noise.fastNoise.FastNoise;
import it.unimi.dsi.fastutil.objects.Object2DoubleMap;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.chunk.IChunk;

public class ChunkLandscape {
    public static HashMap<String, Class<? extends ChunkLandscape>> landscapeCache = new HashMap();
    protected int x;
    protected int z;
    public IChunk chunk;
    public Biome biome;
    public Random random;
    protected float depth;
    protected float scale;
    public static int octaves = 11;
    public long seed;
    public int sealevel;
    protected ArrayList<NoiseProcessor> noiseProcessors = new ArrayList();
    protected ArrayList<NoiseProcessor> validNoiseProcessors = new ArrayList();
    private final FastNoise worldLimitNoise;

    public ChunkLandscape(int x, int z, long seed, int sealevel, Biome biome, IChunk chunkIn) {
        this.x = x;
        this.z = z;
        this.biome = biome;
        this.chunk = chunkIn;
        this.depth = biome.func_185355_j();
        this.scale = biome.func_185360_m();
        this.random = new Random(seed);
        this.seed = seed;
        this.sealevel = sealevel;
        this.worldLimitNoise = new FastNoise((int)seed);
        this.worldLimitNoise.SetFrequency(0.005f);
        this.addNoiseProcessor(NoiseProcessors.SCALE);
        this.initNoiseProcessors();
    }

    public static void addLandscape(Biome biome, Class<? extends ChunkLandscape> landscape) {
        landscapeCache.put(biome.getRegistryName().func_110623_a(), landscape);
    }

    public void addNoiseProcessor(NoiseProcessor processor) {
        this.noiseProcessors.add(processor);
    }

    public void initNoiseProcessors() {
        for (NoiseProcessor noiseProcessor : this.noiseProcessors) {
            if (!noiseProcessor.canProcess(this.biome)) continue;
            this.validNoiseProcessors.add(noiseProcessor);
        }
    }

    private double sigmoid(double noise) {
        return 256.0 / (Math.exp(2.6666667461395264 - noise / 48.0) + 1.0);
    }

    public double generateHeightmap(BiomeProvider biomeProvider, Object2DoubleMap<LerpConfiguration> weightMap1, Function<LerpConfiguration, BiomeVariants> variantAccessor) {
        return this.sigmoid(this.sampleArea(this.x, this.z, biomeProvider, weightMap1, variantAccessor));
    }

    private double sampleArea(int x, int z, BiomeProvider biomeProvider, Object2DoubleMap<LerpConfiguration> weightMap1, Function<LerpConfiguration, BiomeVariants> variantAccessor) {
        double[] output = BiomeBlender.smoothLerp(x, z, this, weightMap1, variantAccessor);
        double height = output[0];
        double scale = output[1];
        double noise = this.sampleNoise(x, z, height, scale, true);
        noise += this.sampleNoise(x + 4, z, height, scale, false);
        noise += this.sampleNoise(x - 4, z, height, scale, false);
        noise += this.sampleNoise(x, z + 4, height, scale, false);
        noise += this.sampleNoise(x, z - 4, height, scale, false);
        noise *= 0.2;
        if ((noise += height) > 230.0) {
            int limitNoise = Math.round(Utilities.scaleBetween(this.worldLimitNoise.GetSimplex(x, z), -5.0f, 5.0f, -1.0f, 1.0f));
            return 230 + limitNoise;
        }
        if (noise < 25.0) {
            int limitNoise = Math.round(Utilities.scaleBetween(this.worldLimitNoise.GetSimplex(x, z), -5.0f, 5.0f, -1.0f, 1.0f));
            return 25 + limitNoise;
        }
        return noise;
    }

    public double sampleNoise(int x, int z, double height, double scale, boolean rawCoords) {
        double output = 0.0;
        double d = 0.0;
        double factor = 0.0;
        for (NoiseProcessor noiseProcessor : this.validNoiseProcessors) {
            double noise = noiseProcessor.getProcessedNoise(x, z, this.biome, height, scale, rawCoords);
            if (noiseProcessor.smoothedOnBorders()) {
                output += noise * factor;
                d += factor;
                continue;
            }
            output += noise;
            d += 1.0;
        }
        if (d == 0.0) {
            return output;
        }
        return output / d;
    }

    public ArrayList<NoiseProcessor> getValidNoiseProcessors() {
        return this.validNoiseProcessors;
    }

    public ChunkLandscape applyValues(Cell cell, int x, int z, Long seed, int sealevel, Biome biome, IChunk chunkIn) {
        this.x = x;
        this.z = z;
        this.random.setSeed(seed);
        this.sealevel = sealevel;
        this.biome = biome;
        this.chunk = chunkIn;
        return this;
    }

    public static ChunkLandscape getOrCreate(int x, int z, long seed, int sealevel, Biome biome, IChunk chunkIn) {
        Class<? extends ChunkLandscape> landscape = landscapeCache.get(biome.getRegistryName().func_110623_a());
        if (landscape != null) {
            try {
                return landscape.getDeclaredConstructor(Integer.TYPE, Integer.TYPE, Long.TYPE, Integer.TYPE, Biome.class, IChunk.class).newInstance(x, z, seed, sealevel, biome, chunkIn);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        return new ChunkLandscape(x, z, seed, sealevel, biome, chunkIn);
    }
}

