/*
 * Decompiled with CFR 0.152.
 */
package com.matez.wildnature.world.generation.chunk.generation.noise;

import com.matez.wildnature.world.generation.chunk.generation.noise.NoiseProcessor;
import com.matez.wildnature.world.generation.noise.OctaveNoiseSampler;
import com.matez.wildnature.world.generation.noise.OpenSimplexNoise;
import java.util.Random;
import net.minecraft.world.biome.Biome;

public class ScaleNoiseProcessor
extends NoiseProcessor {
    protected OctaveNoiseSampler<OpenSimplexNoise> heightNoise;
    protected OctaveNoiseSampler<OpenSimplexNoise> scaleNoise;
    protected int octaves;

    @Override
    public void init(long seed, Random random, int octaves) {
        this.octaves = octaves;
        double amplitude = Math.pow(2.0, octaves);
        this.heightNoise = new OctaveNoiseSampler<OpenSimplexNoise>(OpenSimplexNoise.class, random, this.octaves, 0.75 * amplitude, amplitude, amplitude);
        this.scaleNoise = new OctaveNoiseSampler<OpenSimplexNoise>(OpenSimplexNoise.class, random, 2, Math.pow(2.0, 10.0), 0.2, 0.09);
    }

    @Override
    public boolean smoothedOnBorders() {
        return false;
    }

    @Override
    public double processNoise(int x, int z, Biome biome, double height, double scale, boolean rawNoise) {
        double frequency = this.scaleNoise.sampleCustom(x, z, 1.0, -scale, scale, 2);
        double noise = this.heightNoise.sampleCustom(x, z, 1.0, frequency, frequency, this.octaves);
        return noise;
    }
}

