/*
 * Decompiled with CFR 0.152.
 */
package com.matez.wildnature.world.generation.feature.features;

import com.matez.wildnature.util.lists.WNBlocks;
import com.matez.wildnature.util.other.Utilities;
import com.matez.wildnature.world.generation.provider.WNGridBiomeProvider;
import com.matez.wildnature.world.generation.provider.WNWorldType;
import com.mojang.datafixers.Dynamic;
import java.util.ArrayList;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.fluid.Fluids;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.placement.CountConfig;

public class RiverLilyFeature
extends Feature<CountConfig> {
    public RiverLilyFeature(Function<Dynamic<?>, ? extends CountConfig> p_i49915_1_) {
        super(p_i49915_1_);
        this.setRegistryName("wildnature", "river_lily_feature");
    }

    public boolean place(IWorld worldIn, ChunkGenerator<? extends GenerationSettings> generator, Random rand, BlockPos pos, CountConfig config) {
        if (!worldIn.func_201675_m().func_76569_d()) {
            return false;
        }
        if (WNWorldType.generator == null) {
            return false;
        }
        WNGridBiomeProvider provider = WNWorldType.generator.getGridProvider();
        if (provider == null) {
            return false;
        }
        if (worldIn.func_204610_c(pos).func_206886_c() != Fluids.field_204541_a) {
            return false;
        }
        int xzDiff = 8;
        int yDiff = 5;
        BlockPos startPos = null;
        Direction riverSideDirection = null;
        for (int i = 0; i < config.field_204915_a; ++i) {
            BlockPos blockpos = pos.func_177982_a(rand.nextInt(xzDiff) - rand.nextInt(xzDiff), rand.nextInt(yDiff) - rand.nextInt(yDiff), rand.nextInt(xzDiff) - rand.nextInt(xzDiff));
            if (worldIn.func_175623_d(blockpos) && worldIn.func_180495_p(blockpos.func_177977_b()).func_200132_m()) {
                for (int j = 0; j < 4; ++j) {
                    Direction direction = Direction.func_176731_b((int)j);
                    if (worldIn.func_180495_p(blockpos.func_177977_b().func_177967_a(direction, 3)).func_204520_s().func_206886_c() != Fluids.field_204546_a) continue;
                    startPos = blockpos.func_177977_b().func_177967_a(direction, 2);
                    riverSideDirection = direction;
                    break;
                }
            }
            if (riverSideDirection != null) break;
        }
        int rockMinDistance = 0;
        int rockMaxDistance = 3;
        if (riverSideDirection != null) {
            ArrayList<Direction> allowedDirections = new ArrayList<Direction>();
            allowedDirections.add(Direction.NORTH);
            allowedDirections.add(Direction.SOUTH);
            allowedDirections.add(Direction.EAST);
            allowedDirections.add(Direction.WEST);
            allowedDirections.remove(riverSideDirection);
            allowedDirections.remove(riverSideDirection.func_176734_d());
            BlockPos.Mutable mutable = new BlockPos.Mutable(startPos);
            for (int i = 0; i < 100; ++i) {
                BlockPos.Mutable blockMutable = new BlockPos.Mutable((BlockPos)mutable);
                BlockState state = Utilities.rint(0, 2) == 0 ? WNBlocks.GREEN_WATERLILY.func_176223_P() : Blocks.field_196651_dG.func_176223_P();
                for (int j = 0; j < Utilities.rint(0, 5, rand); ++j) {
                    blockMutable.func_189534_c((Direction)allowedDirections.get(Utilities.rint(0, allowedDirections.size() - 1)), Utilities.rint(rockMinDistance, rockMaxDistance, rand));
                    worldIn.func_180501_a(blockMutable.func_177984_a(), state, 2);
                }
                mutable.func_189534_c(riverSideDirection, Utilities.rint(1, 3, rand));
                try {
                    if (!worldIn.func_201672_e().func_217354_b(mutable.func_177958_n() / 4, mutable.func_177952_p() / 4)) break;
                    if (worldIn.func_204610_c(mutable.func_177977_b()).func_206886_c() == Fluids.field_204546_a) continue;
                }
                catch (RuntimeException e) {}
                break;
            }
            return true;
        }
        return false;
    }
}

