/*
 * Decompiled with CFR 0.152.
 */
package com.matez.wildnature.world.generation.feature.features;

import com.matez.wildnature.util.lists.WNBlocks;
import com.matez.wildnature.util.other.Utilities;
import com.matez.wildnature.world.generation.provider.WNGridBiomeProvider;
import com.matez.wildnature.world.generation.provider.WNWorldType;
import com.mojang.datafixers.Dynamic;
import java.util.ArrayList;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SlabBlock;
import net.minecraft.fluid.Fluids;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.SlabType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.placement.CountConfig;

public class RiverRockFeature
extends Feature<CountConfig> {
    public static ArrayList<RockConfiguration> configurations = new ArrayList();

    public RiverRockFeature(Function<Dynamic<?>, ? extends CountConfig> p_i49915_1_) {
        super(p_i49915_1_);
        this.setRegistryName("wildnature", "river_rock_feature");
    }

    public boolean place(IWorld worldIn, ChunkGenerator<? extends GenerationSettings> generator, Random rand, BlockPos pos, CountConfig config) {
        if (!worldIn.func_201675_m().func_76569_d()) {
            return false;
        }
        if (WNWorldType.generator == null) {
            return false;
        }
        WNGridBiomeProvider provider = WNWorldType.generator.getGridProvider();
        if (provider == null) {
            return false;
        }
        if (worldIn.func_204610_c(pos).func_206886_c() != Fluids.field_204541_a) {
            return false;
        }
        int xzDiff = 8;
        int yDiff = 5;
        BlockPos startPos = null;
        Direction riverSideDirection = null;
        for (int i = 0; i < config.field_204915_a; ++i) {
            BlockPos blockpos = pos.func_177982_a(rand.nextInt(xzDiff) - rand.nextInt(xzDiff), rand.nextInt(yDiff) - rand.nextInt(yDiff), rand.nextInt(xzDiff) - rand.nextInt(xzDiff));
            if (worldIn.func_175623_d(blockpos) && worldIn.func_180495_p(blockpos.func_177977_b()).func_200132_m()) {
                for (int j = 0; j < 4; ++j) {
                    Direction direction = Direction.func_176731_b((int)j);
                    if (worldIn.func_180495_p(blockpos.func_177977_b().func_177967_a(direction, 3)).func_204520_s().func_206886_c() != Fluids.field_204546_a) continue;
                    startPos = blockpos.func_177977_b().func_177967_a(direction, 2);
                    riverSideDirection = direction;
                    break;
                }
            }
            if (riverSideDirection != null) break;
        }
        int rockMinDistance = 0;
        int rockMaxDistance = 3;
        if (riverSideDirection != null) {
            ArrayList<Direction> allowedDirections = new ArrayList<Direction>();
            allowedDirections.add(Direction.NORTH);
            allowedDirections.add(Direction.SOUTH);
            allowedDirections.add(Direction.EAST);
            allowedDirections.add(Direction.WEST);
            allowedDirections.remove(riverSideDirection);
            allowedDirections.remove(riverSideDirection.func_176734_d());
            RockConfiguration configuration = configurations.get(Utilities.rint(0, configurations.size() - 1, rand));
            BlockPos.Mutable mutable = new BlockPos.Mutable(startPos);
            for (int i = 0; i < 100; ++i) {
                BlockPos.Mutable blockMutable = new BlockPos.Mutable((BlockPos)mutable);
                for (int j = 0; j < Utilities.rint(0, 5, rand); ++j) {
                    blockMutable.func_189534_c((Direction)allowedDirections.get(Utilities.rint(0, allowedDirections.size() - 1)), Utilities.rint(rockMinDistance, rockMaxDistance, rand));
                    BlockState state = configuration.getRandomBlock(rand, false);
                    if (state.func_177230_c() instanceof SlabBlock) {
                        worldIn.func_180501_a(blockMutable.func_177984_a(), (BlockState)state.func_206870_a((IProperty)SlabBlock.field_196505_a, (Comparable)SlabType.BOTTOM), 2);
                        continue;
                    }
                    worldIn.func_180501_a((BlockPos)blockMutable, state, 2);
                }
                mutable.func_189534_c(riverSideDirection, Utilities.rint(1, 3, rand));
                try {
                    if (!worldIn.func_201672_e().func_217354_b(mutable.func_177958_n() / 4, mutable.func_177952_p() / 4)) break;
                    if (worldIn.func_204610_c(mutable.func_177977_b()).func_206886_c() == Fluids.field_204546_a) continue;
                }
                catch (RuntimeException e) {}
                break;
            }
            return true;
        }
        return false;
    }

    static {
        configurations.add(new RockConfiguration(Blocks.field_150348_b.func_176223_P(), Blocks.field_150347_e.func_176223_P(), Blocks.field_150341_Y.func_176223_P(), Blocks.field_196646_bz.func_176223_P(), Blocks.field_222450_ln.func_176223_P()));
        configurations.add(new RockConfiguration(Blocks.field_196650_c.func_176223_P(), WNBlocks.GRANITE_COBBLE.func_176223_P(), WNBlocks.GRANITE_COBBLE_MOSSY.func_176223_P(), Blocks.field_222454_lr.func_176223_P(), WNBlocks.GRANITE_SLAB_COBBLE.func_176223_P(), WNBlocks.GRANITE_SLAB_COBBLE_MOSSY.func_176223_P()));
        configurations.add(new RockConfiguration(Blocks.field_196654_e.func_176223_P(), WNBlocks.DIORITE_COBBLE.func_176223_P(), WNBlocks.DIORITE_COBBLE_MOSSY.func_176223_P(), Blocks.field_222458_lv.func_176223_P(), WNBlocks.DIORITE_SLAB_COBBLE.func_176223_P(), WNBlocks.DIORITE_SLAB_COBBLE_MOSSY.func_176223_P()));
        configurations.add(new RockConfiguration(Blocks.field_196656_g.func_176223_P(), WNBlocks.ANDESITE_COBBLE.func_176223_P(), WNBlocks.ANDESITE_COBBLE_MOSSY.func_176223_P(), Blocks.field_222455_ls.func_176223_P(), WNBlocks.ANDESITE_SLAB_COBBLE.func_176223_P(), WNBlocks.ANDESITE_SLAB_COBBLE_MOSSY.func_176223_P()));
        configurations.add(new RockConfiguration(WNBlocks.MARBLE.func_176223_P(), WNBlocks.MARBLE_COBBLE.func_176223_P(), WNBlocks.MARBLE_COBBLE_MOSSY.func_176223_P(), WNBlocks.MARBLE_SLAB.func_176223_P(), WNBlocks.MARBLE_SLAB_COBBLE.func_176223_P(), WNBlocks.MARBLE_SLAB_COBBLE_MOSSY.func_176223_P()));
        configurations.add(new RockConfiguration(WNBlocks.GNEISS.func_176223_P(), WNBlocks.GNEISS_COBBLE.func_176223_P(), WNBlocks.GNEISS_COBBLE_MOSSY.func_176223_P(), WNBlocks.GNEISS_SLAB.func_176223_P(), WNBlocks.GNEISS_SLAB_COBBLE.func_176223_P(), WNBlocks.GNEISS_SLAB_COBBLE_MOSSY.func_176223_P()));
    }

    public static class RockConfiguration {
        private BlockState full;
        private BlockState cobble;
        private BlockState mossyCobble;
        private BlockState fullSlab;
        private BlockState cobbleSlab;
        private BlockState mossyCobbleSlab;
        private ArrayList<BlockState> states = new ArrayList();
        private ArrayList<BlockState> fullStates = new ArrayList();

        public RockConfiguration(BlockState full, BlockState cobble, BlockState mossyCobble, BlockState fullSlab, BlockState cobbleSlab, BlockState mossyCobbleSlab) {
            this.full = full;
            this.cobble = cobble;
            this.mossyCobble = mossyCobble;
            this.fullSlab = fullSlab;
            this.cobbleSlab = cobbleSlab;
            this.mossyCobbleSlab = mossyCobbleSlab;
            this.init();
        }

        public RockConfiguration(BlockState full, BlockState cobble, BlockState mossyCobble, BlockState cobbleSlab, BlockState mossyCobbleSlab) {
            this.full = full;
            this.cobble = cobble;
            this.mossyCobble = mossyCobble;
            this.cobbleSlab = cobbleSlab;
            this.mossyCobbleSlab = mossyCobbleSlab;
            this.init();
        }

        public RockConfiguration(BlockState full, BlockState fullSlab) {
            this.full = full;
            this.fullSlab = fullSlab;
            this.init();
        }

        public void init() {
            int i;
            if (this.full != null) {
                for (i = 0; i < 4; ++i) {
                    this.states.add(this.full);
                    this.fullStates.add(this.full);
                }
            }
            if (this.cobble != null) {
                for (i = 0; i < 2; ++i) {
                    this.states.add(this.cobble);
                    this.fullStates.add(this.cobble);
                }
            }
            if (this.mossyCobble != null) {
                this.states.add(this.mossyCobble);
                this.fullStates.add(this.mossyCobble);
            }
            if (this.cobbleSlab != null) {
                this.states.add(this.cobbleSlab);
            }
            if (this.mossyCobbleSlab != null) {
                this.states.add(this.mossyCobbleSlab);
            }
            if (this.fullSlab != null) {
                this.states.add(this.fullSlab);
            }
        }

        public BlockState getRandomBlock(Random random, boolean onlyFull) {
            if (onlyFull) {
                return this.fullStates.get(Utilities.rint(0, this.fullStates.size() - 1, random));
            }
            return this.states.get(Utilities.rint(0, this.states.size() - 1, random));
        }
    }
}

