/*
 * Decompiled with CFR 0.152.
 */
package com.matez.wildnature.world.generation.feature.features;

import com.matez.wildnature.util.other.Utilities;
import com.matez.wildnature.world.generation.feature.configs.WNBlobConfig;
import com.mojang.datafixers.Dynamic;
import java.util.ArrayList;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.block.FarmlandBlock;
import net.minecraft.block.GrassBlock;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.feature.Feature;
import net.minecraftforge.common.Tags;

public class WNBlobFeature
extends Feature<WNBlobConfig> {
    private ArrayList<BlockPos> filledBlocks = new ArrayList();

    public WNBlobFeature(Function<Dynamic<?>, ? extends WNBlobConfig> p_i49915_1_) {
        super(p_i49915_1_);
        this.setRegistryName("wildnature", "blob_feature");
    }

    public boolean place(IWorld world, ChunkGenerator<? extends GenerationSettings> generator, Random random, BlockPos pos, WNBlobConfig config) {
        this.filledBlocks.clear();
        while (true) {
            Block block;
            if (pos.func_177956_o() <= 3 || !world.func_175623_d(pos.func_177977_b()) && ((block = world.func_180495_p(pos.func_177977_b()).func_177230_c()) instanceof GrassBlock || WNBlobFeature.isDirt(block) || WNBlobFeature.isRock(block))) {
                if (pos.func_177956_o() <= 3) {
                    return false;
                }
                int lvt_6_2_ = config.startRadius;
                for (int lvt_7_1_ = 0; lvt_6_2_ >= 0 && lvt_7_1_ < 3; ++lvt_7_1_) {
                    int lvt_8_1_ = lvt_6_2_ + random.nextInt(2);
                    int lvt_9_1_ = lvt_6_2_ + random.nextInt(2);
                    int lvt_10_1_ = lvt_6_2_ + random.nextInt(2);
                    float lvt_11_1_ = (float)(lvt_8_1_ + lvt_9_1_ + lvt_10_1_) * 0.333f + 0.5f;
                    for (BlockPos blockPos : BlockPos.func_218278_a((BlockPos)pos.func_177982_a(-lvt_8_1_, -lvt_9_1_, -lvt_10_1_), (BlockPos)pos.func_177982_a(lvt_8_1_, lvt_9_1_, lvt_10_1_))) {
                        boolean canPlace;
                        if (!(blockPos.func_177951_i((Vec3i)pos) <= (double)(lvt_11_1_ * lvt_11_1_))) continue;
                        if (config.surfaceBlob) {
                            canPlace = !config.flatInTerrain || !Utilities.isBlockNear(world, blockPos, Blocks.field_150350_a);
                            if (!canPlace) continue;
                            if (world.func_180495_p(blockPos).func_200132_m()) {
                                if (!config.undergroundBlob) {
                                    if (world.func_180495_p(blockPos.func_177984_a()).func_200132_m() || world.func_180495_p(blockPos.func_177984_a()).func_177230_c() instanceof FarmlandBlock || world.func_180495_p(blockPos.func_177984_a()).func_177230_c() == Blocks.field_150355_j || world.func_180495_p(blockPos.func_177984_a()).func_177230_c() == Blocks.field_150353_l || world.func_180495_p(blockPos).func_177230_c().func_203417_a(BlockTags.field_200031_h) || world.func_180495_p(blockPos).func_177230_c().func_203417_a(BlockTags.field_206952_E)) continue;
                                    world.func_180501_a(blockPos, config.state, 4);
                                    world.func_180501_a(blockPos.func_177984_a(), Blocks.field_150350_a.func_176223_P(), 4);
                                    this.filledBlocks.add(blockPos);
                                    continue;
                                }
                                world.func_180501_a(blockPos, config.state, 4);
                                this.filledBlocks.add(blockPos);
                                continue;
                            }
                            if (world.func_180495_p(blockPos).func_177230_c() == Blocks.field_150355_j) {
                                world.func_180501_a(blockPos, Blocks.field_150355_j.func_176223_P(), 4);
                                continue;
                            }
                            world.func_180501_a(blockPos, Blocks.field_150350_a.func_176223_P(), 4);
                            continue;
                        }
                        canPlace = !config.flatInTerrain || !Utilities.isBlockNear(world, blockPos, Blocks.field_150350_a);
                        if (!canPlace) continue;
                        if (!config.undergroundBlob) {
                            if (world.func_180495_p(blockPos.func_177984_a()).func_200132_m() || world.func_180495_p(blockPos.func_177984_a()).func_177230_c() instanceof FarmlandBlock || world.func_180495_p(blockPos.func_177984_a()).func_177230_c() == Blocks.field_150355_j || world.func_180495_p(blockPos.func_177984_a()).func_177230_c() == Blocks.field_150353_l || world.func_180495_p(blockPos).func_177230_c().func_203417_a(BlockTags.field_200031_h) || world.func_180495_p(blockPos).func_177230_c().func_203417_a(BlockTags.field_206952_E)) continue;
                            world.func_180501_a(blockPos, config.state, 4);
                            world.func_180501_a(blockPos.func_177984_a(), Blocks.field_150350_a.func_176223_P(), 4);
                            this.filledBlocks.add(blockPos);
                            continue;
                        }
                        world.func_180501_a(blockPos, config.state, 4);
                        this.filledBlocks.add(blockPos);
                    }
                    pos = pos.func_177982_a(-(lvt_6_2_ + 1) + random.nextInt(2 + lvt_6_2_ * 2), 0 - random.nextInt(2), -(lvt_6_2_ + 1) + random.nextInt(2 + lvt_6_2_ * 2));
                }
                return true;
            }
            pos = pos.func_177977_b();
        }
    }

    public static boolean isRock(Block blockIn) {
        return Tags.Blocks.STONE.func_199685_a_((Object)blockIn);
    }

    public static boolean isDirt(Block blockIn) {
        return Tags.Blocks.DIRT.func_199685_a_((Object)blockIn);
    }

    public ArrayList<BlockPos> getFilledBlocks() {
        return this.filledBlocks;
    }
}

